/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.sexp.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public interface Referencer {
    public boolean pushContext(Object var1);

    public boolean popContext(Object var1);

    public String referenceFor(Object var1);

    public Map<String, Object> builtins();

    public static class LocalId
    implements Referencer {
        private final Stack<Integer> idStack = new Stack();

        public LocalId() {
            this.idStack.push(0);
        }

        @Override
        public boolean pushContext(Object object) {
            this.idStack.push(0);
            return false;
        }

        @Override
        public boolean popContext(Object object) {
            this.idStack.pop();
            this.idStack.push(this.idStack.pop() + 1);
            return false;
        }

        @Override
        public String referenceFor(Object object) {
            StringBuilder reference = new StringBuilder();
            Iterator i$ = this.idStack.iterator();
            while (i$.hasNext()) {
                int localId = (Integer)i$.next();
                reference.append("/");
                reference.append(localId);
            }
            return reference.toString();
        }

        @Override
        public Map<String, Object> builtins() {
            return Collections.emptyMap();
        }
    }

    public static class GlobalId
    implements Referencer {
        private int current = 0;

        @Override
        public boolean pushContext(Object object) {
            return false;
        }

        @Override
        public boolean popContext(Object object) {
            return false;
        }

        @Override
        public String referenceFor(Object object) {
            String id = Integer.toString(this.current);
            ++this.current;
            return id;
        }

        @Override
        public Map<String, Object> builtins() {
            return Collections.emptyMap();
        }
    }
}

