/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.generation.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Stack;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.generation.Merger;
import org.xid.basics.generation.java.Java;
import org.xid.basics.generation.java.JavaContentHandler;

public class JavaContentWriter
implements JavaContentHandler {
    private final String NL = System.getProperty("line.separator");
    private String charSet = "UTF-8";
    private ErrorHandler errorHandler = ErrorHandler.simple;
    private final StringBuilder currentPackage = new StringBuilder();
    private Stack<StringBuilder> packageContent = new Stack();
    private File currentFolder;
    private StringBuilder currentFileContent = new StringBuilder();
    private int importMark = -1;
    private final Stack<Type> context = new Stack();
    private boolean abstractMethod = false;
    private boolean firstEnumLiteral = false;
    private String appendPrefix = null;
    private Merger merger;

    public JavaContentWriter(File outputFolder) {
        if (outputFolder == null) {
            throw new NullPointerException("Output folder can't be null");
        }
        this.currentFolder = outputFolder;
    }

    public Merger getMerger() {
        return this.merger == null ? Merger.DEFAULT : this.merger;
    }

    public void setMerger(Merger merger) {
        this.merger = merger;
    }

    @Override
    public void beginPackage(String name) {
        for (String shortName : Java.splitPackageName(name)) {
            this.currentFolder = new File(this.currentFolder, shortName);
            if (!this.currentFolder.exists()) {
                this.currentFolder.mkdir();
            }
            if (this.currentPackage.length() != 0) {
                this.currentPackage.append(".");
            }
            this.currentPackage.append(shortName);
            this.pushContext(Type.PACKAGE);
        }
        this.packageContent.push(new StringBuilder());
    }

    @Override
    public void endPackage(String name) {
        StringBuilder currentPackageContent = this.packageContent.peek();
        if (currentPackageContent.length() > 0) {
            currentPackageContent.append(this.NL);
            currentPackageContent.append("package ");
            currentPackageContent.append(this.currentPackage.toString());
            currentPackageContent.append(";");
            currentPackageContent.append(this.NL);
            try {
                this.getMerger().merge(new File(this.currentFolder, "package-info.java"), currentPackageContent.toString(), this.charSet);
            }
            catch (Exception e) {
                this.errorHandler.handleError(2, e.getClass().getName() + ": " + e.getMessage());
                return;
            }
        }
        this.packageContent.pop();
        for (String shortName : Java.splitPackageName(name)) {
            this.currentFolder = this.currentFolder.getParentFile();
            int length = shortName.length();
            if (this.currentPackage.length() <= length) {
                this.currentPackage.delete(0, this.currentPackage.length());
            } else {
                this.currentPackage.delete(this.currentPackage.length() - (length + 1), this.currentPackage.length());
            }
            this.popContext(Type.PACKAGE);
        }
    }

    @Override
    public void beginFile(String name) {
        boolean javaFile;
        if (this.currentFileContent != null) {
            this.packageContent.peek().append((CharSequence)this.currentFileContent);
        }
        this.currentFileContent = new StringBuilder();
        this.importMark = -1;
        boolean bl = javaFile = name != null && name.toLowerCase().endsWith(".java");
        if (javaFile && this.currentPackage != null) {
            this.appendToFile("package ");
            this.appendToFile(this.currentPackage.toString());
            this.appendToFile(";");
        }
    }

    @Override
    public void endFile(String name) {
        try {
            this.getMerger().merge(new File(this.currentFolder, name), this.currentFileContent.toString(), this.charSet);
        }
        catch (Exception e) {
            this.errorHandler.handleError(2, e.getClass().getName() + ": " + e.getMessage());
            return;
        }
        this.currentFileContent = new StringBuilder();
    }

    @Override
    public void markImports() {
        this.importMark = this.currentFileContent.length();
        this.appendToFile(this.NL);
    }

    @Override
    public void import_(int flags, String importString) {
        StringBuilder builder = new StringBuilder();
        builder.append("import ");
        this.appendToFile(Java.printFlags(flags));
        builder.append(importString);
        builder.append(";");
        builder.append(this.NL);
        if (this.importMark >= 0) {
            this.currentFileContent.insert(this.importMark, builder);
        } else {
            this.appendToFile(builder.toString());
        }
    }

    @Override
    public void beginClass(int flags, String name, String parentClass, String implementedInterfaces) {
        this.appendToFile(Java.printFlags(flags));
        this.appendToFile("class ");
        this.appendToFile(name);
        if (parentClass != null && parentClass.length() > 0) {
            this.appendToFile(" extends ");
            this.appendToFile(parentClass);
        }
        if (implementedInterfaces != null && implementedInterfaces.length() > 0) {
            this.appendToFile(" implements ");
            this.appendToFile(implementedInterfaces);
        }
        this.appendToFile(" {");
        this.pushContext(Type.CLASS);
    }

    @Override
    public void endClass(String name) {
        this.appendToFile("}");
        this.popContext(Type.CLASS);
    }

    @Override
    public void beginInterface(int flags, String name, String extendedInterfaces) {
        this.appendToFile(Java.printFlags(flags));
        this.appendToFile("interface ");
        this.appendToFile(name);
        if (extendedInterfaces != null && extendedInterfaces.length() > 0) {
            this.appendToFile(" extends ");
            this.appendToFile(extendedInterfaces);
        }
        this.appendToFile(" {");
        this.pushContext(Type.INTERFACE);
    }

    @Override
    public void endInterface(String name) {
        this.appendToFile("}");
        this.popContext(Type.INTERFACE);
    }

    @Override
    public void beginEnum(int flags, String name) {
        this.appendToFile(Java.printFlags(flags));
        this.appendToFile("enum ");
        this.appendToFile(name);
        this.appendToFile(" {");
        this.pushContext(Type.ENUM);
    }

    @Override
    public void beginEnumLiterals() {
        this.firstEnumLiteral = true;
    }

    @Override
    public void enumLiteral(String name, String ... arguments) {
        if (!this.firstEnumLiteral) {
            this.appendToFile(",");
        }
        this.appendToFile(name);
        if (arguments != null && arguments.length > 0) {
            this.appendToFile("(");
            for (int i = 0; i < arguments.length; ++i) {
                if (i > 0) {
                    this.appendToFile(", ");
                }
                this.appendToFile(arguments[i]);
            }
            this.appendToFile(")");
        }
        this.firstEnumLiteral = false;
    }

    @Override
    public void endEnumLiterals() {
        this.appendToFile(";");
    }

    @Override
    public void endEnum(String name) {
        this.appendToFile("}");
        this.popContext(Type.ENUM);
    }

    @Override
    public void beginAnonymousClass(String inherited, String ... arguments) {
        this.appendToFile("new ");
        this.appendToFile(inherited);
        this.appendToFile("(");
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                this.appendToFile(", ");
            }
            this.appendToFile(arguments[i]);
        }
        this.appendToFile(") {");
        this.pushContext(Type.CLASS);
    }

    @Override
    public void endAnnonymousClass(String inherited) {
        this.appendToFile("}");
        this.popContext(Type.CLASS);
    }

    @Override
    public void beginMethod(int flags, String returnType, String name, String exceptions, Java.Parameter ... parameters) {
        this.appendToFile(Java.printFlags(flags));
        if (returnType != null) {
            this.appendToFile(returnType);
            this.appendToFile(" ");
        }
        this.appendToFile(name);
        this.appendToFile("(");
        for (int i = 0; i < parameters.length; ++i) {
            Java.Parameter parameter = parameters[i];
            this.appendToFile(Java.printFlags(parameter.flags));
            this.appendToFile(parameter.type);
            this.appendToFile(" ");
            this.appendToFile(parameter.name);
            if (i + 1 >= parameters.length) continue;
            this.appendToFile(", ");
        }
        this.appendToFile(")");
        if (exceptions != null && exceptions.length() > 0) {
            this.appendToFile(" throws ");
            this.appendToFile(exceptions);
        }
        this.abstractMethod = Java.has(flags, 32);
        if (this.context.peek() == Type.INTERFACE || this.abstractMethod) {
            this.appendToFile(";");
        } else {
            this.appendToFile(" {");
        }
        this.pushContext(Type.METHOD);
    }

    @Override
    public void endMethod(String name) {
        this.popContext(Type.METHOD);
        if (this.context.peek() != Type.INTERFACE && !this.abstractMethod) {
            this.appendToFile("}");
        }
    }

    @Override
    public void beginAttribute(int flags, String type, String name) {
        this.appendToFile(Java.printFlags(flags));
        this.appendToFile(type);
        this.appendToFile(" ");
        this.appendToFile(name);
        this.pushContext(Type.ATTRIBUTE);
        this.appendPrefix = " = ";
    }

    @Override
    public void endAttribute(String name) {
        this.appendPrefix = null;
        this.popContext(Type.ATTRIBUTE);
        this.appendToFile(";");
    }

    public void beginBlock(int flags) {
        this.appendToFile(Java.printFlags(flags));
        this.appendToFile("{");
    }

    public void endBlock() {
        this.appendToFile("}");
    }

    @Override
    public void annotation(String name, String parameters) {
        this.appendToFile("@");
        this.appendToFile(name);
        if (parameters != null) {
            this.appendToFile("(");
            this.appendToFile(parameters);
            this.appendToFile(")");
        }
        this.appendToFile(this.NL);
    }

    @Override
    public void codeln(int level, String code) {
        this.appendToFile(code);
    }

    @Override
    public void code(String code) {
        this.appendToFile(code);
    }

    @Override
    public void comment(int type, int level, String comment) {
        switch (type) {
            case 1: {
                this.appendToFile("//");
                this.appendToFile(comment);
                this.appendToFile(this.NL);
                break;
            }
            case 2: {
                this.appendToFile("/*");
                this.appendToFile(comment);
                this.appendToFile("*/");
                break;
            }
            case 3: {
                this.appendToFile("/**\n");
                this.appendToFile("\n * ");
                this.appendToFile(comment);
                this.appendToFile("*/");
            }
        }
    }

    @Override
    public void binaryFile(File file) {
        File destinationFile = new File(this.currentFolder, file.getName());
        this.copyFile(file, destinationFile);
    }

    @Override
    public void documentFile(File file) {
        String docfiles = "doc-files";
        File docFilesDirectory = new File(this.currentFolder, docfiles);
        if (!docFilesDirectory.exists()) {
            docFilesDirectory.mkdir();
        }
        File destinationFile = new File(docFilesDirectory, file.getName());
        this.copyFile(file, destinationFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File sourceFile, File destinationFile) {
        try {
            FileInputStream inputStream = new FileInputStream(sourceFile);
            FileOutputStream outputStream = new FileOutputStream(destinationFile);
            try {
                byte[] buf = new byte[2048];
                int i = 0;
                while ((i = inputStream.read(buf)) != -1) {
                    outputStream.write(buf, 0, i);
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (IOException e) {
            this.errorHandler.handleError(2, e.getClass().getName() + ": " + e.getMessage());
            return;
        }
    }

    private void pushContext(Type type) {
        this.context.push(type);
    }

    private void popContext(Type expected) {
        Type current;
        if (this.context.isEmpty()) {
            this.errorHandler.handleError(2, "Closing a not openned " + (Object)((Object)expected) + ".");
        }
        if (expected != (current = this.context.pop())) {
            this.errorHandler.handleError(2, "Closing a " + (Object)((Object)current) + " while expecting a " + (Object)((Object)expected) + ".");
        }
    }

    private void appendToFile(String text) {
        if (this.appendPrefix != null) {
            this.currentFileContent.append(this.appendPrefix);
            this.appendPrefix = null;
        }
        this.currentFileContent.append(text);
    }

    private static enum Type {
        PACKAGE,
        CLASS,
        INTERFACE,
        ENUM,
        METHOD,
        ATTRIBUTE;

    }
}

