/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.printer.fiacre;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.toolbox.tools.analysis.basic.ReceivedEventsAnalysis;
import fr.ensta.aefd.toolbox.tools.printer.fiacre.HelperBus;
import java.util.Set;
import obp.fiacre.model.Constr;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.ConstrPattern;
import obp.fiacre.model.Exp;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.Union;

public class EventUnionDeclaration
extends HelperBus.Abstract {
    public static final String NO_EVENT = "NO_EVENT";
    private final ReceivedEventsAnalysis events = new ReceivedEventsAnalysis();
    private Union eventUnion;
    private TypeDecl unionDeclaration;
    private TypeId unionTypeId;
    private Queue fifoType;
    private TypeDecl fifoTypeDeclaration;
    private TypeId fifoTypeId;
    private String unionName;
    private String fifoTypeName;

    public EventUnionDeclaration(HelperBus helper) {
        super(helper);
    }

    public void generate(AEFDModel model, String unionName, String fifoTypeName) {
        this.unionName = unionName;
        this.fifoTypeName = fifoTypeName;
        this.eventUnion = new Union();
        this.events.analyze(model);
        this.addConstructors();
        this.buildUnionDeclaration();
        this.buildUnionTypeId();
        this.buildFifoType();
        this.buildFifoTypeDeclaration();
        this.buildFifoTypeId();
    }

    private void addConstructors() {
        Constr noEventConstr = new Constr();
        noEventConstr.setName(NO_EVENT);
        this.eventUnion.addConstr(noEventConstr);
        for (AEFDFunctionalEntity functionalEntity : this.events.getReceivedEvents()) {
            Constr constructor = new Constr();
            constructor.setName(this.getEventName(functionalEntity));
            this.eventUnion.addConstr(constructor);
        }
    }

    private void buildUnionDeclaration() {
        this.unionDeclaration = new TypeDecl();
        this.unionDeclaration.setName(this.unionName);
        this.unionDeclaration.setIs((Type)this.eventUnion);
    }

    public Set<AEFDFunctionalEntity> getAllEvents() {
        return this.events.getReceivedEvents();
    }

    public Set<AEFDAutomate> getTargets(AEFDFunctionalEntity functionalEntity) {
        return this.events.getTargets(functionalEntity);
    }

    public Set<AEFDTransition> getSensibleTransitions(AEFDAutomate automate, AEFDFunctionalEntity functionalEntity) {
        return this.events.getSensibleTransitions(automate, functionalEntity);
    }

    public Set<AEFDFunctionalEntity> getInputs(AEFDAutomate automate) {
        return this.events.getInputs(automate);
    }

    public TypeDecl getUnionDeclaration() {
        return this.unionDeclaration;
    }

    private void buildUnionTypeId() {
        this.unionTypeId = new TypeId();
        this.unionTypeId.setDecl(this.unionDeclaration);
    }

    public TypeId getUnionTypeId() {
        return this.unionTypeId;
    }

    public ConstrExp getConstrExp(String eventName) {
        ConstrExp constrLiteral = new ConstrExp();
        constrLiteral.setName(eventName);
        return constrLiteral;
    }

    public ConstrExp getConstrExp(AEFDFunctionalEntity event) {
        return this.getConstrExp(this.getEventName(event));
    }

    public ConstrPattern getConstrPattern(String eventName) {
        ConstrPattern result = new ConstrPattern();
        result.setName(eventName);
        return result;
    }

    public ConstrPattern getConstrPattern(AEFDFunctionalEntity event) {
        return this.getConstrPattern(this.getEventName(event));
    }

    public String getEventName(AEFDFunctionalEntity event) {
        int param_index = event.getIdentifier().indexOf("(");
        return param_index == -1 ? event.getIdentifier() : event.getIdentifier().substring(0, param_index);
    }

    private void buildFifoType() {
        this.fifoType = new Queue();
        NatLiteral size = new NatLiteral();
        size.setValue(5);
        this.fifoType.setSize((Exp)size);
        this.fifoType.setType((Type)this.unionTypeId);
    }

    private void buildFifoTypeDeclaration() {
        this.fifoTypeDeclaration = new TypeDecl();
        this.fifoTypeDeclaration.setName(this.fifoTypeName);
        this.fifoTypeDeclaration.setIs((Type)this.fifoType);
    }

    public TypeDecl getFifoTypeDeclaration() {
        return this.fifoTypeDeclaration;
    }

    private void buildFifoTypeId() {
        this.fifoTypeId = new TypeId();
        this.fifoTypeId.setDecl(this.fifoTypeDeclaration);
    }

    public TypeId getFifoTypeId() {
        return this.fifoTypeId;
    }
}

