/*
 * Decompiled with CFR 0.152.
 */
package plug.language.buchikripke.runtime;

import java.util.Arrays;
import java.util.Collection;
import plug.core.ILanguagePlugin;
import plug.core.IRuntimeView;
import plug.core.execution.ExecutionDescription;
import plug.explorer.BFSExplorer;
import plug.explorer.DFSExplorer;
import plug.explorer.buchi.nested_dfs.BA_GaiserSchwoon_Iterative;
import plug.language.buchikripke.runtime.KripkeBuchiLoader;
import plug.language.buchikripke.runtime.KripkeBuchiProductSemantics;
import plug.language.buchikripke.runtime.KripkeBuchiRuntimeView;
import plug.verifiers.deadlock.DeadlockVerifier;

public class KripkeBuchiPlugin
implements ILanguagePlugin<KripkeBuchiProductSemantics> {
    private final KripkeBuchiLoader loader = new KripkeBuchiLoader();

    public String[] getExtensions() {
        return new String[]{".buchi"};
    }

    public String getName() {
        return "Buchi";
    }

    public KripkeBuchiLoader getLoader() {
        return this.loader;
    }

    public IRuntimeView getRuntimeView(KripkeBuchiProductSemantics runtime) {
        return new KripkeBuchiRuntimeView(runtime);
    }

    public Collection<ExecutionDescription> executions() {
        return Arrays.asList(new ExecutionDescription("BFS Explorer", BFSExplorer::new), new ExecutionDescription("Deadlocks", DeadlockVerifier::bfs), new ExecutionDescription("DFS Explorer", DFSExplorer::new), new ExecutionDescription("GaiserSchwoon", BA_GaiserSchwoon_Iterative::new));
    }
}

