/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cte.ABCD.builder.Builder;
import org.cte.ABCD.model.declarations.Field;
import org.cte.ABCD.model.declarations.FunctionDecl;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.TypeDecl;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.expressions.BinaryOperator;
import org.cte.ABCD.model.expressions.UnaryOperator;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Statement;
import org.cte.ABCD.model.kernel.Type;
import org.cte.ABCD.model.statements.Block;
import org.cte.ABCD.model.statements.CaseItem;
import org.cte.ABCD.model.statements.Transition;
import org.cte.ABCD.model.types.Union;

public class ComplexBuilder {
    private Builder b = new Builder();

    public ComplexBuilder(List<Type> primitiveTypes) {
        this.b = new Builder(primitiveTypes);
    }

    public FunctionDecl createDeferredHandler(String uniqueId, Union vocabulary, TypeDecl eventPoolType, TypeDecl deferMaskType) {
        ParameterDecl eventPool = this.b.parameterDecl("eventPool", eventPoolType);
        ParameterDecl deferMask = this.b.parameterDecl("deferMask", deferMaskType);
        VariableDecl deferred = this.b.variableDecl("deferred", eventPoolType, this.b.queueLiteral(new Expression[0]));
        VariableDecl result = this.b.variableDecl("result", eventPoolType, this.b.queueLiteral(new Expression[0]));
        VariableDecl continueV = this.b.variableDecl("continue", this.b.boolType(), this.b.literal(true));
        ArrayList<CaseItem> items = new ArrayList<CaseItem>();
        int idx = 0;
        for (Field field : vocabulary.getFieldsList()) {
            items.add(this.b.caseItem((Expression)(field.getType() == null ? this.b.unionLiteral(vocabulary, field.getName(), null) : this.b.unionLiteral(vocabulary, field.getName(), this.b.any())), (Statement)this.b.ifStmt(this.b.indexedExp(this.b.reference(deferMask), this.b.literal(idx++)), this.b.block(this.b.enqueue(deferred, this.b.first(this.b.reference(eventPool))), this.b.assign(this.b.reference(eventPool), this.b.dequeue(this.b.reference(eventPool)))), this.b.assign(this.b.reference(continueV), this.b.literal(false)))));
        }
        Block body = this.b.block(this.b.whileStmt(this.b.and(this.b.not(this.b.empty(this.b.reference(eventPool))), this.b.reference(continueV)), this.b.block(this.b.caseStmt(this.b.first(this.b.reference(eventPool)), items))), this.b.ifStmt(this.b.not(this.b.empty(this.b.reference(eventPool))), this.b.block(this.b.enqueue(result, this.b.first(this.b.reference(eventPool))), this.b.assign(this.b.reference(eventPool), this.b.dequeue(this.b.reference(eventPool)))), null), this.b.whileStmt(this.b.not(this.b.empty(this.b.reference(deferred))), this.b.block(this.b.enqueue(result, this.b.first(this.b.reference(deferred))), this.b.assign(this.b.reference(deferred), this.b.dequeue(this.b.reference(deferred))))), this.b.whileStmt(this.b.not(this.b.empty(this.b.reference(eventPool))), this.b.block(this.b.enqueue(result, this.b.first(this.b.reference(eventPool))), this.b.assign(this.b.reference(eventPool), this.b.dequeue(this.b.reference(eventPool))))), this.b.returnStmt(this.b.reference(result)));
        FunctionDecl func = this.b.functionDecl("preprocessDeferred_" + uniqueId, new ParameterDecl[]{eventPool, deferMask}, (Type)eventPoolType, new VariableDecl[]{deferred, result, continueV}, body);
        return func;
    }

    public ProcessDecl semaphore(String name, int pClients, int vClients) {
        Port p;
        int idx;
        ParameterDecl size = this.b.parameterDecl("size", this.b.intType());
        VariableDecl delta = this.b.lttVariableDecl("delta", this.b.intType(), this.b.literal(0));
        VariableDecl count = this.b.variableDecl("count", this.b.intType(), this.b.reference(size));
        ArrayList<Port> portList = new ArrayList<Port>(pClients + vClients);
        ArrayList<Statement> blockList = new ArrayList<Statement>(pClients + vClients);
        for (idx = 0; idx < pClients; ++idx) {
            p = this.b.port("p" + idx, this.b.intType(), true);
            blockList.add(this.semaphorePBlock(p, delta, count));
            portList.add(p);
        }
        for (idx = 0; idx < vClients; ++idx) {
            p = this.b.port("v" + idx, this.b.intType(), true);
            blockList.add(this.semaphoreVBlock(p, delta, count));
            portList.add(p);
        }
        ProcessDecl process = this.b.process(name, portList, Arrays.asList(size), Arrays.asList(delta, count));
        Transition dispatch = this.b.transition("dispatch", process);
        dispatch.setBehavior(this.b.block(this.b.select(blockList), this.b.loopOn(dispatch)));
        return process;
    }

    private Statement semaphorePBlock(Port p, VariableDecl delta, VariableDecl count) {
        return this.b.ifStmt(this.b.expression(BinaryOperator.BGT, this.b.reference(count), this.b.literal(0)), this.b.block(this.b.input(p, this.b.reference(delta)), this.b.decrement(count, this.b.reference(delta))), null);
    }

    private Statement semaphoreVBlock(Port p, VariableDecl delta, VariableDecl count) {
        return this.b.block(this.b.input(p, this.b.reference(delta)), this.b.increment(count, this.b.reference(delta)));
    }

    public ProcessDecl mutex(String name, int size) {
        VariableDecl locked = this.b.variableDecl("locked", this.b.boolType(), this.b.literal(false));
        VariableDecl owner = this.b.variableDecl("id", this.b.intervalType(0, size), this.b.literal(0));
        Port[] ports = new Port[size * 2];
        Statement[] blocks = new Statement[size * 2];
        for (int idx = 0; idx < size; ++idx) {
            Port lock = this.b.port("lock" + idx, this.b.noneType(), true);
            Port unlock = this.b.port("unlock" + idx, this.b.noneType(), true);
            blocks[2 * idx] = this.mutexLockBlock(idx + 1, lock, locked, owner);
            blocks[2 * idx + 1] = this.mutexUnlockBlock(idx + 1, unlock, locked, owner);
            ports[2 * idx] = lock;
            ports[2 * idx + 1] = unlock;
        }
        ProcessDecl process = this.b.process(name, Arrays.asList(ports), null, Arrays.asList(locked, owner));
        Transition dispatch = this.b.transition("dispatch", process);
        dispatch.setBehavior(this.b.block(this.b.select(blocks), this.b.loopOn(dispatch)));
        return process;
    }

    private Statement mutexLockBlock(int id, Port port, VariableDecl locked, VariableDecl owner) {
        return this.b.ifStmt(this.b.expression(UnaryOperator.UNOT, this.b.reference(locked)), this.b.block(this.b.input(port), this.b.assign(this.b.reference(locked), this.b.literal(true)), this.b.assign(this.b.reference(owner), this.b.literal(id))), null);
    }

    private Statement mutexUnlockBlock(int id, Port port, VariableDecl locked, VariableDecl owner) {
        return this.b.block(this.b.input(port), this.b.ifStmt(this.b.expression(BinaryOperator.BEQ, this.b.reference(owner), this.b.literal(id)), this.b.block(this.b.assign(this.b.reference(locked), this.b.literal(false)), this.b.assign(this.b.reference(owner), this.b.literal(0))), null));
    }

    public ProcessDecl timerStatic(String name, Expression delay) {
        Port start = this.b.port("start", this.b.noneType(), true);
        Port stop = this.b.port("stop", this.b.noneType(), true);
        Port timeout = this.b.port("timeout", this.b.noneType(), true);
        ProcessDecl node = this.b.process(name, Arrays.asList(start, stop, timeout), null, null);
        String startS = "startT";
        String waitS = "waitT";
        String timeoutS = "timeoutT";
        Transition startT = this.b.transition(startS, node);
        startT.setBehavior(this.b.block(this.b.input(start, null), this.b.toState(waitS, node)));
        Transition waitT = this.b.transition(waitS, node);
        waitT.setBehavior(this.b.block(this.b.select(this.b.block(this.b.wait(delay, delay), this.b.toState(timeoutS, node)), this.b.block(this.b.input(stop, null), this.b.toState(startS, node)))));
        Transition timeoutT = this.b.transition(timeoutS, node);
        timeoutT.setBehavior(this.b.block(this.b.output(timeout), this.b.toState(startS, node)));
        return node;
    }

    public ProcessDecl timerDiscrete(String name) {
        Port start = this.b.port("start", this.b.natType(), true);
        Port stop = this.b.port("stop", this.b.noneType(), true);
        Port timeout = this.b.port("timeout", this.b.noneType(), true);
        VariableDecl delay = this.b.variableDecl("delay", this.b.natType(), this.b.literal(0));
        ProcessDecl process = this.b.process(name, Arrays.asList(start, stop, timeout), null, Arrays.asList(delay));
        String startS = "startT";
        String waitS = "waitT";
        String timeoutS = "timeoutT";
        Transition startT = this.b.transition(startS, process);
        startT.setBehavior(this.timerStartBlock(start, delay, waitS, process));
        Transition waitT = this.b.transition(waitS, process);
        waitT.setBehavior(this.b.block(this.b.select(this.timerAdvanceTime(delay, timeoutS, waitS, process), this.timerStopBlock(stop, startS, process))));
        Transition timeoutT = this.b.transition(timeoutS, process);
        timeoutT.setBehavior(this.timerTimeoutBlock(timeout, startS, process));
        return process;
    }

    public ProcessDecl timerDiscrete(String name, int numStarts, int numStops, int numTimeouts) {
        VariableDecl delay = this.b.variableDecl("delay", this.b.natType(), this.b.literal(0));
        ProcessDecl process = this.b.process(name, null, null, Arrays.asList(delay));
        String startS = "startT";
        String waitS = "waitT";
        String timeoutS = "timeoutT";
        ArrayList<Port> portList = new ArrayList<Port>(numStarts + numStops + numTimeouts);
        ArrayList<Statement> blocks = new ArrayList<Statement>(numStarts);
        for (int idx = 0; idx < numStarts; ++idx) {
            Port p = this.b.port("start" + idx, this.b.natType(), true);
            blocks.add(this.timerStartBlock(p, delay, waitS, process));
            portList.add(p);
        }
        Transition startT = this.b.transition(startS, process);
        startT.setBehavior(this.b.block(blocks.size() == 1 ? (Statement)blocks.get(0) : this.b.select(blocks)));
        blocks = new ArrayList(numStops);
        for (int idx = 0; idx < numStops; ++idx) {
            Port p = this.b.port("stop" + idx, this.b.noneType(), true);
            blocks.add(this.timerStopBlock(p, startS, process));
            portList.add(p);
        }
        blocks.add(this.timerAdvanceTime(delay, timeoutS, waitS, process));
        Transition stopT = this.b.transition(waitS, process);
        stopT.setBehavior(this.b.block(this.b.select(blocks)));
        blocks = new ArrayList(numTimeouts);
        for (int idx = 0; idx < numTimeouts; ++idx) {
            Port p = this.b.port("timeout" + idx, this.b.noneType(), false);
            blocks.add(this.timerTimeoutBlock(p, startS, process));
            portList.add(p);
        }
        Transition timeoutT = this.b.transition(timeoutS, process);
        timeoutT.setBehavior(this.b.block(blocks.size() == 1 ? (Statement)blocks.get(0) : this.b.select(blocks)));
        process.addAllPortsAndOpposite(portList);
        return process;
    }

    private Block timerStartBlock(Port start, VariableDecl delay, String toState, ProcessDecl process) {
        return this.b.block(this.b.input(start, this.b.reference(delay)), this.b.toState(toState, process));
    }

    private Block timerStopBlock(Port stop, String toState, ProcessDecl process) {
        return this.b.block(this.b.input(stop), this.b.toState(toState, process));
    }

    private Block timerTimeoutBlock(Port timeout, String toState, ProcessDecl process) {
        return this.b.block(this.b.output(timeout), this.b.toState(toState, process));
    }

    private Block timerAdvanceTime(VariableDecl delay, String timeoutS, String waitS, ProcessDecl process) {
        return this.b.block(this.b.ifStmt(this.b.expression(BinaryOperator.BLT, this.b.reference(delay), this.b.literal(1)), this.b.toState(timeoutS, process), null), this.b.wait(this.b.literal(1), this.b.literal(1)), this.b.assign(this.b.reference(delay), this.b.expression(BinaryOperator.BMINUS, this.b.reference(delay), this.b.literal(1))), this.b.toState(waitS, process));
    }
}

