/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.behaviour.actions.matchedEvents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.behaviour.actions.InputAction;
import obp.if2.behaviour.actions.MatchAction;
import obp.if2.data.Expression;

public class MatchInputAction
extends MatchAction {
    private InputAction event;
    private final List<Expression> parametersList = new ArrayList<Expression>();
    private Expression in;

    public InputAction getEvent() {
        return this.event;
    }

    public void setEvent(InputAction newValue) {
        if (this.event == null ? newValue != null : !this.event.equals(newValue)) {
            this.event = newValue;
        }
    }

    public List<Expression> getParametersList() {
        return Collections.unmodifiableList(this.parametersList);
    }

    public int getParametersCount() {
        return this.parametersList.size();
    }

    public Expression getParameters(int index) {
        if (index < 0 || index >= this.getParametersCount()) {
            return null;
        }
        return this.parametersList.get(index);
    }

    public void addParameters(Expression newValue) {
        this.addParameters(this.getParametersCount(), newValue);
    }

    public void addParameters(int index, Expression newValue) {
        this.parametersList.add(index, newValue);
    }

    public Expression setParameters(int index, Expression newValue) {
        return this.parametersList.set(index, newValue);
    }

    public void addAllParameters(Collection<Expression> toAddList) {
        for (Expression newValue : toAddList) {
            this.addParameters(this.getParametersCount(), newValue);
        }
    }

    public void removeParameters(Expression value) {
        int index = this.parametersList.indexOf(value);
        if (index >= 0) {
            this.removeParameters(index);
        }
    }

    public void removeParameters(int index) {
        this.parametersList.remove(index);
    }

    public Expression getIn() {
        return this.in;
    }

    public void setIn(Expression newValue) {
        if (this.in == null ? newValue != null : !this.in.equals(newValue)) {
            this.in = newValue;
        }
    }

    @Override
    public void accept(If2Visitor visitor) {
        visitor.visitMatchInputAction(this);
    }
}

