/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.compiler;

import java.util.Map;
import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.checker.type.CExisting;
import obp.fiacre.checker.type.CInt;
import obp.fiacre.checker.type.CType;
import obp.fiacre.compiler.ExpressionGenerator;
import obp.fiacre.compiler.ProgramGenerator;
import obp.fiacre.compiler.TypeGenerator;
import obp.fiacre.model.AnyPattern;
import obp.fiacre.model.ArrayPattern;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.ConstrPattern;
import obp.fiacre.model.Exp;
import obp.fiacre.model.FieldPattern;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.Type;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Variable;
import obp.fiacre.util.TypeUtil;
import org.xid.basics.generation.java.JavaContentHandler;

public class AssignmentGenerator
extends ModelVisitor.Stub {
    private final ProgramGenerator caller;
    private final JavaContentHandler content;
    private VarRef reference;
    private boolean needCopy;
    private StringBuilder left;
    private Mode generationMode;

    public AssignmentGenerator(ProgramGenerator caller) {
        this.caller = caller;
        this.content = caller.getContent();
    }

    public Map<Type, String> getTypeNames() {
        return this.caller.getTypeNames();
    }

    public ExpressionGenerator getExpressionGenerator() {
        return this.caller.getExpressionGenerator();
    }

    public TypeGenerator getTypeGenerator() {
        return this.caller.getTypeGenerator();
    }

    public void generateForTransition(int level, Pattern pattern, String expression) {
        this.generationMode = Mode.Transition;
        this.generate(level, pattern, expression);
    }

    public void generateForFunction(int level, Pattern pattern, String expression) {
        this.generationMode = Mode.Function;
        this.generate(level, pattern, expression);
    }

    private void generate(int level, Pattern pattern, String expression) {
        Variable variable;
        Type type;
        this.needCopy = false;
        this.reference = null;
        this.left = new StringBuilder();
        pattern.accept(this);
        if (this.needCopy && !TypeUtil.isPrimitiveJavaType(type = (variable = this.reference.getDecl()).getType())) {
            String tmpName = "__tmp";
            String name = null;
            switch (this.generationMode) {
                case Transition: {
                    name = this.getExpressionGenerator().generateForBehavior(new CExisting(type), this.reference);
                    break;
                }
                case Function: {
                    name = this.getExpressionGenerator().generateForFunction(new CExisting(type), this.reference);
                }
            }
            this.content.comment(1, level, "Start copy variable '" + name + "'.");
            this.content.codeln(level, "{");
            this.content.codeln(level + 1, TypeUtil.toJavaDeclaration(type, this.getTypeNames()) + " " + tmpName + ";");
            this.getTypeGenerator().copyCode(level + 1, type, tmpName, name);
            this.content.codeln(level + 1, name + " = " + tmpName + ";");
            this.content.codeln(level, "}");
            this.content.comment(1, level, "End copy variable '" + name + "'.");
        }
        StringBuilder code = new StringBuilder();
        if (this.left.length() > 0) {
            code.append((CharSequence)this.left);
            code.append(" = ");
        }
        code.append(expression);
        code.append(";");
        this.content.codeln(level, code.toString());
    }

    private String generateExpression(CType type, Exp exp) {
        if (this.generationMode == Mode.Function) {
            return this.getExpressionGenerator().generateForFunction(type, exp);
        }
        return this.getExpressionGenerator().generateForBehavior(type, exp);
    }

    public String leftPart(Pattern pattern) {
        this.needCopy = false;
        this.reference = null;
        this.left = new StringBuilder();
        pattern.accept(this);
        return this.left.toString();
    }

    @Override
    public void visitAnyPattern(AnyPattern toVisit) {
    }

    @Override
    public void visitVarRef(VarRef toVisit) {
        this.reference = toVisit;
        if (toVisit.getDecl() instanceof LocalVariable) {
            LocalVariable local = (LocalVariable)toVisit.getDecl();
            if (this.caller.getVariableAnalyser().isConfigurationVariable(local) && this.generationMode == Mode.Transition) {
                this.left.append("me.");
            }
        }
        this.left.append(NameUtil.uncapName(toVisit.getDecl().getName()));
    }

    @Override
    public void visitArrayPattern(ArrayPattern toVisit) {
        this.needCopy = true;
        toVisit.getArray().accept(this);
        this.left.append("[");
        this.left.append(this.generateExpression(CInt.intType, toVisit.getIndex()));
        this.left.append("]");
    }

    @Override
    public void visitFieldPattern(FieldPattern toVisit) {
        this.needCopy = true;
        toVisit.getRecord().accept(this);
        this.left.append(".");
        this.left.append(NameUtil.uncapName(toVisit.getField()));
    }

    @Override
    public void visitBoolLiteral(BoolLiteral toVisit) {
        throw new IllegalArgumentException(toVisit.getClass().getSimpleName() + " can't be assigned.");
    }

    @Override
    public void visitNatLiteral(NatLiteral toVisit) {
        throw new IllegalArgumentException(toVisit.getClass().getSimpleName() + " can't be assigned.");
    }

    @Override
    public void visitConstantRef(ConstantRef toVisit) {
        throw new IllegalArgumentException(toVisit.getClass().getSimpleName() + " can't be assigned.");
    }

    @Override
    public void visitConstrPattern(ConstrPattern toVisit) {
        throw new IllegalArgumentException(toVisit.getClass().getSimpleName() + " can't be assigned.");
    }

    public static enum Mode {
        Transition,
        Function;

    }
}

