/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.util;

import java.util.ArrayList;
import java.util.List;
import obp.explorer.runtime.obs.Action;
import obp.explorer.runtime.obs.AtomicAction;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;

public class ActionUtil {
    public static void writeList(Boost boost, List<Action> actionList) {
        if (actionList == null) {
            boost.writeInt(-1);
        } else {
            boost.writeInt(actionList.size());
            for (Action action : actionList) {
                ActionUtil.write(boost, action);
            }
        }
    }

    public static List<Action> readList(Boost boost) {
        int count = boost.readInt();
        if (count < 0) {
            return null;
        }
        ArrayList<Action> actionList = new ArrayList<Action>(count);
        for (int i = 0; i < count; ++i) {
            actionList.add(ActionUtil.read(boost));
        }
        return actionList;
    }

    public static void write(Boost boost, Action action) {
        if (action.atomicActions == null) {
            boost.writeInt(0);
        } else {
            boost.writeInt(action.atomicActions.size());
            for (AtomicAction atomic : action.atomicActions) {
                boost.writeObject((BoostObject)atomic);
            }
        }
        boost.writeInt(action.targetId);
    }

    public static Action read(Boost boost) {
        int count = boost.readInt();
        if (count < 0) {
            return null;
        }
        ArrayList<AtomicAction> atomics = new ArrayList<AtomicAction>(count);
        for (int i = 0; i < count; ++i) {
            atomics.add((AtomicAction)boost.readObject(AtomicAction.class));
        }
        int targetId = boost.readInt();
        return new Action(atomics, targetId);
    }

    public static void writeValueArray(Boost boost, Object[] array) {
        if (array == null) {
            boost.writeInt(0);
            return;
        }
        boost.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            ActionUtil.writeValue(boost, array[i]);
        }
    }

    public static void writeValue(Boost boost, Object value) {
        Class<?> messageClass;
        Class<?> clazz = messageClass = value == null ? null : value.getClass();
        if (messageClass == Boolean.class) {
            boost.writeShort((short)1);
            boost.writeBoolean(((Boolean)value).booleanValue());
        } else if (messageClass == Integer.class) {
            boost.writeShort((short)2);
            boost.writeInt(((Integer)value).intValue());
        } else {
            boost.writeShort((short)3);
            boost.writeObject((BoostObject)value);
        }
    }

    public static Object[] readValueArray(Boost boost) {
        int size = boost.readInt();
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            result[i] = ActionUtil.readValue(boost);
        }
        return result;
    }

    public static Object readValue(Boost boost) {
        short type = boost.readShort();
        switch (type) {
            case 1: {
                return boost.readBoolean();
            }
            case 2: {
                return boost.readInt();
            }
            case 3: {
                return boost.readObject(BoostObject.class);
            }
        }
        return null;
    }
}

