/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2;

import java.io.IOException;
import java.net.URL;
import java.util.function.Consumer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import org.controlsfx.control.StatusBar;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.core.fx.IAppContext;
import plug.ui2.OutputRedirect;
import plug.utils.file.FileWatcher;
import plug.utils.ui.fx.GuiFxUtils;

public abstract class AbstractUIBase
extends Application
implements IAppContext {
    FileWatcher fileWatcher = new FileWatcher();
    Stage stage;
    public Scene mainScene;
    Scene theScene = new Scene((Parent)new OutputRedirect());
    final ObjectProperty<Stage> theErrorStage = new SimpleObjectProperty();

    @Override
    public FileWatcher getFileWatcher() {
        return this.fileWatcher;
    }

    @Override
    public void openView(String title, Region view, Consumer<Region> onClose) {
        BorderPane mainPane = new BorderPane();
        mainPane.setCenter((Node)view);
        FontIcon closeIcon = new FontIcon("gmi-close:20");
        GuiFxUtils.addButtonEffects((Node)closeIcon);
        closeIcon.setOnMouseClicked(event -> {
            this.stage.setScene(this.mainScene);
            if (onClose != null) {
                onClose.accept(view);
            }
        });
        Text titleText = new Text(title);
        titleText.setTextAlignment(TextAlignment.CENTER);
        BorderPane titlePane = new BorderPane((Node)titleText);
        titlePane.setLeft((Node)closeIcon);
        mainPane.setTop((Node)titlePane);
        Scene theScene = new Scene(this.buildMain((Node)mainPane), this.mainScene.getWidth(), this.mainScene.getHeight());
        this.addCSS(theScene);
        this.stage.setScene(theScene);
    }

    public void addCSS(Scene scene) {
        URL css = this.getClass().getResource("/plug/ui2/style.css");
        GuiFxUtils.setStylesheet((URL)css, (Scene)scene, (FileWatcher)this.fileWatcher);
    }

    void showErrorHandler(MouseEvent me) {
        Stage theStage = (Stage)this.theErrorStage.get();
        if (theStage == null) {
            theStage = new Stage();
            this.theErrorStage.set((Object)theStage);
            theStage.setScene(this.theScene);
            theStage.setTitle("Console Messages");
        }
        theStage.show();
        theStage.requestFocus();
    }

    public StatusBar getStatusBar() {
        StatusBar statusBar = new StatusBar();
        statusBar.setText("");
        FontIcon errorIcon = new FontIcon("gmi-error-outline:20:#FF0000");
        errorIcon.setOnMouseClicked(this::showErrorHandler);
        statusBar.getRightItems().addAll((Object[])new Node[]{errorIcon});
        return statusBar;
    }

    public abstract Node getMainComponent();

    public void init() throws Exception {
        super.init();
        this.mainScene = new Scene(this.buildMain(this.getMainComponent()), 800.0, 600.0);
    }

    Parent buildMain(Node node) {
        return new BorderPane(node, null, null, (Node)this.getStatusBar(), null);
    }

    public void start(Stage primaryStage) {
        this.stage = primaryStage;
        this.stage.setOnCloseRequest(e -> {
            Platform.exit();
            System.exit(0);
        });
        this.addCSS(this.mainScene);
        this.stage.setScene(this.mainScene);
        this.stage.show();
    }
}

