/*
 * Decompiled with CFR 0.152.
 */
package plug.core.fx.langage;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.code_editor.richtextfx.CodeEditor;
import plug.core.fx.IAppContext;
import plug.core.fx.langage.ILanguageFxModule;
import plug.core.fx.langage.LanguageFxModuleRegistry;
import plug.utils.file.FileWatcher;

@Deprecated
public class ModelView
extends BorderPane {
    protected static final String OPEN_ICON_CODE = "gmi-find-in-page";
    protected final LanguageFxModuleRegistry registry = LanguageFxModuleRegistry.getInstance();
    protected final IAppContext appContext;
    protected final BooleanProperty showPath = new SimpleBooleanProperty(true);
    protected final ObservableObjectValue<Path> basePath;
    protected final ObjectProperty<Path> relativePath;
    protected final ObservableObjectValue<Path> modelPath;
    protected final SimpleStringProperty modelContent;
    protected final GridPane modelPathPane = new GridPane();
    protected final Label modelPathLabel = new Label("Source");
    protected final FontIcon modelPathInfoView = new FontIcon();
    protected final TextField modelPathField = new TextField();
    protected final Button modelPathSelectButton = new Button(null, (Node)new FontIcon("gmi-find-in-page"));
    protected final Button modelPathClearButton = new Button(null, (Node)new FontIcon("gmi-close"));
    protected final ObjectProperty<Node> modelComponent = new SimpleObjectProperty(null);
    protected final ObservableList<FileChooser.ExtensionFilter> extensionFilters = FXCollections.observableArrayList();
    protected final Consumer<Path> fileChangedConsumer = path -> Platform.runLater(() -> this.readFile((Path)path));

    public ModelView(IAppContext appContext, ObservableObjectValue<Path> basePath, Path relativePath, boolean showPath) {
        this.appContext = appContext;
        this.basePath = basePath != null ? basePath : new SimpleObjectProperty();
        this.relativePath = new SimpleObjectProperty((Object)relativePath);
        this.modelPath = Bindings.createObjectBinding(() -> this.basePath.get() != null && !((Path)this.relativePath.get()).isAbsolute() ? ((Path)this.basePath.get()).resolve((Path)this.relativePathProperty().get()) : (Path)this.relativePath.get(), (Observable[])new Observable[]{this.basePath, this.relativePath});
        this.modelContent = new SimpleStringProperty();
        this.showPath.set(showPath);
        this.modelPathField.setEditable(false);
        StringBinding pathBinding = Bindings.createStringBinding(() -> {
            Path path = (Path)this.relativePath.get();
            return path != null ? path.toString() : "No path selected";
        }, (Observable[])new Observable[]{this.relativePath});
        this.modelPathField.textProperty().bind((ObservableValue)pathBinding);
        this.modelPathLabel.setGraphic((Node)this.modelPathInfoView);
        this.modelPathPane.setHgap(5.0);
        ObservableList constraints = this.modelPathPane.getColumnConstraints();
        constraints.add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.RIGHT, false));
        constraints.add((Object)new ColumnConstraints(100.0, 200.0, -1.0, Priority.ALWAYS, HPos.CENTER, true));
        constraints.add((Object)new ColumnConstraints(-1.0));
        constraints.add((Object)new ColumnConstraints(-1.0));
        int column = 0;
        this.modelPathPane.add((Node)this.modelPathLabel, column++, 0);
        this.modelPathPane.add((Node)this.modelPathField, column++, 0);
        this.modelPathPane.add((Node)this.modelPathSelectButton, column++, 0);
        this.modelPathPane.add((Node)this.modelPathClearButton, column++, 0);
        this.setTop((Node)this.modelPathPane);
        this.modelPathSelectButton.setOnAction(this::selectComponentPath);
        this.modelPathClearButton.setOnAction(this::clearComponentPath);
        this.showPath.addListener(this::updateShowPath);
        this.modelPath.addListener(this::updateModelPath);
        this.modelContent.addListener(this::saveFile);
        this.updateModelPath((ObservableValue<? extends Path>)this.modelPath, null, (Path)this.modelPath.get());
        this.updateShowPath((ObservableValue<? extends Boolean>)this.showPath, !showPath, showPath);
    }

    public StringProperty labelProperty() {
        return this.modelPathLabel.textProperty();
    }

    public BooleanProperty showPathPropertyProperty() {
        return this.showPath;
    }

    public void setShowPath(boolean showPath) {
        this.showPath.set(showPath);
    }

    public boolean isShowPath() {
        return this.showPath.get();
    }

    public ObjectProperty<Path> relativePathProperty() {
        return this.relativePath;
    }

    public Path getRelativePath() {
        return (Path)this.relativePath.get();
    }

    public void setRelativePath(Path relativePath) {
        this.relativePath.set((Object)relativePath);
    }

    public ObservableObjectValue<Path> modelPathProperty() {
        return this.modelPath;
    }

    public Path getModelPath() {
        return (Path)this.modelPath.get();
    }

    public ObservableObjectValue<Node> modelComponentProperty() {
        return this.modelComponent;
    }

    public SimpleStringProperty modelContentProperty() {
        return this.modelContent;
    }

    public ObservableList<FileChooser.ExtensionFilter> getExtensionFilters() {
        return this.extensionFilters;
    }

    protected void updateModelPath(ObservableValue<? extends Path> observable, Path oldValue, Path newValue) {
        FileWatcher fileWatcher = this.appContext.getFileWatcher();
        if (oldValue != null) {
            fileWatcher.removeOnContentChange(oldValue, this.fileChangedConsumer);
        }
        this.setErrorStatus(null);
        if (newValue != null) {
            fileWatcher.addOnContentChange(newValue, this.fileChangedConsumer);
        }
        this.readFile(newValue);
        CodeEditor newModelComponent = null;
        if (newValue != null) {
            ILanguageFxModule moduleByExtension = this.registry.getModuleByExtension(newValue);
            if (moduleByExtension != null) {
                try {
                    SimpleObjectProperty basePath = new SimpleObjectProperty((Object)newValue.getParent());
                    newModelComponent = moduleByExtension.createComponent(this.appContext, (StringProperty)this.modelContent, (ObservableObjectValue<Path>)basePath);
                }
                catch (IOException e) {
                    this.setErrorStatus(e.getMessage());
                }
            } else {
                newModelComponent = new CodeEditor((StringProperty)this.modelContent);
            }
        } else {
            Text one = new Text("Click on ");
            one.setStroke((Paint)Color.GRAY);
            Text two = new Text(" to select ");
            two.setStroke((Paint)Color.GRAY);
            Text three = new Text();
            three.textProperty().bind((ObservableValue)this.labelProperty());
            three.setStroke((Paint)Color.GRAY);
            HBox text = new HBox(new Node[]{one, new FontIcon("gmi-find-in-page:16:grey"), two, three});
            text.setAlignment(Pos.CENTER);
            newModelComponent = new BorderPane((Node)text);
        }
        this.modelComponent.set((Object)newModelComponent);
        this.setCenter((Node)newModelComponent);
    }

    protected void setErrorStatus(String tooltip) {
        this.modelPathLabel.setTooltip(tooltip != null ? new Tooltip(tooltip) : null);
        this.modelPathInfoView.setIconLiteral("typ-delete-outline");
        this.modelPathInfoView.setVisible(tooltip != null);
        this.modelPathLabel.setGraphic((Node)this.modelPathInfoView);
    }

    protected void updateShowPath(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        this.setTop((Node)(newValue != false ? this.modelPathPane : null));
    }

    protected void selectComponentPath(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().addAll(this.extensionFilters);
        chooser.setTitle("Open a " + (String)this.labelProperty().get());
        File file = chooser.showOpenDialog(this.getScene().getWindow());
        if (file != null) {
            Path relativePath = this.basePath.get() != null ? ((Path)this.basePath.get()).relativize(file.toPath()) : file.toPath();
            this.setRelativePath(relativePath);
        }
    }

    protected void clearComponentPath(ActionEvent event) {
        this.setRelativePath(null);
    }

    protected void saveFile(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        if (oldValue != null && newValue != null && this.modelPath.get() != null) {
            try {
                Files.write((Path)this.modelPath.get(), newValue.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                this.setErrorStatus("File doesn't exist");
            }
        }
    }

    private void readFile(Path newValue) {
        if (newValue != null) {
            try {
                if (newValue.toFile().isDirectory()) {
                    this.modelContent.set("todo -- folder loading view");
                    return;
                }
                this.modelContent.set(new String(Files.readAllBytes(newValue), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                this.setErrorStatus("File doesn't exist");
            }
        } else {
            this.modelContent.set(null);
        }
    }
}

