/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.handler;

import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.toolbox.tools.analysis.VariableUsageAnalysis;
import java.util.LinkedList;

public class SilentRemoveVariable {
    private AEFDModel model;
    private boolean analysed = false;
    private VariableUsageAnalysis analysis;
    private AEFDBooleanVariable toBeRemoved;
    private int removedActionCount;

    public void setModel(AEFDModel model) {
        this.model = model;
        this.analysed = false;
    }

    public void remove(AEFDBooleanVariable variable) {
        if (!this.analysed) {
            this.analyseUsage();
            this.analysed = true;
        }
        this.toBeRemoved = variable;
        if (this.isSafe()) {
            this.removeActions();
        }
    }

    public int getRemovedActionCount() {
        return this.removedActionCount;
    }

    private void analyseUsage() {
        this.analysis = new VariableUsageAnalysis();
        this.analysis.analyse(this.model);
    }

    private boolean isSafe() {
        return this.analysis.getDiagnostic(this.toBeRemoved).equals((Object)VariableUsageAnalysis.VarDiagnostic.NeverRead);
    }

    private void removeActions() {
        this.removedActionCount = 0;
        LinkedList<AEFDAction> actionsToRemove = new LinkedList<AEFDAction>();
        for (AEFDAutomate automate : this.model.getAllAutomates()) {
            for (AEFDTransition transition : automate.getTransitionSet()) {
                for (AEFDAction action : transition.getAction().getActionList()) {
                    AEFDAction.Affectation affectation;
                    if (!(action instanceof AEFDAction.Affectation) || !(affectation = (AEFDAction.Affectation)action).getVariable().equals(this.toBeRemoved)) continue;
                    actionsToRemove.add(action);
                }
                for (AEFDAction action : actionsToRemove) {
                    transition.getAction().removeAction(action);
                    ++this.removedActionCount;
                }
                actionsToRemove.clear();
            }
        }
    }
}

