/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.analysis;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.toolbox.tools.analysis.basic.ReceivedEventsAnalysis;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExecutionOrderAnalysis {
    private AEFDModel model;
    private ReceivedEventsAnalysis receivedEvents;
    private Map<AEFDAutomate, Map<String, Set<AEFDAutomate>>> priorityMap = new HashMap<AEFDAutomate, Map<String, Set<AEFDAutomate>>>();

    public void analyze(AEFDModel model) {
        this.model = model;
        this.receivedEvents = new ReceivedEventsAnalysis();
        this.receivedEvents.analyze(model);
        this.analyze();
    }

    public void analyze(AEFDModel model, ReceivedEventsAnalysis preAnalysis) {
        this.model = model;
        this.receivedEvents = preAnalysis;
        this.analyze();
    }

    private void analyze() {
        this.initialize();
        this.computePriorityMap();
    }

    private void initialize() {
        this.priorityMap.clear();
        for (AEFDAutomate automate : this.model.getAllAutomates()) {
            this.priorityMap.put(automate, new HashMap());
            for (String place : automate.getPlaceSet()) {
                this.priorityMap.get(automate).put(place.intern(), new HashSet());
            }
        }
    }

    private void computePriorityMap() {
        for (AEFDAutomate automate : this.model.getAllAutomates()) {
            if (automate.getName().equals("Environment")) continue;
            for (String place : automate.getPlaceSet()) {
                this.computePriorityMap(automate, place.intern());
            }
        }
    }

    private void computePriorityMap(AEFDAutomate automate, String place) {
        Set<AEFDFunctionalEntity> inputs = this.receivedEvents.getInputs(automate, place);
        for (AEFDAutomate otherAutomate : this.model.getAllAutomates()) {
            if (automate == otherAutomate || Collections.disjoint(inputs, this.receivedEvents.getInputs(otherAutomate)) || this.model.getExecutionOrder().compare(automate, otherAutomate) <= 0) continue;
            this.priorityMap.get(automate).get(place).add(otherAutomate);
        }
    }

    public Set<AEFDAutomate> getHigherPriorityAutomates(AEFDAutomate automate, String place) {
        if (this.priorityMap.get(automate) == null) {
            return null;
        }
        return this.priorityMap.get(automate).get(place.intern());
    }

    public Set<AEFDAutomate> getHigherPriorityAutomates(AEFDAutomate automate) {
        HashSet<AEFDAutomate> result = new HashSet<AEFDAutomate>();
        if (this.priorityMap.get(automate) == null) {
            return result;
        }
        for (String place : automate.getPlaceSet()) {
            result.addAll(this.getHigherPriorityAutomates(automate, place));
        }
        return result;
    }
}

