/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.explorer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import obp.explorer.ConfsFileHandler;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.obs.Action;
import obp.lua.LuaPrinter;
import obp.ui.explorer.ConfsFileHandlerController;
import obp.ui.explorer.TraceToSequence;
import obp.ui.sequence.LifeLine;
import obp.ui.sequence.Sequence;
import obp.ui.sequence.SequenceDiagram;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.Validator;
import org.xid.basics.generation.MergerUtil;
import org.xid.basics.notification.Notification;
import org.xid.basics.notification.NotificationListener;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.diagram.Diagram;
import org.xid.basics.ui.dialog.FieldShellToolkit;
import org.xid.basics.ui.field.ChoiceField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.DiagramField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.ListField;
import org.xid.basics.ui.field.MultiTabField;
import org.xid.basics.ui.field.TextField;
import org.xid.basics.ui.field.text.SourceCode;
import org.xid.basics.ui.field.text.SourceCodeField;

public class ShowTraceAction
extends Action.Stub {
    private final ConfsFileHandlerController parent;
    private List<Action> trace;
    private boolean loading = false;
    private Shell shell = null;
    private FieldShellToolkit toolkit = null;
    private TextField configurationField;
    private Validator.Stub<String> configurationValidator;
    private TextField filterField;
    private ListField<Action> actionListField;
    private DiagramField<Sequence> sequenceField;
    private Map<String, LifeLine> lifelineCache = new HashMap<String, LifeLine>();
    private ChoiceField<File> luaFileField;
    private SourceCodeField textField;
    private MultiTabField traceField;

    public ShowTraceAction(ConfsFileHandlerController parent) {
        super("Traces");
        this.parent = parent;
    }

    public int getVisibility() {
        if (this.parent.getSubject() == null) {
            return 2;
        }
        return this.loading ? 4 : 1;
    }

    public int run(ActionMonitor monitor) {
        final ConfsFileHandler confs = (ConfsFileHandler)this.parent.getSubject();
        if (confs == null) {
            return 3;
        }
        this.loading = true;
        Thread loader = new Thread(new Runnable(){

            @Override
            public void run() {
                confs.readAll();
                ShowTraceAction.this.loading = false;
                ShowTraceAction.this.openTracesDialog();
            }
        });
        loader.start();
        return 1;
    }

    private void updateFilteredTrace() {
        String filter = this.filterField.getValue();
        if (filter == null) {
            this.actionListField.setValue(this.trace);
        } else {
            ArrayList<Action> filtered = new ArrayList<Action>();
            for (Action action : this.trace) {
                String text = this.actionListField.getText((Object)action);
                if (!text.contains(filter)) continue;
                filtered.add(action);
            }
            this.actionListField.setValue(filtered);
        }
    }

    private void updateSequence() {
        SymbolsTable symbols = ((ConfsFileHandler)this.parent.getSubject()).getSymbols();
        Sequence oldSequence = (Sequence)this.sequenceField.getValue();
        if (oldSequence != null) {
            for (LifeLine oldLine : oldSequence.getLifeLineList()) {
                this.lifelineCache.put(oldLine.getLabel(), oldLine);
            }
        }
        Sequence newSequence = TraceToSequence.toSequence(this.actionListField.getValue(), symbols);
        for (LifeLine newLine : newSequence.getLifeLineList()) {
            LifeLine cache = this.lifelineCache.get(newLine.getLabel());
            if (cache == null) continue;
            newLine.setX(cache.getX());
            newLine.setVisible(cache.isVisible());
        }
        this.sequenceField.setValue((Object)newSequence);
    }

    private void updateSource() {
        if (this.luaFileField.getValue() != null) {
            LuaPrinter printer = null;
            try {
                File file = (File)this.luaFileField.getValue();
                printer = new LuaPrinter((ConfsFileHandler)this.parent.getSubject(), file);
                this.textField.setValue(printer.traceDescription(this.actionListField.getValue()));
            }
            catch (Exception e) {
                this.textField.setValue(DiagnosticUtil.createMessage((Throwable)e));
            }
        } else {
            ConfsFileHandler handler = (ConfsFileHandler)this.parent.getSubject();
            StringBuilder configurations = new StringBuilder();
            StringBuilder transitions = new StringBuilder();
            Configuration sourceConfiguration = handler.getConfiguration(0);
            configurations.append(handler.configurationToString(sourceConfiguration));
            configurations.append("\n\n");
            for (Action action : this.trace) {
                Configuration targetConfiguration = handler.getConfiguration(action.targetId);
                transitions.append("(");
                transitions.append(sourceConfiguration.id);
                transitions.append(",\"");
                transitions.append(handler.actionToString(action));
                transitions.append("\",");
                transitions.append(targetConfiguration.id);
                transitions.append(")\n");
                configurations.append(handler.configurationToString(targetConfiguration));
                configurations.append("\n\n");
                sourceConfiguration = targetConfiguration;
            }
            StringBuilder source = new StringBuilder();
            source.append((CharSequence)configurations);
            source.append("transitions: {\n" + transitions + "\n}");
            this.textField.setValue(source.toString());
        }
    }

    private void openTracesDialog() {
        this.configurationField = new TextField("Target (<id>+)", 0);
        this.configurationValidator = new Validator.Stub<String>(2, "Invalid configuration sequence or id."){

            public boolean isValid(String value) {
                if (value == null) {
                    return false;
                }
                StringTokenizer sT = new StringTokenizer(value);
                while (sT.hasMoreTokens()) {
                    try {
                        int id = Integer.decode(sT.nextToken());
                        if (id >= 0 && id < ((ConfsFileHandler)ShowTraceAction.this.parent.getSubject()).getConfigurationCount()) continue;
                        return false;
                    }
                    catch (NumberFormatException e1) {
                        return false;
                    }
                }
                return true;
            }
        };
        this.configurationField.setValidator(this.configurationValidator);
        this.filterField = new TextField("Filter", 4);
        this.actionListField = new ListField<Action>(null, 2){

            public String getText(Action action) {
                StringBuilder text = new StringBuilder();
                text.append(((ConfsFileHandler)ShowTraceAction.this.parent.getSubject()).actionToString(action));
                text.append(" -> ");
                text.append(action.targetId);
                return text.toString();
            }
        };
        this.sequenceField = new DiagramField((Diagram)new SequenceDiagram());
        this.sequenceField.addAction(this.sequenceField.getController().createIncreaseZoomAction());
        this.sequenceField.addAction(this.sequenceField.getController().createDecreaseZoomAction());
        this.sequenceField.addAction(this.sequenceField.getController().createSaveImageAction());
        this.luaFileField = new ChoiceField<File>("Printer", 34){

            public String getText(File element) {
                return element.getName();
            }
        };
        ArrayList<File> luaFileList = new ArrayList<File>();
        File systemDirectory = ((ConfsFileHandler)this.parent.getSubject()).getExplorerResult().getResultFile().getParentFile().getParentFile().getParentFile();
        for (File file : systemDirectory.listFiles()) {
            if (!file.isFile() || file.isHidden() || !file.getName().endsWith(".lua")) continue;
            luaFileList.add(file);
        }
        this.luaFileField.setRange(luaFileList);
        this.luaFileField.setValue(null);
        this.luaFileField.addAction((org.xid.basics.ui.action.Action)new Action.Stub("Save"){

            public int run(ActionMonitor monitor) {
                FileDialog dialog = new FileDialog(ShowTraceAction.this.shell, 8192);
                String filename = dialog.open();
                if (filename == null) {
                    return 2;
                }
                File file = new File(filename);
                try {
                    MergerUtil.writeFile((File)file, (String)ShowTraceAction.this.textField.getValue(), (String)"UTF-8");
                }
                catch (Exception e) {
                    String message = DiagnosticUtil.createMessage((Throwable)e);
                    ShowTraceAction.this.parent.getErrorHandler().handleError(2, message);
                    return 3;
                }
                return 1;
            }
        });
        this.textField = new SourceCodeField(SourceCode.simple);
        CompositeField textCompositeField = new CompositeField("Text", new Field[]{this.luaFileField, this.textField});
        this.traceField = new MultiTabField();
        this.traceField.addTab((Field)new CompositeField("MSC", new Field[]{this.sequenceField}), null, false);
        this.traceField.addTab((Field)new CompositeField("List", new Field[]{this.actionListField}), null, false);
        this.traceField.addTab((Field)textCompositeField, null, false);
        this.traceField.setSelected(0);
        this.configurationField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                StringTokenizer sT;
                int target = 0;
                ShowTraceAction.this.trace = Collections.emptyList();
                String string = ShowTraceAction.this.configurationField.getValue();
                if (string != null && (sT = new StringTokenizer(string)).countTokens() >= 1) {
                    try {
                        target = Integer.decode(sT.nextToken());
                        ShowTraceAction.this.trace = ((ConfsFileHandler)ShowTraceAction.this.parent.getSubject()).getFastestToComputeTrace(target);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    int current = target;
                    while (sT.hasMoreTokens()) {
                        try {
                            target = Integer.decode(sT.nextToken());
                        }
                        catch (NumberFormatException e1) {
                            continue;
                        }
                        List<Action> path = ((ConfsFileHandler)ShowTraceAction.this.parent.getSubject()).getShortestPath(current, target);
                        if (path.isEmpty()) {
                            ShowTraceAction.this.trace = Collections.emptyList();
                            break;
                        }
                        ShowTraceAction.this.trace.addAll(path);
                        current = target;
                    }
                }
                ShowTraceAction.this.toolkit.setInitialMessage("Trace from 0 to " + target + " (" + ShowTraceAction.this.trace.size() + " transitions).");
                ShowTraceAction.this.updateFilteredTrace();
            }
        });
        this.filterField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if ("value".equals(notification.name)) {
                    ShowTraceAction.this.updateFilteredTrace();
                }
            }
        });
        this.actionListField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if ("value".equals(notification.name)) {
                    ShowTraceAction.this.updateSequence();
                    ShowTraceAction.this.updateSource();
                }
            }
        });
        this.luaFileField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if ("value".equals(notification.name)) {
                    ShowTraceAction.this.updateSource();
                }
            }
        });
        final CompositeField compositeField = new CompositeField(new Field[]{this.configurationField, this.filterField, this.traceField});
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ShowTraceAction.this.shell = FieldShellToolkit.createShell((Display)display, (String)"OBP: Traces");
                ShowTraceAction.this.toolkit = new FieldShellToolkit(ShowTraceAction.this.shell, "Traces", 0, (Field)compositeField);
                ShowTraceAction.this.toolkit.init();
                ShowTraceAction.this.shell.open();
            }
        });
    }
}

