/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import obp.fiacre.model.AnyPattern;
import obp.fiacre.model.Arg;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayElem;
import obp.fiacre.model.ArrayPattern;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BinOp;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.Channel;
import obp.fiacre.model.ChannelDecl;
import obp.fiacre.model.Commented;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.CondExp;
import obp.fiacre.model.ConstantDecl;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.Constr;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.ConstrPattern;
import obp.fiacre.model.ContainerDecl;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.DeterministicAssignment;
import obp.fiacre.model.Emission;
import obp.fiacre.model.Exp;
import obp.fiacre.model.ExternalArgument;
import obp.fiacre.model.ExternalFunctionDecl;
import obp.fiacre.model.ExternalFunctionRef;
import obp.fiacre.model.Field;
import obp.fiacre.model.FieldPattern;
import obp.fiacre.model.FiniteBound;
import obp.fiacre.model.Foreach;
import obp.fiacre.model.FunctionDecl;
import obp.fiacre.model.FunctionRef;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.InfiniteBound;
import obp.fiacre.model.InlineArray;
import obp.fiacre.model.InlineQueue;
import obp.fiacre.model.InlineRecord;
import obp.fiacre.model.Instance;
import obp.fiacre.model.IntType;
import obp.fiacre.model.InterfacedComp;
import obp.fiacre.model.Interval;
import obp.fiacre.model.LocalPortDecl;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.MaxBound;
import obp.fiacre.model.MinBound;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.NatType;
import obp.fiacre.model.NodeDecl;
import obp.fiacre.model.NonDeterministicAssignment;
import obp.fiacre.model.NullStmt;
import obp.fiacre.model.Par;
import obp.fiacre.model.ParamPortDecl;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.PortDecl;
import obp.fiacre.model.Priority;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Profile;
import obp.fiacre.model.Program;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Reception;
import obp.fiacre.model.Record;
import obp.fiacre.model.RecordElem;
import obp.fiacre.model.RefArg;
import obp.fiacre.model.ReturnStmt;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.SingleAssignment;
import obp.fiacre.model.State;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Synchronization;
import obp.fiacre.model.To;
import obp.fiacre.model.Transition;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.UnExp;
import obp.fiacre.model.UnOp;
import obp.fiacre.model.Union;
import obp.fiacre.model.ValuedField;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Variable;
import obp.fiacre.model.Wait;
import obp.fiacre.model.WhileStmt;
import obp.fiacre.parser.FiacreLexer;
import org.xid.basics.error.ErrorHandler;

public class FiacreParserContext {
    private final FiacreLexer lexer;
    private ErrorHandler errorHandler;
    private final Map<String, Declaration> rootDeclarations = new HashMap<String, Declaration>();
    private final Set<String> existingConstr = new HashSet<String>();
    private ContainerDecl currentContainer = null;
    private Transition currentTransition = null;

    public FiacreParserContext(FiacreLexer lexer) {
        this.lexer = lexer;
    }

    private void handleMissingElementError(String name, String type) {
        StringBuilder message = new StringBuilder();
        message.append("Can't find ");
        message.append(type);
        message.append(" named '");
        message.append(name);
        message.append("'.");
        this.getErrorHandler().handleError(2, message.toString());
    }

    private <T> void handleWrongTypeError(String name, String expectedType, String foundType) {
        StringBuilder message = new StringBuilder();
        message.append("Element named '");
        message.append(name);
        message.append("' is a ");
        message.append(foundType);
        message.append(" but it shoud be a ");
        message.append(expectedType);
        message.append(".");
        this.getErrorHandler().handleError(2, message.toString());
    }

    private <T extends Declaration> T findDecl(String name, Class<T> type) {
        return (T)this.find(name, type, this.rootDeclarations);
    }

    private Variable findVariable(String name) {
        for (LocalVariable localVariable : this.currentContainer.getVarList()) {
            if (!name.equals(localVariable.getName())) continue;
            return localVariable;
        }
        for (ArgumentVariable argumentVariable : this.currentContainer.getArgList()) {
            if (!name.equals(argumentVariable.getName())) continue;
            return argumentVariable;
        }
        this.handleMissingElementError(name, "variable");
        return null;
    }

    private LocalVariable findLocalVariable(String name) {
        for (LocalVariable variable : this.currentContainer.getVarList()) {
            if (!name.equals(variable.getName())) continue;
            return variable;
        }
        this.handleMissingElementError(name, "local variable");
        return null;
    }

    private State findState(String name) {
        if (this.currentContainer instanceof ProcessDecl) {
            ProcessDecl process = (ProcessDecl)this.currentContainer;
            for (State state : process.getStateList()) {
                if (!name.equals(state.getName())) continue;
                return state;
            }
        }
        this.handleMissingElementError(name, "variable");
        return null;
    }

    private PortDecl findPortDecl(String name, List<? extends PortDecl> ports) {
        for (PortDecl portDecl : ports) {
            if (!name.equals(portDecl.getName())) continue;
            return portDecl;
        }
        this.handleMissingElementError(name, "port");
        return null;
    }

    private PortDecl findPortDeclInCurrentNode(String name) {
        if (this.currentContainer instanceof NodeDecl) {
            NodeDecl currentNode = (NodeDecl)this.currentContainer;
            for (PortDecl portDecl : currentNode.getPortList()) {
                if (!name.equals(portDecl.getName())) continue;
                return portDecl;
            }
            for (PortDecl portDecl : currentNode.getLocalPortList()) {
                if (!name.equals(portDecl.getName())) continue;
                return portDecl;
            }
        }
        this.handleMissingElementError(name, "port");
        return null;
    }

    private <T> T find(String name, Class<T> type, Map<String, ? super T> map) {
        T result = map.get(name);
        if (type.isInstance(result)) {
            return type.cast(result);
        }
        if (result != null) {
            this.handleWrongTypeError(name, type.getSimpleName(), result.getClass().getSimpleName());
        } else {
            this.handleMissingElementError(name, type.getSimpleName());
        }
        return null;
    }

    public Program createProgram(String root, List<Declaration> declarationList) {
        Program program = new Program();
        if (root != null) {
            program.setRoot(this.findDecl(root, NodeDecl.class));
        }
        for (Declaration declaration : declarationList) {
            program.addDeclaration(declaration);
        }
        return program;
    }

    public ConstantDecl createConstantDecl(String name, Type type, Exp value) {
        ConstantDecl decl = new ConstantDecl();
        decl.setName(name);
        decl.setType(type);
        decl.setValue(value);
        this.registerDeclaration(name, decl);
        this.attachComments(decl);
        return decl;
    }

    public void createProcessContext() {
        this.currentContainer = new ProcessDecl();
    }

    public ContainerDecl getCurrentContainer() {
        return this.currentContainer;
    }

    public ProcessDecl createProcessDecl(String name, List<ParamPortDecl> ports, List<ArgumentVariable> args, List<String> states, List<LocalVariable> vars) {
        ProcessDecl decl = (ProcessDecl)this.currentContainer;
        decl.setName(name);
        if (ports != null) {
            for (ParamPortDecl port : ports) {
                decl.addPort(port);
            }
        }
        if (args != null) {
            for (ArgumentVariable arg : args) {
                decl.addArg(arg);
            }
        }
        if (states != null) {
            for (String state : states) {
                decl.addState(this.createState(state));
            }
        }
        if (vars != null) {
            for (LocalVariable var : vars) {
                decl.addVar(var);
            }
        }
        this.registerDeclaration(name, decl);
        this.currentContainer = decl;
        this.attachComments(decl);
        return decl;
    }

    public void addPrelude(NodeDecl decl, Statement prelude) {
        decl.setInitAction(prelude);
    }

    public void addTransitions(ProcessDecl decl, List<Transition> transitions) {
        if (transitions.size() > 0 && decl.getInitAction() == null) {
            To to = new To();
            to.setDest(transitions.get(0).getFrom());
            decl.setInitAction(to);
        }
        for (Transition transtion : transitions) {
            decl.addTransition(transtion);
        }
    }

    public State createState(String name) {
        State state = new State();
        state.setName(name);
        return state;
    }

    public void createComponentContext() {
        this.currentContainer = new ComponentDecl();
    }

    public ComponentDecl createComponentDecl(String name, List<ParamPortDecl> ports, List<ArgumentVariable> args, List<LocalVariable> vars, List<LocalPortDecl> localPorts, List<Priority> priorities) {
        ComponentDecl decl = (ComponentDecl)this.currentContainer;
        decl.setName(name);
        if (ports != null) {
            for (ParamPortDecl paramPortDecl : ports) {
                decl.addPort(paramPortDecl);
            }
        }
        if (args != null) {
            for (ArgumentVariable argumentVariable : args) {
                decl.addArg(argumentVariable);
            }
        }
        if (vars != null) {
            for (LocalVariable localVariable : vars) {
                decl.addVar(localVariable);
            }
        }
        if (localPorts != null) {
            for (LocalPortDecl localPortDecl : localPorts) {
                decl.addLocalPort(localPortDecl);
            }
        }
        if (priorities != null) {
            for (Priority priority : priorities) {
                decl.addPriority(priority);
            }
        }
        this.registerDeclaration(name, decl);
        this.currentContainer = decl;
        this.attachComments(decl);
        return decl;
    }

    public void setBody(ComponentDecl decl, Par body) {
        decl.setBody(body);
    }

    public void createFunctionContext() {
        this.currentContainer = new FunctionDecl();
    }

    public FunctionDecl createFunctionDecl(String name, List<ArgumentVariable> args, Type returnType, List<LocalVariable> vars) {
        FunctionDecl decl = (FunctionDecl)this.currentContainer;
        decl.setName(name);
        if (args != null) {
            for (ArgumentVariable arg : args) {
                decl.addArg(arg);
            }
        }
        decl.setReturnType(returnType);
        if (vars != null) {
            for (LocalVariable var : vars) {
                decl.addVar(var);
            }
        }
        this.registerDeclaration(name, decl);
        this.currentContainer = decl;
        this.attachComments(decl);
        return decl;
    }

    public void setBody(FunctionDecl decl, Statement body) {
        decl.setBody(body);
    }

    public List<ArgumentVariable> createArgumentVariables(List<String> nameAndRefs, List<String> attributes, Type type) {
        ArrayList<ArgumentVariable> vars = new ArrayList<ArgumentVariable>();
        for (String name : nameAndRefs) {
            boolean ref = name.startsWith("&");
            if (ref) {
                name = name.substring(1);
            }
            boolean read = attributes.isEmpty() || attributes.contains("READ");
            boolean write = attributes.isEmpty() || attributes.contains("WRITE");
            vars.add(this.createArgumentVariable(name, ref, read, write, type));
        }
        return vars;
    }

    public ArgumentVariable createArgumentVariable(String name, boolean ref, boolean read, boolean write, Type type) {
        ArgumentVariable var = new ArgumentVariable();
        var.setName(name);
        var.setRef(ref);
        var.setRead(read);
        var.setWrite(write);
        var.setType(type);
        this.attachComments(var);
        return var;
    }

    public List<LocalVariable> createLocalVariables(List<String> names, Type type, Exp value) {
        ArrayList<LocalVariable> vars = new ArrayList<LocalVariable>();
        for (String name : names) {
            vars.add(this.createLocalVariable(name, type, value));
        }
        return vars;
    }

    public LocalVariable createLocalVariable(String name, Type type, Exp value) {
        LocalVariable var = new LocalVariable();
        var.setName(name);
        var.setType(type);
        var.setInitializer(value);
        this.attachComments(var);
        return var;
    }

    public Priority createPriority(List<String> left, List<String> right) {
        Priority priority = new Priority();
        for (String l : left) {
            priority.addSup(this.findPortDeclInCurrentNode(l));
        }
        for (String r : right) {
            priority.addInf(this.findPortDeclInCurrentNode(r));
        }
        return priority;
    }

    public List<ParamPortDecl> createParamPortDecls(List<String> names, List<String> attributes, Channel channel) {
        ArrayList<ParamPortDecl> decls = new ArrayList<ParamPortDecl>();
        for (String name : names) {
            ParamPortDecl decl = new ParamPortDecl();
            decl.setName(name);
            decl.setChannel(channel);
            decl.setIn(attributes.contains("IN"));
            decl.setOut(attributes.contains("OUT"));
            decls.add(decl);
        }
        return decls;
    }

    public List<LocalPortDecl> createLocalPortDecls(List<String> names, List<String> attributes, Channel channel, MinBound left, MaxBound right) {
        ArrayList<LocalPortDecl> decls = new ArrayList<LocalPortDecl>();
        for (String name : names) {
            LocalPortDecl decl = new LocalPortDecl();
            decl.setName(name);
            decl.setChannel(channel);
            decl.setIn(attributes.isEmpty() ? true : attributes.contains("IN"));
            decl.setOut(attributes.isEmpty() ? true : attributes.contains("OUT"));
            decl.setMini(left);
            decl.setMaxi(right);
            decls.add(decl);
            this.attachComments(decl);
        }
        return decls;
    }

    public InfiniteBound createInfiniteBound() {
        return new InfiniteBound();
    }

    public FiniteBound createFiniteBound(boolean strict, int value) {
        FiniteBound bound = new FiniteBound();
        bound.setStrict(strict);
        bound.setVal(value);
        return bound;
    }

    public TypeDecl createTypeDecl(String name, Type type) {
        TypeDecl decl = new TypeDecl();
        decl.setName(name);
        decl.setIs(type);
        this.registerDeclaration(name, decl);
        this.attachComments(decl);
        return decl;
    }

    public BoolType createBoolType() {
        return new BoolType();
    }

    public IntType createIntType() {
        return new IntType();
    }

    public NatType createNatType() {
        return new NatType();
    }

    public Interval createInterval(Exp mini, Exp maxi) {
        Interval interval = new Interval();
        interval.setMini(mini);
        interval.setMaxi(maxi);
        return interval;
    }

    public Array createArray(Exp size, Type type) {
        Array array = new Array();
        array.setSize(size);
        array.setType(type);
        return array;
    }

    public Queue createQueue(Exp size, Type type) {
        Queue queue = new Queue();
        queue.setSize(size);
        queue.setType(type);
        return queue;
    }

    public Record createRecord(List<Field> fields) {
        Record record = new Record();
        for (Field field : fields) {
            record.addField(field);
        }
        return record;
    }

    public List<Field> createFields(List<String> names, Type type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (String name : names) {
            fields.add(this.createField(name, type));
        }
        return fields;
    }

    public Field createField(String name, Type type) {
        Field field = new Field();
        field.setName(name);
        field.setType(type);
        return field;
    }

    public TypeId createTypeId(String name) {
        TypeId typeId = new TypeId();
        typeId.setDecl(this.findDecl(name, TypeDecl.class));
        return typeId;
    }

    public Union createUnion(List<Constr> constrs) {
        Union union = new Union();
        for (Constr constr : constrs) {
            union.addConstr(constr);
        }
        return union;
    }

    public List<Constr> createConstrs(List<String> names, Type type) {
        ArrayList<Constr> constrs = new ArrayList<Constr>();
        for (String name : names) {
            constrs.add(this.createConstr(name, type));
        }
        return constrs;
    }

    public Constr createConstr(String name, Type type) {
        if (this.existingConstr.contains(name)) {
            this.getErrorHandler().handleError(2, "Constr named '" + name + "' already exists.");
        }
        this.existingConstr.add(name);
        Constr constr = new Constr();
        constr.setName(name);
        constr.setType(type);
        return constr;
    }

    public ChannelDecl createChannelDecl(String name, Channel channel) {
        ChannelDecl decl = new ChannelDecl();
        decl.setName(name);
        decl.setIs(channel);
        this.registerDeclaration(name, decl);
        this.attachComments(decl);
        return decl;
    }

    public Profile createProfile(List<Type> types) {
        Profile profile = new Profile();
        for (Type type : types) {
            profile.addType(type);
        }
        return profile;
    }

    public Transition createTransition(String source) {
        Transition transition = new Transition();
        transition.setFrom(this.findState(source));
        this.currentTransition = transition;
        return transition;
    }

    public void setAction(Transition transition, Statement action) {
        transition.setAction(action);
    }

    public SingleAssignment createSingleAssignment(Pattern left, Exp right) {
        SingleAssignment assign = new SingleAssignment();
        assign.setLhs(left);
        assign.setRhs(right);
        return assign;
    }

    public DeterministicAssignment createDeterministicAssignment(List<Pattern> lefts, List<Exp> rights) {
        DeterministicAssignment assign = new DeterministicAssignment();
        if (rights.size() != lefts.size()) {
            this.getErrorHandler().handleError(2, "Assignment hasn't same numbers of assignes than expressions.");
            return null;
        }
        for (int i = 0; i < rights.size(); ++i) {
            assign.addAssignment(this.createSingleAssignment(lefts.get(i), rights.get(i)));
        }
        this.attachComments(assign);
        return assign;
    }

    public NonDeterministicAssignment createNonDeterministicAssignment(List<Pattern> lhss, Exp condition) {
        NonDeterministicAssignment assign = new NonDeterministicAssignment();
        assign.setCondition(condition);
        for (Pattern p : lhss) {
            assign.addLhs(p);
        }
        this.attachComments(assign);
        return assign;
    }

    public Emission createEmission(String port, List<Exp> args) {
        Emission emission = new Emission();
        emission.setPort(this.findPortDeclInCurrentNode(port));
        for (Exp arg : args) {
            emission.addArg(arg);
        }
        this.attachComments(emission);
        return emission;
    }

    public Reception createReception(String port, List<Pattern> patterns, Exp where) {
        Reception reception = new Reception();
        reception.setPort(this.findPortDeclInCurrentNode(port));
        reception.setWhere(where);
        for (Pattern pattern : patterns) {
            reception.addPattern(pattern);
        }
        this.attachComments(reception);
        return reception;
    }

    public Synchronization createSynchronization(String port) {
        Synchronization synchro = new Synchronization();
        synchro.setPort(this.findPortDeclInCurrentNode(port));
        this.attachComments(synchro);
        return synchro;
    }

    public IfStmt createIfStmt(Exp condition, Statement thenS, IfStmt elseIf, Statement elseS) {
        IfStmt lastParent = elseIf;
        if (lastParent != null) {
            while (lastParent.getElse() != null && lastParent.getElse() instanceof IfStmt) {
                lastParent = (IfStmt)lastParent.getElse();
            }
            lastParent.setElse(elseS);
            return this.createIfStmt(condition, thenS, elseIf);
        }
        return this.createIfStmt(condition, thenS, elseS);
    }

    public IfStmt createIfStmt(Exp condition, Statement thenS, Statement elseS) {
        IfStmt ifStmt = new IfStmt();
        ifStmt.setCondition(condition);
        ifStmt.setThen(thenS);
        ifStmt.setElse(elseS);
        this.attachComments(ifStmt);
        return ifStmt;
    }

    public Foreach createForeach(String var, Statement body) {
        Foreach foreach = new Foreach();
        foreach.setIter(this.findLocalVariable(var));
        foreach.setBody(body);
        this.attachComments(foreach);
        return foreach;
    }

    public WhileStmt createWhileStmt(Exp condition, Statement body) {
        WhileStmt whileStmt = new WhileStmt();
        whileStmt.setCondition(condition);
        whileStmt.setBody(body);
        this.attachComments(whileStmt);
        return whileStmt;
    }

    public CaseStmt createOnStmt(Exp e) {
        CaseStmt stmt = new CaseStmt();
        stmt.setExp(e);
        stmt.addRule(this.createRule(this.createBoolLiteral(true), new NullStmt()));
        this.attachComments(stmt);
        return stmt;
    }

    public CaseStmt createCaseStmt(Exp e, List<Rule> matches) {
        CaseStmt stmt = new CaseStmt();
        stmt.setExp(e);
        for (Rule match : matches) {
            stmt.addRule(match);
        }
        this.attachComments(stmt);
        return stmt;
    }

    public Wait createWait(MinBound mini, MaxBound maxi) {
        Wait wait = new Wait();
        wait.setMini(mini);
        wait.setMaxi(maxi);
        this.attachComments(wait);
        return wait;
    }

    public ReturnStmt createReturn(Exp exp) {
        ReturnStmt returnStmt = new ReturnStmt();
        returnStmt.setExpression(exp);
        this.attachComments(returnStmt);
        return returnStmt;
    }

    public NullStmt createNullStmt() {
        NullStmt nullStmt = new NullStmt();
        this.attachComments(nullStmt);
        return nullStmt;
    }

    public Select createSelect(List<Statement> statements) {
        Select select = new Select();
        for (Statement statement : statements) {
            select.addStatement(statement);
        }
        this.attachComments(select);
        return select;
    }

    public Seq createSeq(Statement s1, Statement s2) {
        Seq seq = new Seq();
        if (s1 instanceof Seq) {
            for (String comment : s1.getCommentList()) {
                seq.addComment(comment);
            }
            for (Statement child : ((Seq)s1).getStatementList()) {
                seq.addStatement(child);
            }
        } else {
            seq.addStatement(s1);
        }
        if (s2 instanceof Seq) {
            for (String comment : s2.getCommentList()) {
                seq.addComment(comment);
            }
            for (Statement child : ((Seq)s2).getStatementList()) {
                seq.addStatement(child);
            }
        } else {
            seq.addStatement(s2);
        }
        this.attachComments(seq);
        return seq;
    }

    public To createTo(String stateName) {
        To to = new To();
        to.setDest(this.findState(stateName));
        this.attachComments(to);
        return to;
    }

    public To createLoop() {
        To to = new To();
        to.setDest(this.currentTransition.getFrom());
        this.attachComments(to);
        return to;
    }

    public Rule createRule(Pattern lhs, Statement action) {
        Rule rule = new Rule();
        rule.setLhs(lhs);
        rule.setAction(action);
        return rule;
    }

    public AnyPattern createAnyPattern() {
        return new AnyPattern();
    }

    public ArrayPattern createArrayPattern(Pattern arrayPattern, Exp index) {
        ArrayPattern pattern = new ArrayPattern();
        pattern.setArray(arrayPattern);
        pattern.setIndex(index);
        return pattern;
    }

    public ConstrPattern createConstrPattern(Pattern arg, String constr) {
        ConstrPattern pattern = new ConstrPattern();
        pattern.setName(constr);
        pattern.setArg(arg);
        return pattern;
    }

    public FieldPattern createFieldPattern(Pattern recordPattern, String field) {
        FieldPattern pattern = new FieldPattern();
        pattern.setRecord(recordPattern);
        pattern.setField(field);
        return pattern;
    }

    public Par createPar(List<InterfacedComp> arguments) {
        Par par = new Par();
        for (InterfacedComp arg : arguments) {
            par.addArg(arg);
        }
        this.attachComments(par);
        return par;
    }

    public Instance createInstance(String type, List<String> ports, List<Arg> arguments) {
        Instance instance = new Instance();
        instance.setType(this.findDecl(type, NodeDecl.class));
        for (String portName : ports) {
            if (portName.equals("*")) {
                this.getErrorHandler().handleError(1, "Implements port '*' in InterfacedComp.");
            }
            instance.addPort(this.findPortDeclInCurrentNode(portName));
        }
        for (Arg arg : arguments) {
            instance.addArg(arg);
        }
        this.attachComments(instance);
        return instance;
    }

    public InterfacedComp createInterfacedComp(Instance instance, List<String> ports) {
        InterfacedComp comp = new InterfacedComp();
        comp.setComposition(instance);
        for (String portName : ports) {
            if (portName.equals("*")) {
                this.getErrorHandler().handleError(1, "Implements port '*' in InterfacedComp.");
            }
            comp.addSyncPort(this.findPortDeclInCurrentNode(portName));
        }
        return comp;
    }

    public InterfacedComp createInterfacedComp(Par par, List<String> ports) {
        InterfacedComp comp = new InterfacedComp();
        comp.setComposition(par);
        ArrayList<PortDecl> portDecls = new ArrayList<PortDecl>();
        for (InterfacedComp interfacedComp : par.getArgList()) {
            portDecls.addAll(interfacedComp.getSyncPortList());
        }
        for (String portName : ports) {
            comp.addSyncPort(this.findPortDecl(portName, portDecls));
        }
        return comp;
    }

    public List<String> createAllPortNameList() {
        ArrayList<String> allPortNameList = new ArrayList<String>();
        if (this.currentContainer instanceof NodeDecl) {
            NodeDecl currentNode = (NodeDecl)this.currentContainer;
            for (PortDecl portDecl : currentNode.getLocalPortList()) {
                allPortNameList.add(portDecl.getName());
            }
            for (PortDecl portDecl : currentNode.getPortList()) {
                allPortNameList.add(portDecl.getName());
            }
        }
        return allPortNameList;
    }

    public RefArg createRefArg(String name) {
        RefArg arg = new RefArg();
        arg.setRef(this.findVariable(name));
        return arg;
    }

    public InlineArray createInlineArray(List<Exp> exps) {
        InlineArray exp = new InlineArray();
        for (Exp e : exps) {
            exp.addElem(e);
        }
        return exp;
    }

    public InlineQueue createInlineQueue(List<Exp> exps) {
        InlineQueue exp = new InlineQueue();
        for (Exp e : exps) {
            exp.addElem(e);
        }
        return exp;
    }

    public InlineRecord createInlineRecord(List<ValuedField> fields) {
        InlineRecord exp = new InlineRecord();
        for (ValuedField f : fields) {
            exp.addValue(f);
        }
        return exp;
    }

    public BinExp createBinExp(BinOp op, Exp left, Exp right) {
        BinExp exp = new BinExp();
        exp.setBinOp(op);
        exp.setLeft(left);
        exp.setRight(right);
        return exp;
    }

    public UnExp createUnExp(UnOp op, Exp childExp) {
        UnExp exp = new UnExp();
        exp.setUnop(op);
        exp.setExp(childExp);
        return exp;
    }

    public CondExp createCondExp(Exp cond, Exp ifTrue, Exp ifFalse) {
        CondExp exp = new CondExp();
        exp.setCond(cond);
        exp.setIft(ifTrue);
        exp.setIff(ifFalse);
        return exp;
    }

    private ConstrExp createConstrExp(String constr, Exp value) {
        ConstrExp exp = new ConstrExp();
        exp.setName(constr);
        exp.setArg(value);
        return exp;
    }

    private FunctionRef createFunctionRef(String name, List<Exp> params) {
        FunctionRef exp = new FunctionRef();
        exp.setDecl(this.findDecl(name, FunctionDecl.class));
        if (params != null) {
            for (Exp param : params) {
                exp.addParam(param);
            }
        }
        return exp;
    }

    public NatLiteral createNatLiteral(int value) {
        NatLiteral lit = new NatLiteral();
        lit.setValue(value);
        return lit;
    }

    public BoolLiteral createBoolLiteral(boolean value) {
        BoolLiteral lit = new BoolLiteral();
        lit.setValue(value);
        return lit;
    }

    public Exp createRef(String name) {
        Declaration declaration = this.rootDeclarations.get(name);
        if (declaration instanceof ConstantDecl) {
            return this.createConstRef(name);
        }
        if (declaration instanceof FunctionDecl) {
            return this.createFunctionRef(name, null);
        }
        if (this.currentContainer != null) {
            for (LocalVariable localVariable : this.currentContainer.getVarList()) {
                if (!name.equals(localVariable.getName())) continue;
                return this.createVarRef(name);
            }
            for (ArgumentVariable argumentVariable : this.currentContainer.getArgList()) {
                if (!name.equals(argumentVariable.getName())) continue;
                return this.createVarRef(name);
            }
        }
        if (this.existingConstr.contains(name)) {
            ConstrExp constrExp = new ConstrExp();
            constrExp.setName(name);
            return constrExp;
        }
        this.getErrorHandler().handleError(2, "Can't find reference for element named '" + name + "' " + (this.currentContainer != null ? "in " + this.currentContainer.getName() + "." : "."));
        return null;
    }

    public Exp createRefWithParams(String name, Exp param) {
        return this.createRefWithParams(name, Collections.singletonList(param));
    }

    public Exp createRefWithParams(String name, List<Exp> params) {
        Declaration declaration = this.rootDeclarations.get(name);
        if (declaration instanceof FunctionDecl) {
            return this.createFunctionRef(name, params);
        }
        if (declaration instanceof ExternalFunctionDecl) {
            return this.createExternalFunctionRef(name, params);
        }
        if (this.existingConstr.contains(name)) {
            return this.createConstrExp(name, params.get(0));
        }
        this.getErrorHandler().handleError(2, "[createRefWithParams] Can't find reference for element named '" + name + "'.");
        return null;
    }

    private Exp createExternalFunctionRef(String name, List<Exp> params) {
        ExternalFunctionRef exp = new ExternalFunctionRef();
        exp.setDecl(this.findDecl(name, ExternalFunctionDecl.class));
        if (params != null) {
            for (Exp param : params) {
                exp.addParam(param);
            }
        }
        return exp;
    }

    public Pattern createPatternRef(String name) {
        Declaration declaration = this.rootDeclarations.get(name);
        if (declaration instanceof ConstantDecl) {
            return this.createConstRef(name);
        }
        if (this.currentContainer != null) {
            for (LocalVariable localVariable : this.currentContainer.getVarList()) {
                if (!name.equals(localVariable.getName())) continue;
                return this.createVarRef(name);
            }
            for (ArgumentVariable argumentVariable : this.currentContainer.getArgList()) {
                if (!name.equals(argumentVariable.getName())) continue;
                return this.createVarRef(name);
            }
        }
        if (this.existingConstr.contains(name)) {
            ConstrPattern constrPatter = new ConstrPattern();
            constrPatter.setName(name);
            return constrPatter;
        }
        this.getErrorHandler().handleError(2, "[createPatternRef] Can't find reference for element named '" + name + "'.");
        return null;
    }

    private ConstantRef createConstRef(String name) {
        ConstantRef ref = new ConstantRef();
        ref.setDecl(this.findDecl(name, ConstantDecl.class));
        return ref;
    }

    private VarRef createVarRef(String name) {
        VarRef ref = new VarRef();
        ref.setDecl(this.findVariable(name));
        return ref;
    }

    public ArrayElem createArrayElem(Exp array, Exp index) {
        ArrayElem elem = new ArrayElem();
        elem.setArray(array);
        elem.setIndex(index);
        return elem;
    }

    public RecordElem createRecordElem(Exp record, String field) {
        RecordElem elem = new RecordElem();
        elem.setRecord(record);
        elem.setField(field);
        return elem;
    }

    public ValuedField createValuedField(String field, Exp value) {
        ValuedField vfield = new ValuedField();
        vfield.setField(field);
        vfield.setValue(value);
        return vfield;
    }

    public void clearCommentStack() {
        for (String comment : this.lexer.popComments()) {
            System.out.println(comment);
        }
    }

    private void attachComments(Commented commented) {
        for (String comment : this.lexer.popComments()) {
            commented.addComment(comment);
        }
    }

    private void registerDeclaration(String name, Declaration declaration) {
        if (this.rootDeclarations.containsKey(name)) {
            this.getErrorHandler().handleError(2, "Declaration '" + name + "' is declared twice.");
        }
        this.rootDeclarations.put(name, declaration);
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler == null ? ErrorHandler.simple : this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ExternalFunctionDecl createExternalFunctionDecl(String name, List<ExternalArgument> ats, Type r, String cname) {
        ExternalFunctionDecl eFD = new ExternalFunctionDecl();
        eFD.setName(name);
        if (ats != null) {
            eFD.addAllArg(ats);
        }
        eFD.setReturnType(r);
        eFD.setExternalName(cname);
        this.registerDeclaration(name, eFD);
        this.attachComments(eFD);
        return eFD;
    }

    public List<ExternalArgument> createExternalArgumentDecls(List<String> ps, Type n) {
        ArrayList<ExternalArgument> decls = new ArrayList<ExternalArgument>();
        ExternalArgument eA = new ExternalArgument();
        eA.setType(n);
        if (ps.isEmpty()) {
            eA.setRead(true);
        } else {
            eA.setRead(ps.contains("READ"));
            eA.setWrite(ps.contains("WRITE"));
        }
        decls.add(eA);
        return decls;
    }
}

