/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.checker.type;

import obp.fiacre.checker.type.CAny;
import obp.fiacre.checker.type.CType;

public class CArray
extends CType {
    private final CType inner;
    private final int size;

    public CArray(CType inner, int size) {
        this.inner = inner;
        this.size = size;
    }

    public CType getInner() {
        return this.inner;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public boolean isAssignableFrom(CType type) {
        if (type == null) {
            return false;
        }
        if (this == type) {
            return true;
        }
        if ((type = type.resolve()) == CAny.anyType) {
            return true;
        }
        if (!(type instanceof CArray)) {
            return false;
        }
        CArray other = (CArray)type;
        if (other.size != this.size) {
            return false;
        }
        return this.inner.isAssignableFrom(other.inner);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CArray) {
            CArray other = (CArray)obj;
            return this.inner.equals(other.inner) && this.size == other.size;
        }
        return false;
    }

    public String toString() {
        return "array " + this.size + " of " + this.inner;
    }
}

