/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.core;

import java.io.File;
import java.math.BigInteger;
import obp.cc.ConcreteContext;
import obp.explorer.ExplorerResult;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.core.ContextDrivenExplorer;
import obp.explorer.runtime.types.ConfigurationMapFactory;
import obp.explorer.runtime.types.ContextConfigurationMap;
import obp.result.FinalState;
import obp.util.ConcreteContextUtil;

public class PastFreeZeContextDrivenExplorer
extends ContextDrivenExplorer {
    public static int getExplorerID() {
        return 2;
    }

    public PastFreeZeContextDrivenExplorer(ProgramLoader programLoader, ConcreteContext context, File ccsl) {
        super(programLoader, context, ccsl);
    }

    @Override
    protected void createKnown() {
        int stateCount = this.context.getStateCount();
        this.known = ConfigurationMapFactory.createContextConfigurationMap(stateCount, this.contextBehaviorId);
    }

    @Override
    void onContextChange(int oldContextId, int newContextId) {
        ContextConfigurationMap map = (ContextConfigurationMap)this.known;
        System.err.println("Freeing context " + oldContextId + " which has " + map.size(oldContextId) + " configuration ");
        this.zappedConfigurations = (int)((long)this.zappedConfigurations + map.size(oldContextId));
        map.remove(oldContextId);
    }

    long countStoredConfigurations() {
        return this.known.size();
    }

    @Override
    public void endExploration() {
        System.err.println("Max accumulated reachability (Reached-Future) = " + ConcreteContextUtil.maxAccumulatedReachability(this.context));
        System.err.print("Context size " + this.currentContextState + ", zapped " + this.zappedConfigurations + " entries, ");
        System.err.println("final size was  " + this.getConfigurationCount() + " configurations and " + this.getActionCount().toString() + " transitions");
        super.endExploration();
    }

    @Override
    protected ExplorerResult onErrorDo(long start, OutOfMemoryError e) {
        long delay = System.currentTimeMillis() - start;
        this.results.setDuration((double)delay / 1000.0);
        this.results.setConfigurationCount(BigInteger.valueOf(this.getConfigurationCount()));
        this.results.setActionCount(this.getActionCount());
        this.results.setState(FinalState.Incomplete);
        System.err.print("reached Context " + this.currentContextState + ", free[ze]d " + this.zappedConfigurations + " configurations, ");
        System.err.println("final size was  " + this.getConfigurationCount() + " configurations and " + this.getActionCount().toString() + " transitions");
        System.err.println("ToSee has " + this.toSee.size() + " unexplored configurations\n");
        System.err.println("Out of memory: " + e.getMessage());
        return this.results;
    }
}

