/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.core;

import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import obp.cc.ConcreteContext;
import obp.explorer.ExplorerResult;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.Component;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.EnvFactory;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.ProcessBehavior;
import obp.explorer.runtime.Program;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.ccsl.CCSLBehavior;
import obp.explorer.runtime.ccsl.CCSLConfigurationGraph;
import obp.explorer.runtime.core.BasicFoldingExplorer;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.core.ExploringTransitionExecutor;
import obp.explorer.runtime.core.ITransitionExecutor;
import obp.explorer.runtime.core.SynchronizationExecuter;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.evaluator.ComposedEvaluator;
import obp.explorer.runtime.evaluator.Evaluator;
import obp.explorer.runtime.evaluator.StateEvaluator;
import obp.explorer.runtime.evaluator.Tester;
import obp.explorer.runtime.fiacre.ConcreteContextEnvFactory;
import obp.explorer.runtime.obs.Action;
import obp.explorer.runtime.obs.AtomicAction;
import obp.explorer.runtime.obs.EventTester;
import obp.explorer.runtime.obs.EventWatcher;
import obp.explorer.runtime.obs.ObsBehavior;
import obp.explorer.runtime.obs.ObsConfiguration;
import obp.explorer.runtime.obs.ObsTransition;
import obp.explorer.runtime.types.ConfigurationMapFactory;
import obp.explorer.runtime.types.DBMConfigurationMap;
import obp.explorer.runtime.types.IConfigurationMap;
import obp.explorer.runtime.util.ActionUtil;
import obp.explorer.runtime.util.ConfigurationUtil;
import obp.explorer.runtime.util.EvaluatorUtil;
import obp.result.FinalState;
import obp.util.PredicateUtil;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.JBoost;

public abstract class AbstractExplorer
implements ExplorationContext,
Cloneable {
    protected IConfigurationMap known;
    public ArrayList<Action> localActionList;
    public BigInteger actionCount;
    private File configurationOutputFile;
    protected JBoost boost;
    private int minimumAvaibleMemory = 50;
    private float minimumRatio = 0.01f;
    private boolean stopOnMinimumAvailableMemory;
    protected ITransitionExecutor transitionExecutor = new ExploringTransitionExecutor();
    protected SynchronizationExecuter synchronizationExecuter = new SynchronizationExecuter(this);
    private SynchronizationExecuter activationDetector = new SynchronizationExecuter(this);
    private BasicFoldingExplorer foldingExplorer = null;
    protected Behavior[] behaviors;
    private int observersStartIndex;
    private Tester[] observerMouvementTesters;
    private EventTester eventTester;
    private boolean[] localObserverRejectReached;
    private boolean rejectReached;
    private boolean[] localObserverSuccessReached;
    private boolean successReached;
    public Tester[] asserts;
    private ProgramLoader programLoader;
    private Program program;
    final ConcreteContext context;
    private final EnvFactory envFactory;
    protected SymbolsTable symbols;
    private Channel[] channels;
    private boolean[] actives;
    private boolean[] previouslyActives;
    private byte[] clockActivations;
    public ExplorerResult results;
    private File ccslFile;
    public int behaviorCount;
    public final long minMemory = this.minimumAvaibleMemory * 0x100000;
    public final long maxMemory = Runtime.getRuntime().maxMemory();
    private int minimumAvailableMemoryCount = 0;

    public static int getExplorerID() {
        return 0;
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractExplorer theClone = (AbstractExplorer)super.clone();
        theClone.known = this.known == null ? null : new DBMConfigurationMap();
        theClone.localActionList = this.localActionList == null ? null : new ArrayList<Action>(this.localActionList);
        theClone.localObserverRejectReached = (boolean[])this.localObserverRejectReached.clone();
        theClone.localObserverSuccessReached = (boolean[])this.localObserverSuccessReached.clone();
        theClone.transitionExecutor = (ITransitionExecutor)this.transitionExecutor.clone();
        theClone.transitionExecutor.setExplorer(theClone);
        theClone.synchronizationExecuter = (SynchronizationExecuter)this.synchronizationExecuter.clone();
        theClone.synchronizationExecuter.explorer = theClone;
        theClone.activationDetector = (SynchronizationExecuter)this.activationDetector.clone();
        theClone.activationDetector.explorer = theClone;
        return theClone;
    }

    public AbstractExplorer(ProgramLoader programLoader) {
        this(programLoader, null);
    }

    public AbstractExplorer(ProgramLoader programLoader, ConcreteContext context) {
        this(programLoader, context, null, context == null ? null : new ConcreteContextEnvFactory(context));
    }

    public AbstractExplorer(ProgramLoader programLoader, ConcreteContext context, EnvFactory envFactory) {
        this(programLoader, context, null, envFactory);
    }

    public AbstractExplorer(ProgramLoader programLoader, ConcreteContext context, File ccsl, EnvFactory envFactory) {
        this.programLoader = programLoader;
        this.context = context;
        this.envFactory = envFactory;
        this.ccslFile = ccsl;
        this.transitionExecutor.setExplorer(this);
    }

    public void setProgramLoader(ProgramLoader pL) {
        this.programLoader = pL;
    }

    public File getConfigutationOutputFile() {
        return this.configurationOutputFile;
    }

    public void setConfigurationOutputFile(File outputFile) {
        this.configurationOutputFile = outputFile;
    }

    public void setStopOnMinimumAvailableMemory(boolean stopOnMinimumAvailableMemory) {
        this.stopOnMinimumAvailableMemory = stopOnMinimumAvailableMemory;
    }

    private void init() {
        this.symbols = SymbolsTable.createInstance();
        this.actionCount = BigInteger.ZERO;
        this.localActionList = null;
        this.behaviors = null;
        this.observersStartIndex = 0;
        this.eventTester = null;
        this.channels = null;
        this.actives = null;
        if (this.configurationOutputFile != null) {
            try {
                ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(this.configurationOutputFile));
                this.boost = new JBoost("Explorer", 1);
                this.boost.initializeZippedWriting(stream, "configurations.txt");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't write to file '" + this.configurationOutputFile.getPath() + "'.");
            }
        } else {
            this.boost = null;
        }
        if (this.configurationOutputFile != null) {
            this.localActionList = new ArrayList();
        }
    }

    protected void createKnown() {
        this.known = ConfigurationMapFactory.createConfigurationMap();
    }

    public void endExploration() {
        this.end();
    }

    private void end() {
        this.getProgram().unloadExternalLibrary();
        if (this.configurationOutputFile != null) {
            ConfigurationUtil.write((Boost)this.boost, this.behaviors, null);
            ActionUtil.writeList((Boost)this.boost, this.localActionList);
            this.boost.close();
            this.boost = null;
        }
        if (this.configurationOutputFile != null) {
            this.localActionList = null;
        }
    }

    private Configuration createInitialConfiguration(Component root) {
        Object env;
        ArrayList<Behavior> behaviorList = new ArrayList<Behavior>();
        root.collectBehaviors(behaviorList);
        this.observersStartIndex = behaviorList.size();
        this.symbols.endOfBehaviors();
        if (this.ccslFile != null) {
            CCSLBehavior ccsl = new CCSLBehavior(new CCSLConfigurationGraph(this.ccslFile), this.symbols);
            behaviorList.add(ccsl);
            ++this.observersStartIndex;
            this.symbols.endOfBehaviors();
        }
        if (this.envFactory != null) {
            ObsBehavior[] obsBehaviorArray;
            env = this.envFactory.createEnv(this, this.symbols);
            if (env != null) {
                behaviorList.add((Behavior)env);
                ++this.observersStartIndex;
                this.symbols.endOfBehaviors();
            }
            if ((obsBehaviorArray = this.envFactory.createObservers(this, this.symbols)) != null) {
                for (ObsBehavior obsBehavior : obsBehaviorArray) {
                    behaviorList.add(obsBehavior);
                }
            }
        }
        this.behaviors = new Behavior[behaviorList.size()];
        env = behaviorList.iterator();
        while (env.hasNext()) {
            Behavior behavior;
            this.behaviors[behavior.id] = behavior = (Behavior)env.next();
        }
        this.asserts = this.envFactory != null ? this.envFactory.createAsserts(this, this.symbols) : new Tester[0];
        ArrayList<Channel> channelList = new ArrayList<Channel>();
        root.collectChannels(channelList);
        this.channels = new Channel[channelList.size()];
        Iterator iterator = channelList.iterator();
        while (iterator.hasNext()) {
            Channel channel;
            this.channels[channel.id] = channel = (Channel)iterator.next();
        }
        for (Behavior process3 : behaviorList) {
            process3.link(this, this.symbols);
        }
        this.transitionExecutor.init();
        this.synchronizationExecuter.init();
        this.activationDetector.init();
        int n = this.behaviors.length - this.observersStartIndex;
        this.localObserverRejectReached = new boolean[n];
        this.localObserverSuccessReached = new boolean[n];
        this.observerMouvementTesters = new Tester[n];
        for (int i = 0; i < n; ++i) {
            this.observerMouvementTesters[i] = this.createObserverMovementTester(this.behaviors[i + this.observersStartIndex]);
        }
        ArrayList<EventWatcher> eventWatchers = new ArrayList<EventWatcher>();
        for (int i = this.observersStartIndex; i < this.behaviors.length; ++i) {
            eventWatchers.addAll(((ObsBehavior)this.behaviors[i]).getEventWatchers());
        }
        this.eventTester = new EventTester(eventWatchers);
        this.actives = new boolean[this.channels.length];
        this.previouslyActives = new boolean[this.channels.length];
        this.clockActivations = new byte[this.symbols.getNumberOfClocks()];
        short numberOfClocks = this.symbols.getNumberOfClocks();
        short[] initDbm = null;
        if (numberOfClocks > 0) {
            initDbm = DBM.createAllDisable(numberOfClocks);
        }
        BehaviorConfiguration[] configurationArray = new BehaviorConfiguration[this.symbols.getNumberOfBehaviors()];
        Configuration configuration = new Configuration(configurationArray, initDbm);
        for (Behavior process4 : behaviorList) {
            configurationArray[process4.id] = process4.createInitialConfiguration(configuration);
        }
        if (initDbm != null) {
            this.applyDelayAndInvariant(null, configuration);
        }
        return configuration;
    }

    public boolean hasContext() {
        return this.envFactory != null;
    }

    private Tester createObserverMovementTester(Behavior behavior) {
        int inactiveId = -1;
        StateEvaluator inactiveEvaluator = EvaluatorUtil.createStateEvaluator(this, ObsConfiguration.class, -1);
        int stateId = behavior.getStateId("start");
        StateEvaluator startEvaluator = EvaluatorUtil.createStateEvaluator(this, ObsConfiguration.class, stateId);
        Evaluator[] children = new Evaluator[]{inactiveEvaluator, startEvaluator};
        ComposedEvaluator evalutator = new ComposedEvaluator(this, ComposedEvaluator.Type.Or, children);
        return new Tester(evalutator);
    }

    private void computeActives(Configuration configuration, boolean[] actives) {
        Arrays.fill(actives, false);
        for (int i = 0; i < this.observersStartIndex; i = (int)((short)(i + 1))) {
            ProcessBehavior behavior = (ProcessBehavior)this.behaviors[i];
            for (Transition transition : behavior.getTransitions(configuration)) {
                short channelId;
                if (!transition.guard(configuration, this) || (channelId = transition.getSynchronisationChannelId()) == -1) continue;
                this.activationDetector.addTransition(channelId, transition);
            }
        }
        this.activationDetector.computeActivations(actives);
    }

    public void applyDelayAndInvariant(Configuration source, Configuration target) {
        short clockId;
        int i;
        short[] dbm = target.dbm;
        if (source != null) {
            this.computeActives(source, this.previouslyActives);
        } else {
            Arrays.fill(this.previouslyActives, false);
        }
        this.computeActives(target, this.actives);
        Arrays.fill(this.clockActivations, (byte)2);
        for (i = 0; i < this.actives.length; i = (short)(i + 1)) {
            clockId = this.getChannel((short)i).clockId;
            this.clockActivations[clockId - 1] = 0;
        }
        for (i = 0; i < this.actives.length; i = (short)(i + 1)) {
            clockId = this.getChannel((short)i).clockId;
            if (!this.actives[i]) continue;
            this.clockActivations[clockId - 1] = this.previouslyActives[i] ? 2 : 1;
        }
        block6: for (i = 0; i < this.clockActivations.length; i = (short)(i + 1)) {
            switch (this.clockActivations[i]) {
                case 0: {
                    DBM.disable(dbm, i + 1);
                    continue block6;
                }
                case 1: {
                    DBM.set(dbm, i + 1, 0);
                }
            }
        }
        DBM.delay(dbm);
        for (i = 0; i < this.behaviors.length; ++i) {
            this.behaviors[i].invariant(target, this);
        }
        for (i = 0; i < this.actives.length; i = (int)((short)(i + 1))) {
            if (this.channels[i].clockId == -1 || !this.actives[i]) continue;
            DBM.andInvariant(dbm, this.channels[i].clockId, 0, this.channels[i].maxBoundInternal);
        }
    }

    public boolean observe(Configuration source, List<AtomicAction> actions2, Configuration target) {
        Arrays.fill(this.localObserverRejectReached, false);
        Arrays.fill(this.localObserverSuccessReached, false);
        this.rejectReached = false;
        this.successReached = false;
        boolean stop = false;
        this.eventTester.dispatch(source, actions2, target);
        for (int i = this.observersStartIndex; i < this.behaviors.length; ++i) {
            int localIndex = i - this.observersStartIndex;
            ObsBehavior behavior = (ObsBehavior)this.behaviors[i];
            this.eventTester.reset();
            if (behavior.isGreedy) {
                this.advanceObserver(source, target, localIndex, behavior);
            } else {
                this.advanceObserverSynchronously(source, target, localIndex, behavior);
            }
            ObsConfiguration me = (ObsConfiguration)target.behaviorConfigurations[i];
            if (behavior.isReject(me)) {
                this.localObserverRejectReached[localIndex] = true;
                this.rejectReached = true;
            }
            if (behavior.isSuccess(me)) {
                this.localObserverSuccessReached[localIndex] = true;
                this.successReached = true;
            }
            if (!behavior.isCut(me)) continue;
            stop = true;
        }
        return stop;
    }

    private void advanceObserver(Configuration source, Configuration target, int localIndex, ObsBehavior behavior) {
        boolean keepGoing = true;
        while (keepGoing) {
            boolean transitionFired = false;
            ObsTransition[] transitions = behavior.getTransitions();
            for (int j = 0; j < transitions.length; ++j) {
                short[] eventIds;
                ObsTransition transition = transitions[j];
                if (!transition.guard(source, target)) continue;
                short[] newDbm = DBM.copy(target.dbm);
                if (newDbm != null) {
                    transition.when(newDbm);
                }
                if (newDbm != null && DBM.isEmpty(newDbm) || (eventIds = transition.getEventIds()).length != 0 && !this.eventTester.testEvent(eventIds[0])) continue;
                if (target.dbm != null) {
                    transition.when(target.dbm);
                }
                BehaviorConfiguration me = target.replaceBehaviorConfigurationByCopy(transition.behaviorId);
                transition.action(target);
                boolean[] observerMovement = this.results.getObserverMovement();
                if (!observerMovement[localIndex]) {
                    observerMovement[localIndex] = !this.observerMouvementTesters[localIndex].test(me);
                }
                transitionFired = true;
                break;
            }
            if (transitionFired) continue;
            keepGoing = this.eventTester.discard();
        }
    }

    private void advanceObserverSynchronously(Configuration source, Configuration target, int localIndex, ObsBehavior behavior) {
        ObsTransition[] transitions = behavior.getTransitions();
        for (int j = 0; j < transitions.length; ++j) {
            ObsTransition transition = transitions[j];
            if (!transition.guard(source, target)) continue;
            short[] newDbm = DBM.copy(target.dbm);
            if (newDbm != null) {
                transition.when(newDbm);
            }
            if (newDbm != null && DBM.isEmpty(newDbm)) continue;
            boolean allNeededEventsArePresent = true;
            for (short eventId : transition.getEventIds()) {
                if (!this.eventTester.isTheEventAmongstTheActions(eventId)) {
                    allNeededEventsArePresent &= false;
                    break;
                }
                allNeededEventsArePresent &= true;
            }
            if (!allNeededEventsArePresent) continue;
            if (target.dbm != null) {
                transition.when(target.dbm);
            }
            BehaviorConfiguration me = target.replaceBehaviorConfigurationByCopy(transition.behaviorId);
            transition.action(target);
            boolean[] observerMovement = this.results.getObserverMovement();
            if (observerMovement[localIndex]) break;
            observerMovement[localIndex] = !this.observerMouvementTesters[localIndex].test(me);
            break;
        }
    }

    protected abstract void onRegisterActionAndTarget(Configuration var1, List<AtomicAction> var2, Configuration var3);

    public void registerActionAndTarget(Configuration source, List<AtomicAction> actions2, Configuration target) {
        int i;
        if (this.foldingExplorer != null && this.foldingExplorer.checkFoldingPredicate(target)) {
            this.foldingExplorer.setInitialConfiguration(target);
            this.foldingExplorer.explore();
            Collection result = this.foldingExplorer.getResult();
            for (Configuration newTarget : result) {
                this.registerActionAndTarget(source, actions2, newTarget);
            }
            return;
        }
        Configuration registerTarget = this.registerNewConfiguration(target);
        Action systemAction = new Action(actions2, registerTarget.id);
        this.addAction(systemAction);
        if (this.rejectReached) {
            int[] observerRejectReachedFirstConfiguration = this.results.getObserverRejectReachedFirstConfiguration();
            for (i = 0; i < this.localObserverRejectReached.length; ++i) {
                if (!this.localObserverRejectReached[i] || observerRejectReachedFirstConfiguration[i] >= 0) continue;
                observerRejectReachedFirstConfiguration[i] = target.id;
            }
        }
        if (this.successReached) {
            int[] observerSuccessReachedFirstConfiguration = this.results.getObserverSuccessReachedFirstConfiguration();
            for (i = 0; i < this.localObserverSuccessReached.length; ++i) {
                if (!this.localObserverSuccessReached[i] || observerSuccessReachedFirstConfiguration[i] >= 0) continue;
                observerSuccessReachedFirstConfiguration[i] = target.id;
            }
        }
        this.onRegisterActionAndTarget(source, actions2, registerTarget);
    }

    protected abstract void onNewConfiguration(Configuration var1);

    protected abstract void onExistingConfiguration(Configuration var1);

    protected Configuration registerNewConfiguration(Configuration newConfiguration) {
        Configuration existingConfiguration = this.getKnown(newConfiguration);
        if (existingConfiguration != null) {
            this.onExistingConfiguration(existingConfiguration);
            return existingConfiguration;
        }
        newConfiguration.id = (int)this.getConfigurationCount();
        if (this.asserts != null) {
            int[] assertsViolatedFirstConfiguration = this.results.getAssertsViolatedFirstConfiguration();
            for (int i = 0; i < this.asserts.length; ++i) {
                if (assertsViolatedFirstConfiguration[i] >= 0 || this.asserts[i].test(newConfiguration)) continue;
                assertsViolatedFirstConfiguration[i] = newConfiguration.id;
            }
        }
        this.addToKnown(newConfiguration);
        this.onNewConfiguration(newConfiguration);
        return newConfiguration;
    }

    protected Configuration getKnown(Configuration newConfiguration) {
        return this.known.get(newConfiguration);
    }

    void addToKnown(Configuration c) {
        this.known.put(c);
    }

    protected void saveConfiguration(Configuration configuration) {
        if (this.boost != null) {
            ConfigurationUtil.write((Boost)this.boost, this.behaviors, configuration);
            ActionUtil.writeList((Boost)this.boost, this.localActionList);
        }
        this.clearActionList();
    }

    private void addAction(Action action) {
        if (this.configurationOutputFile != null) {
            this.localActionList.add(action);
        }
        this.actionCount = this.actionCount.add(BigInteger.ONE);
    }

    private void clearActionList() {
        if (this.configurationOutputFile != null) {
            this.localActionList.clear();
        }
    }

    public BigInteger getActionCount() {
        return this.actionCount;
    }

    public void initializeExploration() {
        Configuration initial = this.prepareExploration();
        if (initial.dbm != null) {
            ConfigurationMapFactory.hasDBM = true;
        }
        this.createKnown();
        this.registerNewConfiguration(initial);
        this.behaviorCount = this.getProcessBehaviorCount();
        if (this.context != null && this.context.getFoldingPredicate() != null) {
            this.foldingExplorer = new BasicFoldingExplorer(this);
        }
    }

    public abstract boolean atEnd();

    public abstract Configuration nextConfiguration();

    protected void explorationStep() {
        this.checkMemoryLimit(this.minMemory, this.maxMemory, 1000);
        Configuration configuration = this.nextConfiguration();
        this.fireTransitions(configuration);
    }

    public void fireTransitions(Configuration configuration) {
        for (int i = 0; i < this.behaviorCount; i = (int)((short)(i + 1))) {
            ProcessBehavior behavior = (ProcessBehavior)this.behaviors[i];
            for (Transition transition : behavior.getTransitions(configuration)) {
                if (!transition.guard(configuration, this)) continue;
                short channelId = transition.getSynchronisationChannelId();
                if (channelId == -1) {
                    this.transitionExecutor.executeAlone(configuration, transition);
                    continue;
                }
                this.synchronizationExecuter.addTransition(channelId, transition);
            }
        }
        this.synchronizationExecuter.computeSynchronizedTransition(configuration, this.transitionExecutor);
        this.saveConfiguration(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExplorerResult explore() {
        this.initializeExploration();
        long start = System.currentTimeMillis();
        System.err.println("Exploration with: " + this.getClass().getSimpleName());
        System.err.println("The DBM has " + this.symbols.getNumberOfClocks() + " clocks");
        try {
            while (!this.atEnd()) {
                this.explorationStep();
            }
        }
        catch (OutOfMemoryError e) {
            ExplorerResult er;
            ExplorerResult explorerResult = er = this.onErrorDo(start, e);
            return explorerResult;
        }
        finally {
            this.endExploration();
        }
        long delay = System.currentTimeMillis() - start;
        this.results.setDuration((double)delay / 1000.0);
        this.results.setConfigurationCount(BigInteger.valueOf(this.getConfigurationCount()));
        this.results.setActionCount(this.getActionCount());
        this.results.setState(FinalState.Complete);
        return this.results;
    }

    protected ExplorerResult onErrorDo(long start, OutOfMemoryError e) {
        long delay = System.currentTimeMillis() - start;
        this.results.setDuration((double)delay / 1000.0);
        this.results.setConfigurationCount(BigInteger.valueOf(this.getConfigurationCount()));
        this.results.setActionCount(this.getActionCount());
        this.results.setState(FinalState.Incomplete);
        System.err.println("Out of memory: " + e.getMessage());
        return this.results;
    }

    protected Configuration prepareExploration() {
        Component root;
        this.init();
        try {
            this.program = this.programLoader.loadProgram();
            root = this.program.getRoot(this.symbols);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(DiagnosticUtil.createMessage((Throwable)e));
        }
        Configuration initConfiguration = this.createInitialConfiguration(root);
        this.results = new ExplorerResult(this.programLoader, this.context, this.ccslFile, this.configurationOutputFile);
        String[] observerDescriptions = new String[this.behaviors.length - this.observersStartIndex];
        for (int i = 0; i < observerDescriptions.length; ++i) {
            observerDescriptions[i] = this.behaviors[this.observersStartIndex + i].name;
        }
        String[] assertDescriptions = new String[this.asserts.length];
        for (int i = 0; i < assertDescriptions.length; ++i) {
            assertDescriptions[i] = PredicateUtil.printPredicate(this.context.getAssert(i));
        }
        this.results.initialize(observerDescriptions, assertDescriptions);
        List<AtomicAction> emptyActions = Collections.emptyList();
        this.observe(initConfiguration, emptyActions, initConfiguration);
        return initConfiguration;
    }

    protected void checkMemoryLimit(long minimumMemory, long maxMemory, int frequency) throws OutOfMemoryError {
        ++this.minimumAvailableMemoryCount;
        if (this.stopOnMinimumAvailableMemory && this.minimumAvailableMemoryCount % frequency == 0) {
            long freeMemory = Runtime.getRuntime().freeMemory();
            if (freeMemory < minimumMemory) {
                throw new OutOfMemoryError("Minimum amount of free memory has been reached (" + freeMemory + " octets left).");
            }
            float ratio = (float)freeMemory / (float)maxMemory;
            if (ratio < this.minimumRatio) {
                throw new OutOfMemoryError("Minimum ratio of free memory has been reached (" + freeMemory + " octets left).");
            }
        }
    }

    public String configurationToString(Configuration configuration) {
        int i;
        int length;
        StringBuilder text = new StringBuilder();
        text.append(configuration.id);
        text.append("{\n");
        for (int i2 = 0; i2 < this.behaviors.length; ++i2) {
            text.append("- ");
            text.append(this.behaviors[i2].toStringConfiguration(configuration.behaviorConfigurations[i2]));
            text.append("\n");
        }
        if (configuration.dbm != null) {
            text.append("- Time ");
            text.append(DBM.toConstrainString(configuration.dbm));
            text.append("\n");
        }
        if (this.channels.length > 0) {
            text.append("- Channels ");
            length = text.length();
            for (i = 0; i < this.channels.length; ++i) {
                Channel channel = this.channels[i];
                if (text.length() > length) {
                    text.append(", ");
                }
                text.append(channel.name);
                if (channel.clockId < 0) continue;
                text.append("{clock:");
                text.append(channel.clockId);
                text.append("}");
            }
            text.append("\n");
        }
        if (this.asserts.length > 0) {
            text.append("- Violated asserts: ");
            length = text.length();
            for (i = 0; i < this.asserts.length; ++i) {
                if (this.asserts[i].test(configuration)) continue;
                if (text.length() > length) {
                    text.append(", ");
                }
                text.append(this.results.getAssertDescriptions()[i]);
            }
            if (text.length() == length) {
                text.append("none");
            }
            text.append("\n");
        }
        text.append("}");
        return text.toString();
    }

    public long getConfigurationCount() {
        return this.known.size();
    }

    public Set<Configuration> getConfigurationSet() {
        return this.known.getConfigurations();
    }

    @Override
    public ConcreteContext getContext() {
        return this.context;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public Behavior getBehavior(short id) {
        return this.behaviors[id];
    }

    @Override
    public int getProcessBehaviorCount() {
        return this.observersStartIndex;
    }

    @Override
    public int getBehaviorCount() {
        return this.behaviors.length;
    }

    @Override
    public Channel getChannel(short id) {
        return this.channels[id];
    }

    @Override
    public int getChannelCount() {
        return this.channels.length;
    }

    @Override
    public File getCCSLFile() {
        return this.ccslFile;
    }
}

