/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime;

import java.util.HashMap;
import java.util.Map;
import obp.explorer.runtime.SymbolsTableWithCompactDBM;

public class SymbolsTable {
    private short currentBehaviorId = 0;
    private int observersStartIndex;
    private final Map<String, Short> behaviorIdMap = new HashMap<String, Short>();
    private short currentChannelId = 0;
    private final Map<String, Short> channelIdMap = new HashMap<String, Short>();
    private short currentInformalId = 0;
    private final Map<String, Short> informalIdMap = new HashMap<String, Short>();
    private short currentEventId = 0;
    private final Map<String, Short> eventIdMap = new HashMap<String, Short>();
    private short currentClockIndex = 1;

    public static SymbolsTable createInstance() {
        return new SymbolsTableWithCompactDBM();
    }

    protected short registerNextClockIndexes(short size) {
        try {
            short s = this.currentClockIndex;
            return s;
        }
        finally {
            this.currentClockIndex = (short)(this.currentClockIndex + size);
        }
    }

    protected short registerNextClockIndex() {
        return this.registerNextClockIndexes((short)1);
    }

    public String newBehaviorName(String parentName, short instanceId) {
        String result = "{" + parentName + "}" + instanceId;
        this.newBehaviorId(result);
        return result;
    }

    public String newComponentName(String parentName, short instanceId) {
        return "{" + parentName + "}" + instanceId;
    }

    private void newBehaviorId(String name) {
        short s = this.currentBehaviorId;
        this.currentBehaviorId = (short)(s + 1);
        short newId = s;
        if (name != null) {
            if (this.behaviorIdMap.containsKey(name)) {
                throw new IllegalArgumentException("Behavior named '" + name + "' is duplicated.");
            }
            this.behaviorIdMap.put(name, newId);
        }
    }

    public void endOfBehaviors() {
        this.observersStartIndex = this.currentBehaviorId;
    }

    public int getObserversStartIndex() {
        return this.observersStartIndex;
    }

    public short newChannelId(String name) {
        short s = this.currentChannelId;
        this.currentChannelId = (short)(s + 1);
        short newId = s;
        if (name != null) {
            if (this.channelIdMap.containsKey(name)) {
                throw new IllegalArgumentException("Channel named '" + name + "' is duplicated.");
            }
            this.channelIdMap.put(name, newId);
        }
        return newId;
    }

    public short newInformalId(String name) {
        short s = this.currentInformalId;
        this.currentInformalId = (short)(s + 1);
        short newId = s;
        if (this.informalIdMap.containsKey(name)) {
            throw new IllegalArgumentException("Informal named '" + name + "' is duplicated.");
        }
        this.informalIdMap.put(name, newId);
        return newId;
    }

    public short newEventId(String name) {
        short s = this.currentEventId;
        this.currentEventId = (short)(s + 1);
        short newId = s;
        if (this.eventIdMap.containsKey(name)) {
            throw new IllegalArgumentException("Event named '" + name + "' is duplicated.");
        }
        this.eventIdMap.put(name, newId);
        return newId;
    }

    public short newClockIndex() {
        return this.registerNextClockIndex();
    }

    public short getBehaviorId(String name) {
        if (!this.behaviorIdMap.containsKey(name)) {
            throw new IllegalArgumentException("Behavior named '" + name + "' can't be resolved.");
        }
        return this.behaviorIdMap.get(name);
    }

    public short getBehaviorId(String name, short instanceId) {
        return this.getBehaviorId("{" + name + "}" + instanceId);
    }

    public short getChannelId(String name) {
        if (!this.channelIdMap.containsKey(name)) {
            throw new IllegalArgumentException("Channel named '" + name + "' can't be resolved.");
        }
        return this.channelIdMap.get(name);
    }

    public String getBehaviorName(short id) {
        for (Map.Entry<String, Short> entry : this.behaviorIdMap.entrySet()) {
            if (entry.getValue() != id) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getChannelName(short id) {
        for (Map.Entry<String, Short> entry : this.channelIdMap.entrySet()) {
            if (entry.getValue() != id) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Channel id '" + id + "' can't be resolved.");
    }

    public String getInformalName(short id) {
        for (Map.Entry<String, Short> entry : this.informalIdMap.entrySet()) {
            if (entry.getValue() != id) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Informal id '" + id + "' can't be resolved.");
    }

    public String getEventName(short id) {
        for (Map.Entry<String, Short> entry : this.eventIdMap.entrySet()) {
            if (entry.getValue() != id) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Event id '" + id + "' can't be resolved.");
    }

    public short getInformalId(String name) {
        if (!this.informalIdMap.containsKey(name)) {
            throw new IllegalArgumentException("Informal named '" + name + "' can't be resolved.");
        }
        return this.informalIdMap.get(name);
    }

    public short getEventId(String name) {
        if (!this.eventIdMap.containsKey(name)) {
            throw new IllegalArgumentException("Event named '" + name + "' can't be resolved.");
        }
        return this.eventIdMap.get(name);
    }

    public boolean doesInformalExist(String name) {
        return this.informalIdMap.containsKey(name);
    }

    public boolean doesEventExist(String name) {
        return this.eventIdMap.containsKey(name);
    }

    public short getNumberOfBehaviors() {
        return this.currentBehaviorId;
    }

    public short getNumberOfChannels() {
        return this.currentChannelId;
    }

    public short getNumberOfInformals() {
        return this.currentInformalId;
    }

    public short getNumberOfEvents() {
        return this.currentEventId;
    }

    public short getNumberOfClocks() {
        return (short)(this.currentClockIndex - 1);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("SymbolsTable{");
        text.append("\n");
        text.append("Behaviors : ");
        text.append(this.behaviorIdMap);
        text.append("\n");
        text.append("Channels : ");
        text.append(this.channelIdMap);
        text.append("\n");
        text.append("Informals : ");
        text.append(this.informalIdMap);
        text.append("\n");
        text.append("Events : ");
        text.append(this.eventIdMap);
        text.append("\n");
        text.append("}");
        return text.toString();
    }

    public void registerClockIndexes(short behaviorId, short size) {
    }

    public short getClockIndexFromOffset(short behaviorId, short offset) {
        return this.registerNextClockIndex();
    }

    public short newClockIndexWith(int minBound, boolean minBoundStrict, int maxBound, boolean maxBoundStrict) {
        return this.newClockIndex();
    }
}

