/*
 * Decompiled with CFR 0.152.
 */
package plug.composite;

import java.util.Arrays;
import java.util.List;
import plug.core.IConfiguration;
import plug.core.defaults.DefaultConfiguration;

public class CompositeConfiguration
extends DefaultConfiguration<CompositeConfiguration> {
    IConfiguration[] components;

    public CompositeConfiguration() {
    }

    public CompositeConfiguration(int size) {
        this.components = new IConfiguration[size];
    }

    CompositeConfiguration(List<IConfiguration> components) {
        this.components = components.toArray(new IConfiguration[0]);
    }

    public int add(IConfiguration primitiveConfiguration) {
        if (primitiveConfiguration != null) {
            this.components = Arrays.copyOf(this.components, this.components.length + 1);
            this.set(this.components.length - 1, primitiveConfiguration);
        }
        return this.components.length - 1;
    }

    public IConfiguration get(int index) {
        if (0 > index && index > this.components.length) {
            return null;
        }
        return this.components[index];
    }

    public IConfiguration[] getComponents() {
        return this.components;
    }

    public IConfiguration set(int index, IConfiguration primitiveConfiguration) {
        if (0 > index && index > this.components.length) {
            return null;
        }
        IConfiguration old = this.components[index];
        this.components[index] = primitiveConfiguration;
        return old;
    }

    @Override
    public CompositeConfiguration createCopy() {
        CompositeConfiguration newC = new CompositeConfiguration();
        newC.components = Arrays.copyOf(this.components, this.components.length);
        return newC;
    }

    public String toString() {
        return Arrays.toString(this.components);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CompositeConfiguration) {
            CompositeConfiguration other = (CompositeConfiguration)obj;
            if (Arrays.equals(this.components, other.components)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.components);
    }
}

