/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanVariable;
import fr.ensta.aefd.model.AEFDModelObject;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.runtime.AEFDRuntime;
import fr.ensta.aefd.runtime.AEFDRuntimeInfos;
import fr.ensta.aefd.runtime.AEFDRuntimeSystemState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import plug.core.IRuntimeView;
import plug.core.ITransitionRelation;
import plug.core.view.ConfigurationItem;
import plug.folding.runtime.FoldedTransition;
import plug.folding.runtime.FoldingRuntime;

public class AEFDRuntimeView
implements IRuntimeView<AEFDRuntimeSystemState, Object> {
    private final FoldingRuntime runtime;

    public AEFDRuntimeView(FoldingRuntime runtime) {
        this.runtime = runtime;
    }

    public ITransitionRelation<AEFDRuntimeSystemState, Object> getRuntime() {
        return this.runtime;
    }

    public List<ConfigurationItem> getConfigurationItems(AEFDRuntimeSystemState aefdRuntimeSystemState) {
        ArrayList<ConfigurationItem> result = new ArrayList<ConfigurationItem>();
        AEFDRuntimeInfos infos = ((AEFDRuntime)this.runtime.baseRuntime).infos;
        ArrayList<ConfigurationItem> states = new ArrayList<ConfigurationItem>();
        for (int automateIndex = 0; automateIndex < infos.getNumberOfAutomates(); ++automateIndex) {
            AEFDAutomate automate = infos.getAutomateFromIndex(automateIndex);
            int automateStateIndex = aefdRuntimeSystemState.getAutomatesStates()[automateIndex];
            String automateState = infos.getAutomateStateFromIndex(automate, automateStateIndex);
            states.add(new ConfigurationItem("state", automate.getName() + "@" + automateState, null, null));
        }
        result.add(new ConfigurationItem("states", "states", null, states));
        ArrayList<ConfigurationItem> variables = new ArrayList<ConfigurationItem>();
        for (int variableIndex = 0; variableIndex < infos.getNumberOfVariables(); ++variableIndex) {
            AEFDBooleanVariable variable = infos.getVariableFromIndex(variableIndex);
            boolean value = aefdRuntimeSystemState.getVariables()[variableIndex];
            variables.add(new ConfigurationItem("variable", variable.getName() + " is " + value, null, null));
        }
        result.add(new ConfigurationItem("variables", "variables", null, variables));
        ArrayList<ConfigurationItem> events = new ArrayList<ConfigurationItem>();
        events.add(new ConfigurationItem("event", "currentEvent=" + (aefdRuntimeSystemState.hasCurrentEvent() ? infos.getEventFromIndex(aefdRuntimeSystemState.getCurrentEvent()).getIdentifier() : ""), null, null));
        String highPriorityEventsString = aefdRuntimeSystemState.getHighPriorityQueue().stream().map(idx -> infos.getEventFromIndex((int)idx).getIdentifier()).collect(Collectors.joining(", "));
        events.add(new ConfigurationItem("highPriorityEvents", "high=[" + highPriorityEventsString + "]", null, null));
        String lowPriorityEventsString = aefdRuntimeSystemState.getLowPriorityQueue().stream().map(idx -> infos.getEventFromIndex((int)idx).getIdentifier()).collect(Collectors.joining(", "));
        events.add(new ConfigurationItem("lowPriorityEvents", "low=[" + lowPriorityEventsString + "]", null, null));
        result.add(new ConfigurationItem("events", "events", null, events));
        result.add(new ConfigurationItem("execSet", "execSet=" + Arrays.toString(aefdRuntimeSystemState.getExecutedAutomates().toArray()), null, null));
        ArrayList<ConfigurationItem> checks = new ArrayList<ConfigurationItem>();
        checks.add(new ConfigurationItem("check", "cut=" + aefdRuntimeSystemState.isCutState(), null, null));
        checks.add(new ConfigurationItem("check", "reject=" + aefdRuntimeSystemState.isRejectState(), null, null));
        checks.add(new ConfigurationItem("check", "warning=" + aefdRuntimeSystemState.isWarningState(), null, null));
        result.add(new ConfigurationItem("checks", "checks", null, checks));
        return result;
    }

    public String getFireableTransitionDescription(Object aefdTransition) {
        if (aefdTransition instanceof FoldedTransition) {
            return aefdTransition.toString();
        }
        AEFDRuntime aefdRuntime = (AEFDRuntime)this.runtime.baseRuntime;
        return aefdRuntime.infos.getTransitionOwner((AEFDTransition)aefdTransition).getName() + "\n" + aefdRuntime.printer.getAEFDString((AEFDModelObject)((AEFDTransition)aefdTransition)).replaceAll("null\n", "").replaceAll("([0-9]+)\n([0-9]+)", "$1 -> $2").trim();
    }
}

