/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.transform;

import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.toolbox.tools.handler.ModelHandles;
import java.util.LinkedList;

public class RemoveUselessAutomates {
    private AEFDModel model;
    private ModelHandles handles;
    private LinkedList<AEFDAutomate> automatesToRemove = new LinkedList();
    private int removedCount;

    public void transform(AEFDModel model, ModelHandles handles) {
        this.model = model;
        this.handles = handles;
        this.automatesToRemove.clear();
        handles.log("Removing useless automates.");
        for (AEFDAutomate automate : model.getAllAutomates()) {
            if (!this.isUseless(automate)) continue;
            this.automatesToRemove.add(automate);
        }
        for (AEFDAutomate automate : this.automatesToRemove) {
            handles.removeAutomate(automate, "No actions");
        }
        handles.log("Done removing useless automates (" + this.automatesToRemove.size() + ")");
        this.removedCount = this.automatesToRemove.size();
        handles.logPrettyPrint();
    }

    public int getRemovedCount() {
        return this.removedCount;
    }

    private boolean isUseless(AEFDAutomate automate) {
        for (AEFDTransition transition : automate.getTransitionSet()) {
            if (transition.getAction().getActionList().isEmpty()) continue;
            return false;
        }
        return true;
    }
}

