/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.printer.fiacre;

import fr.ensta.aefd.model.AEFDAction;
import fr.ensta.aefd.model.AEFDActionSequence;
import fr.ensta.aefd.model.AEFDAutomate;
import fr.ensta.aefd.model.AEFDBooleanExpression;
import fr.ensta.aefd.model.AEFDCondition;
import fr.ensta.aefd.model.AEFDFunctionalEntity;
import fr.ensta.aefd.model.AEFDModel;
import fr.ensta.aefd.model.AEFDModelVisitor;
import fr.ensta.aefd.model.AEFDPrefix;
import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.toolbox.tools.printer.fiacre.BooleanVariablesArray;
import fr.ensta.aefd.toolbox.tools.printer.fiacre.HelperBus;
import fr.ensta.aefd.toolbox.tools.printer.fiacre.ProcessEnabledArray;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BinOp;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.Exp;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Seq;
import obp.fiacre.model.State;
import obp.fiacre.model.Statement;
import obp.fiacre.model.To;
import obp.fiacre.model.Transition;
import obp.fiacre.model.Type;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Variable;

public class ProcessGenerator
extends AEFDModelVisitor.Stub {
    private final HelperBus helper;
    private AEFDModel model;
    private boolean fixedOrder = true;
    private BooleanVariablesArray booleanVariablesArray;
    private ProcessEnabledArray processEnabledArray;
    private AEFDAutomate automate;
    private ProcessDecl process;
    private ArgumentVariable currentEventVariable;
    private ArgumentVariable highPriorityQueue;
    private ArgumentVariable lowPriorityQueue;
    private Map<String, State> stateMap;
    private Map<AEFDAutomate, ProcessDecl> processDeclMap;
    private AEFDTransition currentTransition;
    private Exp conditionExp;
    private Seq actionSeq;
    private String informal;

    public ProcessGenerator(HelperBus helper) {
        this.helper = helper;
    }

    public boolean isFixedOrder() {
        return this.fixedOrder;
    }

    public void setFixedOrder(boolean fixedOrder) {
        this.fixedOrder = fixedOrder;
    }

    public void generate(AEFDModel model) {
        this.model = model;
        this.booleanVariablesArray = this.helper.booleanVariablesArray;
        this.processEnabledArray = this.helper.processEnabledArray;
        this.helper.order.analyze(model);
        this.processDeclMap = new HashMap<AEFDAutomate, ProcessDecl>();
        for (AEFDAutomate automate : model.getAllAutomates()) {
            this.generate(automate);
        }
    }

    public ProcessDecl getProcessDecl(AEFDAutomate automate) {
        return this.processDeclMap.get(automate);
    }

    private void setSignature() {
        this.currentEventVariable = new ArgumentVariable();
        this.currentEventVariable.setName("currentEvent");
        this.currentEventVariable.setRead(true);
        this.currentEventVariable.setWrite(false);
        this.currentEventVariable.setRef(true);
        this.currentEventVariable.setType((Type)this.helper.events.getUnionTypeId());
        this.process.addArg(this.currentEventVariable);
        this.highPriorityQueue = new ArgumentVariable();
        this.highPriorityQueue.setName("hFIFO");
        this.highPriorityQueue.setWrite(true);
        this.highPriorityQueue.setRead(false);
        this.highPriorityQueue.setRef(true);
        this.highPriorityQueue.setType((Type)this.helper.events.getFifoTypeId());
        this.process.addArg(this.highPriorityQueue);
        this.lowPriorityQueue = new ArgumentVariable();
        this.lowPriorityQueue.setName("lFIFO");
        this.lowPriorityQueue.setWrite(true);
        this.lowPriorityQueue.setRead(false);
        this.lowPriorityQueue.setRef(true);
        this.lowPriorityQueue.setType((Type)this.helper.events.getFifoTypeId());
        this.process.addArg(this.lowPriorityQueue);
        this.process.addArg(this.booleanVariablesArray.getArgument(this.automate));
        this.process.addArg(this.processEnabledArray.getArgument(this.automate));
    }

    private void addStates() {
        this.stateMap = new IdentityHashMap<String, State>();
        for (String s : this.automate.getPlaceSet()) {
            State state = new State();
            state.setName("s" + s);
            this.process.addState(state);
            this.stateMap.put(s.intern(), state);
        }
    }

    private void setupInit() {
        To toStmt = new To();
        toStmt.setDest(this.stateMap.get(this.automate.getInitialPlace().intern()));
        this.process.setInitAction((Statement)toStmt);
    }

    private void generate(AEFDAutomate automate) {
        this.automate = automate;
        this.process = new ProcessDecl();
        this.process.setName(automate.getName());
        this.setSignature();
        this.addStates();
        this.setupInit();
        if (automate.getName() != "Environment") {
            LinkedList<String> sortedStates = new LinkedList<String>();
            sortedStates.addAll(this.stateMap.keySet());
            Collections.sort(sortedStates);
            for (String fromState : sortedStates) {
                this.addTransition(fromState);
            }
        } else {
            for (AEFDTransition envTransition : automate.getTransitionSet()) {
                this.addEnvTransition(envTransition);
            }
        }
        this.processDeclMap.put(automate, this.process);
    }

    private Statement getGuard() {
        return this.helper.master.on(this.processEnabledArray.buildEvaluation(this.automate, this.automate));
    }

    private Statement getOrderGuard() {
        Exp condition = null;
        for (AEFDAutomate other : this.helper.order.getHigherPriorityAutomates(this.automate)) {
            Exp oneGuard = this.processEnabledArray.buildEvaluation(this.automate, other);
            if (condition == null) {
                condition = oneGuard;
                continue;
            }
            condition = this.helper.builder.or(condition, oneGuard);
        }
        if (condition == null) {
            return null;
        }
        CaseStmt result = this.helper.master.on(this.helper.builder.not(condition));
        result.addComment("Fixed order");
        return result;
    }

    private Statement getAdditionalEnvGuard(AEFDTransition transition) {
        transition.getCondition().accept(this);
        return this.helper.master.on(this.conditionExp);
    }

    private Statement getDisablingStatement() {
        return this.processEnabledArray.buildAffectation(this.automate, this.automate, false);
    }

    private To getToStmt(String toPlace, String informal) {
        To toStmt = new To();
        toStmt.setDest(this.stateMap.get(toPlace.intern()));
        if (informal != null) {
            toStmt.addComment("@" + informal);
        }
        return toStmt;
    }

    private void addEnvTransition(AEFDTransition envTransition) {
        Transition transition = new Transition();
        this.currentTransition = envTransition;
        transition.setFrom(this.stateMap.get(envTransition.getPlaceSource().intern()));
        Seq body = new Seq();
        body.addStatement(this.getGuard());
        body.addStatement(this.getAdditionalEnvGuard(envTransition));
        body.addStatement(this.getDisablingStatement());
        envTransition.getAction().accept(this);
        for (Statement stmt : this.actionSeq.getStatementList()) {
            body.addStatement(stmt);
        }
        transition.setAction((Statement)body);
        this.process.addTransition(transition);
    }

    private void addTransition(String fromState) {
        Transition transition = new Transition();
        transition.setFrom(this.stateMap.get(fromState));
        Seq body = new Seq();
        body.addStatement(this.getGuard());
        Statement orderStatement = this.getOrderGuard();
        if (orderStatement != null) {
            body.addStatement(orderStatement);
        }
        body.addStatement(this.getDisablingStatement());
        CaseStmt caseStmt = this.getCase(fromState);
        if (caseStmt.getRuleCount() > 0) {
            body.addStatement((Statement)caseStmt);
        }
        body.addStatement((Statement)this.getToStmt(fromState, null));
        transition.setAction((Statement)body);
        this.process.addTransition(transition);
    }

    private CaseStmt getCase(String fromState) {
        CaseStmt result = new CaseStmt();
        VarRef ref = new VarRef();
        ref.setDecl((Variable)this.currentEventVariable);
        result.setExp((Exp)ref);
        for (AEFDFunctionalEntity event : this.helper.events.getInputs(this.automate)) {
            Rule rule = this.getRule(fromState, event);
            result.addRule(rule);
        }
        return result;
    }

    private Rule getRule(String fromState, AEFDFunctionalEntity event) {
        Rule rule = new Rule();
        rule.setLhs((Pattern)this.helper.events.getConstrPattern(event));
        IfStmt body = null;
        for (AEFDTransition transition : this.helper.events.getSensibleTransitions(this.automate, event)) {
            if (!transition.getPlaceSource().equals(fromState)) continue;
            this.currentTransition = transition;
            IfStmt currentIf = new IfStmt();
            transition.getCondition().accept(this);
            currentIf.setCondition(this.conditionExp);
            transition.getAction().accept(this);
            currentIf.setThen((Statement)this.actionSeq);
            if (body == null) {
                body = currentIf;
                continue;
            }
            body.setElse((Statement)currentIf);
        }
        if (body == null) {
            rule.setAction((Statement)this.helper.builder.nullStmt());
        } else {
            rule.setAction(body);
        }
        return rule;
    }

    @Override
    public void visitCondition(AEFDCondition condition) {
        this.conditionExp = null;
        condition.getBoolExp().accept(this);
    }

    @Override
    public void visitNot(AEFDBooleanExpression.Not not) {
        not.getExpression().accept(this);
        this.conditionExp = this.helper.builder.not(this.conditionExp);
    }

    @Override
    public void visitOr(AEFDBooleanExpression.Or or) {
        or.getLhs().accept(this);
        Exp lhs = this.conditionExp;
        or.getRhs().accept(this);
        Exp rhs = this.conditionExp;
        this.conditionExp = this.helper.builder.or(lhs, rhs);
    }

    @Override
    public void visitAnd(AEFDBooleanExpression.And and) {
        and.getLhs().accept(this);
        Exp lhs = this.conditionExp;
        and.getRhs().accept(this);
        Exp rhs = this.conditionExp;
        this.conditionExp = this.helper.builder.and(lhs, rhs);
    }

    @Override
    public void visitConstant(AEFDBooleanExpression.Constant constant) {
        this.conditionExp = this.helper.builder.literal(constant.getValue());
    }

    @Override
    public void visitVariableEvaluation(AEFDBooleanExpression.VariableEvaluation variableEvaluation) {
        Exp lhs = this.booleanVariablesArray.buildEvaluation(this.automate, variableEvaluation.getBooleanVariable());
        BinExp exp = new BinExp();
        exp.setLeft(lhs);
        exp.setRight((Exp)this.helper.builder.literal(variableEvaluation.getExpectedValue()));
        exp.setBinOp(BinOp.BEQ);
        this.conditionExp = exp;
    }

    @Override
    public void visitActionSequence(AEFDActionSequence actionSequence) {
        this.actionSeq = new Seq();
        this.informal = null;
        for (AEFDAction action : actionSequence.getActionList()) {
            action.accept(this);
        }
        this.actionSeq.addStatement((Statement)this.getToStmt(this.currentTransition.getPlaceTarget().intern(), this.informal));
    }

    @Override
    public void visitSendEvent(AEFDAction.SendEvent sendEvent) {
        ArgumentVariable target = this.lowPriorityQueue;
        if (sendEvent.getFunctionalEntity().getPrefix().equals((Object)AEFDPrefix.ACT)) {
            target = this.highPriorityQueue;
        }
        VarRef refTarget = new VarRef();
        refTarget.setDecl((Variable)target);
        ConstrExp eventExp = this.helper.events.getConstrExp(sendEvent.getFunctionalEntity());
        VarRef refLhs = new VarRef();
        refLhs.setDecl((Variable)target);
        this.actionSeq.addStatement(this.helper.builder.assign((Pattern)refLhs, this.helper.builder.enqueue((Exp)refTarget, (Exp)eventExp)));
    }

    @Override
    public void visitAffectation(AEFDAction.Affectation affectation) {
        this.actionSeq.addStatement(this.booleanVariablesArray.buildAffectation(this.automate, affectation.getVariable(), affectation.getNewValue()));
    }

    @Override
    public void visitProperty(AEFDAction.Property property) {
        this.informal = property.getName();
    }
}

