/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.toolbox.tools.analysis;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class GraphAsMapAnalysis<N> {
    private Map<N, Set<N>> fanout;

    public void setFanout(Map<N, Set<N>> fanoutMap) {
        this.fanout = fanoutMap;
        this.canonize();
    }

    public void canonize() {
        LinkedList<N> missingKeys = new LinkedList<N>();
        for (N source : this.fanout.keySet()) {
            for (N target : this.fanout.get(source)) {
                if (this.fanout.containsKey(target)) continue;
                missingKeys.add(target);
            }
        }
        for (Object missingKey : missingKeys) {
            HashSet targets = new HashSet();
            this.fanout.put(missingKey, targets);
        }
    }

    public Set<Set<N>> computeConnectedComponents() {
        HashSet<Set<N>> connectedComponents = new HashSet<Set<N>>();
        for (N source : this.fanout.keySet()) {
            HashSet<N> localComponent = new HashSet<N>();
            localComponent.add(source);
            localComponent.addAll((Collection)this.fanout.get(source));
            boolean hasBeenAdded = false;
            for (Set set : connectedComponents) {
                if (Collections.disjoint(set, localComponent)) continue;
                set.addAll(localComponent);
                hasBeenAdded = true;
                break;
            }
            if (hasBeenAdded) continue;
            connectedComponents.add(localComponent);
        }
        return connectedComponents;
    }

    public String exportAsTGFString(Function<N, String> labeler) {
        StringBuilder result = new StringBuilder();
        StringBuilder transitionsString = new StringBuilder();
        LinkedList<N> allNodes = new LinkedList<N>();
        allNodes.addAll(this.fanout.keySet());
        for (Object source : allNodes) {
            int sourceIndex = allNodes.indexOf(source);
            result.append(sourceIndex).append(" ").append(labeler.apply(source)).append("\n");
            for (N target : this.fanout.get(source)) {
                int targetIndex = allNodes.indexOf(target);
                transitionsString.append(sourceIndex).append(" ").append(targetIndex).append("\n");
            }
        }
        result.append("#\n").append(transitionsString.toString());
        return result.toString();
    }
}

