/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd.model;

import fr.ensta.aefd.model.AEFDModelObject;
import fr.ensta.aefd.model.AEFDModelVisitor;

public class AEFDBooleanVariable
implements AEFDModelObject {
    private static final String DEFAUT_TRUE = "true";
    private static final String DEFAUT_FALSE = "false";
    private final String name;
    private final boolean hasFunctionalEntities;
    private String[] stringValue = new String[2];

    public AEFDBooleanVariable(String name, boolean hasFunctionalEntities) {
        this.name = name;
        this.setStringValue(true, DEFAUT_TRUE);
        this.setStringValue(false, DEFAUT_FALSE);
        this.hasFunctionalEntities = hasFunctionalEntities;
    }

    public AEFDBooleanVariable(String name) {
        this(name, true);
    }

    public String getName() {
        return this.name;
    }

    public String getStringValue(boolean value) {
        if (value) {
            return this.stringValue[0];
        }
        return this.stringValue[1];
    }

    public void setStringValue(boolean value, String suffix) {
        if (value) {
            this.stringValue[0] = suffix;
        } else {
            this.stringValue[1] = suffix;
        }
    }

    public boolean getBooleanValue(String stringValue) {
        return this.stringValue[0].equalsIgnoreCase(stringValue);
    }

    public boolean hasFunctionalEntities() {
        return this.hasFunctionalEntities;
    }

    @Override
    public void accept(AEFDModelVisitor visitor) {
        visitor.visitVariable(this);
    }
}

