/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2.simulation;

import announce4j.Announcer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.VBox;
import plug.core.IRuntimeView;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.events.PropertyEvent;
import plug.explorer.BFSExplorer;
import plug.folding.runtime.PreinitializedRuntime;
import plug.simulation.trace_storage.TraceEntry;
import plug.simulation.trace_storage.TraceStore;
import plug.statespace.SimpleStateSpaceManager;
import plug.ui2.simulation.configuration.ConfigurationTreeView;
import plug.ui2.simulation.configuration.ConfigurationTreeViewTitledPane;
import plug.ui2.simulation.expression_watcher.ExpressionWatcherTitledPane;
import plug.ui2.simulation.fireables.FireableTransitionsView;
import plug.ui2.simulation.trace.BranchingTraceView;
import plug.utils.graph.IGraph;
import plug.utils.graph.algorithms.DijkstraShortestPath;
import plug.verifiers.deadlock.DeadlockVerifier;
import plug.verifiers.deadlock.FinalStateDetected;

public class SimulationView<C, T>
extends SplitPane {
    ObjectProperty<ITransitionRelation<C, T>> transitionRelationProperty;
    ObjectProperty<IRuntimeView<C, T>> runtimeViewProperty;
    ObjectProperty<C> theCurrentConfiguration = new SimpleObjectProperty();
    BranchingTraceView<C, T> branchingTraceView;

    public SimulationView(ObjectProperty<ITransitionRelation<C, T>> transitionRelation, ObjectProperty<IRuntimeView<C, T>> runtimeView, ObjectProperty<Set<C>> initialSet) {
        this(transitionRelation, runtimeView, initialSet, (ObjectProperty<TraceStore<C, Object>>)new SimpleObjectProperty());
    }

    public SimulationView(ObjectProperty<ITransitionRelation<C, T>> transitionRelationProperty, ObjectProperty<IRuntimeView<C, T>> runtimeViewProperty, ObjectProperty<Set<C>> initialSet, ObjectProperty<TraceStore<C, Object>> inoutTraceStoreProperty) {
        this.transitionRelationProperty = transitionRelationProperty;
        this.runtimeViewProperty = runtimeViewProperty;
        SimpleObjectProperty theFiredTransition = new SimpleObjectProperty();
        FireableTransitionsView<C, T> fireableTransitionsView = new FireableTransitionsView<C, T>(this.theCurrentConfiguration, transitionRelationProperty, runtimeViewProperty, theFiredTransition);
        ConfigurationTreeViewTitledPane<C, T> configurationTitledPane = new ConfigurationTreeViewTitledPane<C, T>(this.theCurrentConfiguration, runtimeViewProperty);
        configurationTitledPane.addToolbarAction("gmi-keyboard-tab:18:#2ecc71", Bindings.createStringBinding(() -> "Find deadlock", (Observable[])new Observable[0]), this::deadlockFinder);
        ExpressionWatcherTitledPane<C, T> watchTitledPane = new ExpressionWatcherTitledPane<C, T>(this.theCurrentConfiguration, transitionRelationProperty, this::addCounterExample);
        VBox accordion = new VBox(new Node[]{watchTitledPane, configurationTitledPane});
        ScrollPane accordionScrollPane = new ScrollPane((Node)accordion);
        accordionScrollPane.setFitToWidth(true);
        SplitPane topPane = new SplitPane(new Node[]{fireableTransitionsView, accordionScrollPane});
        this.branchingTraceView = new BranchingTraceView<C, T>(transitionRelationProperty, runtimeViewProperty, theFiredTransition, this.theCurrentConfiguration, inoutTraceStoreProperty, this::configurationViewBuilder);
        this.getItems().addAll((Object[])new Node[]{topPane, this.branchingTraceView});
        this.setOrientation(Orientation.VERTICAL);
        this.setDividerPosition(0, 0.3);
        Set<C> initialConfigurations = this.getInitialConfigurations((Set)initialSet.get(), (ITransitionRelation)transitionRelationProperty.get());
        this.branchingTraceView.setInitialConfigurations(initialConfigurations);
        initialSet.addListener((v, o, n) -> {
            Set<C> initials = this.getInitialConfigurations((Set)initialSet.get(), (ITransitionRelation)transitionRelationProperty.get());
            this.branchingTraceView.setInitialConfigurations(initials);
        });
    }

    Node configurationViewBuilder(TraceEntry<C, T> entry) {
        SimpleObjectProperty theCurrentConfiguration = new SimpleObjectProperty();
        ConfigurationTreeView<C, T> view = new ConfigurationTreeView<C, T>(theCurrentConfiguration, this.runtimeViewProperty, true, true);
        view.addContextMenuAction("gmi-keyboard-tab:18:#2ecc71", Bindings.createStringBinding(() -> "Find deadlock", (Observable[])new Observable[0]), this::deadlockFinder);
        if (entry.getParentConfiguration() != null) {
            theCurrentConfiguration.set(entry.getParentConfiguration());
        }
        theCurrentConfiguration.set(entry.getConfiguration());
        return view;
    }

    void deadlockFinder(Event event) {
        PreinitializedRuntime preinitializedRuntime = new PreinitializedRuntime((ITransitionRelation)this.transitionRelationProperty.get(), Collections.singleton(this.theCurrentConfiguration.get()));
        SimpleStateSpaceManager stateSpaceManager = new SimpleStateSpaceManager();
        stateSpaceManager.parentTransitionStorage();
        BFSExplorer deadlockVerifier = DeadlockVerifier.bfs((ITransitionRelation)preinitializedRuntime, (IStateSpaceManager)stateSpaceManager);
        deadlockVerifier.getAnnouncer().when(FinalStateDetected.class, (arg_0, arg_1) -> this.lambda$deadlockFinder$3((IStateSpaceManager)stateSpaceManager, arg_0, arg_1));
        deadlockVerifier.getAnnouncer().when(PropertyEvent.class, (ann, e) -> {
            if (e.isVerified()) {
                Alert alert = new Alert(Alert.AlertType.INFORMATION, "No deadlock found", new ButtonType[0]);
                alert.setTitle("Congratulations");
                alert.setHeaderText(null);
                alert.showAndWait();
            }
        });
        deadlockVerifier.execute();
    }

    void deadlockFoundCallback(FinalStateDetected event, IStateSpaceManager stateSpaceManager, Consumer<List<C>> counterExampleHandler) {
        List counterExample = new DijkstraShortestPath().getShortestPath((IGraph)stateSpaceManager.getGraphView(), (Collection)stateSpaceManager.initialConfigurations(), (Object)event.getFinalState());
        counterExampleHandler.accept(counterExample);
    }

    Set<C> getInitialConfigurations(Set<C> initialSet, ITransitionRelation<C, T> transitionRelation) {
        if (transitionRelation == null) {
            return Collections.emptySet();
        }
        if (initialSet == null) {
            initialSet = transitionRelation.initialConfigurations();
        }
        return initialSet;
    }

    public void addCounterExample(List<C> counterExample) {
        this.branchingTraceView.setCounterExample(counterExample);
    }

    private /* synthetic */ void lambda$deadlockFinder$3(IStateSpaceManager stateSpaceManager, Announcer ann, FinalStateDetected e) {
        this.deadlockFoundCallback(e, stateSpaceManager, this::addCounterExample);
    }
}

