/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.automaton;

import java.util.Collections;
import java.util.Iterator;
import spinja.promela.compiler.actions.Action;
import spinja.promela.compiler.actions.ActionContainer;
import spinja.promela.compiler.actions.ChannelSendAction;
import spinja.promela.compiler.automaton.State;
import spinja.promela.compiler.parser.ParseException;
import spinja.util.StringWriter;

public abstract class Transition
implements Iterable<Action>,
ActionContainer {
    private State from;
    private State to;
    private final int transId;

    public Transition(State state, State state2) {
        if (state == null) {
            throw new IllegalArgumentException("A transition must always come from somewhere!");
        }
        if (state2 != null && state.getAutomaton() != state2.getAutomaton()) {
            throw new IllegalArgumentException("Both States must be part of the same Automaton!");
        }
        this.from = state;
        state.addOut(this);
        this.to = state2;
        if (state2 != null) {
            state2.addIn(this);
        }
        this.transId = TransitionIdCounter.nextId();
    }

    @Override
    public void addAction(Action action) {
        throw new IllegalArgumentException("Please do not add actions to a transition that doesn't support actions");
    }

    public Action getAction(int n) {
        throw new IndexOutOfBoundsException();
    }

    public final void changeFrom(State state) {
        this.from.removeOut(this);
        this.from = state;
        this.from.addOut(this);
    }

    public final void changeFrom(State state, Transition transition) {
        this.from.removeOut(this);
        this.from = state;
        this.from.addOut(this, transition);
    }

    public final void changeTo(State state) {
        State state2 = this.to;
        this.to = state;
        if (this.to != null) {
            state.addIn(this);
        }
        if (state2 != null) {
            state2.removeIn(this);
        }
    }

    public final void delete() {
        this.from.removeOut(this);
        this.from = null;
        if (this.to != null) {
            this.to.removeIn(this);
            this.to = null;
        }
    }

    public boolean hasChannelSendAction() {
        for (int i = 0; i < this.getActionCount(); ++i) {
            Action action = this.getAction(i);
            if (!(action instanceof ChannelSendAction)) continue;
            return true;
        }
        return false;
    }

    void setTo(State state) {
        this.to = state;
    }

    void setFrom(State state) {
        this.from = state;
    }

    public abstract Transition duplicate();

    public int getActionCount() {
        return 0;
    }

    public int getBackupSize() {
        return 0;
    }

    public State getFrom() {
        return this.from;
    }

    public abstract String getText();

    public State getTo() {
        return this.to;
    }

    public int getTransId() {
        return this.transId;
    }

    public boolean isLocal() {
        return false;
    }

    public final boolean takesAtomicToken() {
        return this.getTo() != null && this.getTo().isInAtomic();
    }

    public boolean isUseless() {
        return false;
    }

    @Override
    public Iterator<Action> iterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void printTransition(StringWriter stringWriter) throws ParseException {
        stringWriter.appendLine("new PromelaTransitionFactory(", this.isLocal(), ", ", this.transId, ", ", this.from.getStateId(), ", ", this.to.getStateId(), ", \"", this.getText(), "\") {").indent();
        if (this.getActionCount() > 0) {
            this.getAction(0).printEnabledFunction(stringWriter);
            this.getAction(0).printExtraFunctions(stringWriter);
        }
        stringWriter.appendLine("public final PromelaTransition newTransition() {").indent();
        if (this.from.getAutomaton().getProctype().getSpecification().usesAtomic()) {
            stringWriter.appendLine("return new AtomicTransition(", this.takesAtomicToken(), ") {").indent();
        } else {
            stringWriter.appendLine("return new NonAtomicTransition() {").indent();
        }
        int n = stringWriter.length() - 2 - stringWriter.getPostfix().length();
        if (!this.printTransitionImpl(stringWriter)) {
            stringWriter.setLength(n);
            stringWriter.outdent().append(";").appendPostfix();
        } else {
            stringWriter.removePostfix().outdent().appendLine("};");
        }
        stringWriter.outdent().appendLine("}");
        stringWriter.outdent().appendLine("}");
    }

    public boolean printTransitionImpl(StringWriter stringWriter) throws ParseException {
        return false;
    }

    public final String toString() {
        return new StringWriter().appendIf(this.takesAtomicToken(), "Atomic ").append(this.getClass().getSimpleName()).append(" from ").append(this.from == null ? "nowhere" : Integer.valueOf(this.from.getStateId())).append(" to ").append(this.to == null ? "nowhere" : Integer.valueOf(this.to.getStateId())).append(" ").append(this.getText()).toString();
    }

    public boolean isAlwaysEnabled() {
        return false;
    }

    private static class TransitionIdCounter {
        private static int id = 0;

        private TransitionIdCounter() {
        }

        private static synchronized int nextId() {
            return id++;
        }
    }
}

