/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.sexp.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.xid.basics.sexp.model.Referencer;

public abstract class ModelToXML {
    private final Referencer referencer;
    private final Document document;
    private final ContextNode contextRoot;
    private ContextNode contextCurrent;

    public ModelToXML(Referencer referencer, Document document) {
        this.contextCurrent = this.contextRoot = new ContextNode(null);
        this.referencer = referencer;
        this.document = document;
        this.registerBuiltins();
    }

    private void registerBuiltins() {
        for (Map.Entry<String, Object> entry : this.referencer.builtins().entrySet()) {
            this.register(entry.getKey(), entry.getValue());
        }
    }

    private void register(String reference, Object object) {
        this.contextCurrent.objectIndex.put(object, reference);
        this.contextCurrent.existingReference.add(reference);
    }

    private String resolve(Object referenced) {
        ContextNode iterator = this.contextCurrent;
        while (iterator != null) {
            LinkedHashMap<Object, String> current = iterator.objectIndex;
            String reference = current.get(referenced);
            if (reference != null) {
                return reference;
            }
            iterator = iterator.parent;
        }
        return null;
    }

    private void pushReferenceContext() {
        ContextNode contextNew;
        this.contextCurrent = contextNew = new ContextNode(this.contextCurrent);
    }

    private void popReferenceContext() {
        this.contextCurrent = this.contextCurrent.parent;
    }

    private String uniqueReference(String reference) {
        HashSet<String> current = this.contextCurrent.existingReference;
        while (current.contains(reference)) {
            reference = reference + "_";
        }
        return reference;
    }

    public void push(Object object) {
        String reference = this.referencer.referenceFor(object);
        reference = this.uniqueReference(reference);
        this.register(reference, object);
        ArrayList<Attr> toResolveList = new ArrayList<Attr>();
        this.contextCurrent.collectPendingReferencesFor(object, toResolveList);
        for (Attr atom : toResolveList) {
            atom.setValue(reference);
        }
        if (this.referencer.pushContext(object)) {
            this.pushReferenceContext();
        }
    }

    public void pop(Object object) {
        if (this.referencer.popContext(object)) {
            this.popReferenceContext();
        }
    }

    public Attr createReference(Object referenced) {
        throw new UnsupportedOperationException("References in XML aren't supported yet.");
    }

    public Set<Object> missingObjects() {
        return this.contextRoot.missingObjects();
    }

    private class ContextNode {
        final LinkedHashMap<Object, String> objectIndex = new LinkedHashMap();
        final HashSet<String> existingReference = new HashSet();
        final LinkedHashMap<Object, List<Attr>> pendingReferenceMap = new LinkedHashMap();
        final ContextNode parent;
        ArrayList<ContextNode> children;

        ContextNode(ContextNode parent) {
            this.parent = parent;
            if (parent != null) {
                parent.addChild(this);
            }
        }

        void addChild(ContextNode child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }

        void registerPendingReference(Object referenced, Attr atom) {
            List<Attr> toResolveList = this.pendingReferenceMap.get(referenced);
            if (toResolveList == null) {
                toResolveList = new ArrayList<Attr>();
                this.pendingReferenceMap.put(referenced, toResolveList);
            }
            toResolveList.add(atom);
        }

        void collectPendingReferencesFor(Object object, List<Attr> result) {
            List<Attr> pendings = this.pendingReferenceMap.get(object);
            if (pendings != null) {
                result.addAll(pendings);
                this.pendingReferenceMap.remove(object);
            }
            if (this.children != null) {
                for (ContextNode child : this.children) {
                    child.collectPendingReferencesFor(object, result);
                }
            }
        }

        Set<Object> missingObjects() {
            HashSet<Object> missing = new HashSet<Object>(this.pendingReferenceMap.keySet());
            if (this.children != null) {
                for (ContextNode child : this.children) {
                    missing.addAll(child.missingObjects());
                }
            }
            return missing;
        }
    }
}

