/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.generation.c;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.generation.Merger;
import org.xid.basics.generation.c.C;
import org.xid.basics.generation.c.CContentHandler;

public class CContentWriter
implements CContentHandler {
    private final String NL = System.getProperty("line.separator");
    private String charSet = "UTF-8";
    private ErrorHandler errorHandler = ErrorHandler.simple;
    private File currentFolder;
    private StringBuilder currentFileContent;
    private final Stack<Type> context = new Stack();
    private String appendPrefix = null;
    private Merger merger;

    public CContentWriter(File outputFolder) {
        if (outputFolder == null) {
            throw new NullPointerException("Output folder can't be null");
        }
        this.currentFolder = outputFolder;
    }

    public Merger getMerger() {
        return this.merger == null ? Merger.DEFAULT : this.merger;
    }

    public void setMerger(Merger merger) {
        this.merger = merger;
    }

    @Override
    public void beginDirectory(String name) {
        this.currentFolder = new File(this.currentFolder, name);
        if (!this.currentFolder.exists()) {
            this.currentFolder.mkdir();
        }
    }

    @Override
    public void endDirectory(String name) {
        this.currentFolder = this.currentFolder.getParentFile();
    }

    @Override
    public void beginFile(String name) {
        this.currentFileContent = new StringBuilder();
    }

    @Override
    public void endFile(String name) {
        try {
            this.getMerger().merge(new File(this.currentFolder, name), this.currentFileContent.toString(), this.charSet);
        }
        catch (Exception e) {
            this.errorHandler.handleError(2, e.getClass().getName() + ": " + e.getMessage());
            return;
        }
    }

    @Override
    public void functionDeclaration(int flags, String returnType, String name, C.Parameter ... parameters) {
        this.appendToFile(C.printFlags(flags));
        if (returnType != null) {
            this.appendToFile(returnType);
            this.appendToFile(" ");
        }
        this.appendToFile(name);
        this.appendToFile("(");
        for (int i = 0; i < parameters.length; ++i) {
            C.Parameter parameter = parameters[i];
            this.appendToFile(C.printFlags(parameter.flags));
            this.appendToFile(parameter.type);
            this.appendToFile(" ");
            this.appendToFile(parameter.name);
            if (i + 1 >= parameters.length) continue;
            this.appendToFile(", ");
        }
        this.appendToFile(")");
        this.appendToFile(";");
    }

    @Override
    public void beginFunction(int flags, String returnType, String name, C.Parameter ... parameters) {
        this.appendToFile(C.printFlags(flags));
        if (returnType != null) {
            this.appendToFile(returnType);
            this.appendToFile(" ");
        }
        this.appendToFile(name);
        this.appendToFile("(");
        for (int i = 0; i < parameters.length; ++i) {
            C.Parameter parameter = parameters[i];
            this.appendToFile(C.printFlags(parameter.flags));
            this.appendToFile(parameter.type);
            this.appendToFile(" ");
            this.appendToFile(parameter.name);
            if (i + 1 >= parameters.length) continue;
            this.appendToFile(", ");
        }
        this.appendToFile(")");
        this.appendToFile(" {");
        this.pushContext(Type.FUNCTION);
    }

    @Override
    public void endFunction(String name) {
        this.popContext(Type.FUNCTION);
        this.appendToFile("}");
    }

    @Override
    public void codeln(int level, String code) {
        this.appendToFile(code);
    }

    @Override
    public void code(String code) {
        this.appendToFile(code);
    }

    @Override
    public void comment(int type, int level, String comment) {
        switch (type) {
            case 1: {
                this.appendToFile("//");
                this.appendToFile(comment);
                this.appendToFile(this.NL);
                break;
            }
            case 2: {
                this.appendToFile("/*");
                this.appendToFile(comment);
                this.appendToFile("*/");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(InputStream stream, String filename) {
        File destinationFile = new File(this.currentFolder, filename);
        destinationFile.getParentFile().mkdirs();
        try {
            BufferedInputStream inputStream = new BufferedInputStream(stream);
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            try {
                byte[] buf = new byte[2048];
                int i = 0;
                while ((i = ((InputStream)inputStream).read(buf)) != -1) {
                    ((OutputStream)outputStream).write(buf, 0, i);
                }
            }
            finally {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
        }
        catch (IOException e) {
            this.errorHandler.handleError(2, e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private void pushContext(Type type) {
        this.context.push(type);
    }

    private void popContext(Type expected) {
        Type current;
        if (this.context.isEmpty()) {
            this.errorHandler.handleError(2, "Closing a not openned " + (Object)((Object)expected) + ".");
        }
        if (expected != (current = this.context.pop())) {
            this.errorHandler.handleError(2, "Closing a " + (Object)((Object)current) + " while expecting a " + (Object)((Object)expected) + ".");
        }
    }

    private void appendToFile(String text) {
        if (this.appendPrefix != null) {
            this.currentFileContent.append(this.appendPrefix);
            this.appendPrefix = null;
        }
        this.currentFileContent.append(text);
    }

    private static enum Type {
        FUNCTION;

    }
}

