/*
 * Decompiled with CFR 0.152.
 */
package plug.explorer;

import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.Function;
import plug.core.IConfiguration;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.core.execution.IExecutionController;
import plug.events.CloseConfigurationEvent;
import plug.explorer.AbstractExplorer;
import plug.statespace.PastFreezeStateSpaceManager;

public class PastFreezeExplorer<C extends IConfiguration, A>
extends AbstractExplorer<C, A> {
    protected final Function<C, Integer> clusterIndexGetter;
    protected final Queue<C> toSee = new PriorityQueue<C>(50, this::compareConfigurations);
    protected int currentClusterID = 0;
    protected int zappedConfigurations = 0;

    public PastFreezeExplorer(ITransitionRelation<C, ?> runtime, IStateSpaceManager<C, A> stateSpaceManager, Function<C, Integer> clusterIndexGetter) {
        super(runtime, stateSpaceManager);
        this.clusterIndexGetter = clusterIndexGetter;
    }

    boolean atEnd() {
        return this.toSee.isEmpty();
    }

    C nextConfiguration() {
        return (C)((IConfiguration)this.toSee.remove());
    }

    void schedule(C conf) {
        this.toSee.add(conf);
    }

    void explorationStep() {
        C source = this.nextConfiguration();
        int clusterID = this.clusterIndexGetter.apply(source);
        if (this.currentClusterID != clusterID) {
            this.zappedConfigurations = (int)((long)this.zappedConfigurations + ((PastFreezeStateSpaceManager)this.stateSpaceManager).size(this.currentClusterID));
            ((PastFreezeStateSpaceManager)this.stateSpaceManager).clear(this.currentClusterID);
            this.currentClusterID = clusterID;
        }
        this.fire((IConfiguration)source);
        this.announcer.announce((Object)new CloseConfigurationEvent((IExecutionController)this, source));
    }

    int compareConfigurations(C o1, C o2) {
        return this.clusterIndexGetter.apply(o1) - this.clusterIndexGetter.apply(o2);
    }
}

