/*
 * Decompiled with CFR 0.152.
 */
package tuml.interpreter;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class Environment {
    public final boolean outputPlantUML = false;
    public final boolean outputPlantUMLStates;
    private final Resource r;
    private final List<Signal> signalsCache;
    private final Map<Signal, Integer> signal2idCache;

    public List<Signal> signals() {
        boolean _equals;
        List<Signal> _xblockexpression = null;
        int _size = this.signalsCache.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            TreeIterator _allContents = this.r.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, Signal.class);
            List _list = IteratorExtensions.toList((Iterator)_filter);
            this.signalsCache.addAll(_list);
        }
        _xblockexpression = this.signalsCache;
        return _xblockexpression;
    }

    public Signal getSignal(final String name) {
        List<Signal> _signals = this.signals();
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal s) {
                String _name = s.getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        return (Signal)IterableExtensions.findFirst(_signals, (Functions.Function1)_function);
    }

    public Map<Signal, Integer> signal2id() {
        boolean _equals;
        Map<Signal, Integer> _xblockexpression = null;
        int _size = this.signal2idCache.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            List<Signal> _signals = this.signals();
            Iterable _indexed = IterableExtensions.indexed(_signals);
            HashMap _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            Functions.Function2<HashMap<Signal, Integer>, Pair<Integer, Signal>, HashMap<Signal, Integer>> _function = new Functions.Function2<HashMap<Signal, Integer>, Pair<Integer, Signal>, HashMap<Signal, Integer>>(){

                public HashMap<Signal, Integer> apply(HashMap<Signal, Integer> map, Pair<Integer, Signal> pair) {
                    HashMap<Signal, Integer> _xblockexpression = null;
                    Signal _value = (Signal)pair.getValue();
                    Integer _key = (Integer)pair.getKey();
                    map.put(_value, _key);
                    _xblockexpression = map;
                    return _xblockexpression;
                }
            };
            HashMap _fold = (HashMap)IterableExtensions.fold((Iterable)_indexed, (Object)_newHashMap, (Functions.Function2)_function);
            this.signal2idCache.putAll(_fold);
        }
        _xblockexpression = this.signal2idCache;
        return _xblockexpression;
    }

    public Environment(Resource r) {
        this.outputPlantUMLStates = this.outputPlantUML = false;
        this.signalsCache = new ArrayList<Signal>();
        this.signal2idCache = new HashMap<Signal, Integer>();
        this.r = r;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        this.getClass();
        result = 31 * result + 1237;
        result = 31 * result + (this.outputPlantUMLStates ? 1231 : 1237);
        result = 31 * result + (this.r == null ? 0 : this.r.hashCode());
        result = 31 * result + (this.signalsCache == null ? 0 : this.signalsCache.hashCode());
        result = 31 * result + (this.signal2idCache == null ? 0 : this.signal2idCache.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Environment other = (Environment)obj;
        if (other.outputPlantUML != this.outputPlantUML) {
            return false;
        }
        if (other.outputPlantUMLStates != this.outputPlantUMLStates) {
            return false;
        }
        if (this.r == null ? other.r != null : !this.r.equals(other.r)) {
            return false;
        }
        if (this.signalsCache == null ? other.signalsCache != null : !this.signalsCache.equals(other.signalsCache)) {
            return false;
        }
        return !(this.signal2idCache == null ? other.signal2idCache != null : !this.signal2idCache.equals(other.signal2idCache));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("outputPlantUML", (Object)this.outputPlantUML);
        b.add("outputPlantUMLStates", (Object)this.outputPlantUMLStates);
        b.add("r", (Object)this.r);
        b.add("signalsCache", this.signalsCache);
        b.add("signal2idCache", this.signal2idCache);
        return b.toString();
    }

    @Pure
    public boolean getOutputPlantUML() {
        return this.outputPlantUML;
    }

    @Pure
    public boolean getOutputPlantUMLStates() {
        return this.outputPlantUMLStates;
    }

    @Pure
    public Resource getR() {
        return this.r;
    }

    @Pure
    public List<Signal> getSignalsCache() {
        return this.signalsCache;
    }

    @Pure
    public Map<Signal, Integer> getSignal2idCache() {
        return this.signal2idCache;
    }
}

