/*
 * Decompiled with CFR 0.152.
 */
package spinja.store;

import spinja.store.StateStore;
import spinja.store.hash.HashAlgorithm;
import spinja.store.hash.JenkinsHash;

public class BitstateHashStore
extends StateStore {
    private final long[] table;
    private final int mask;
    private int stored;
    private final int fold;
    private final HashAlgorithm hash;
    private final int[] indices;
    private final long[] keys;

    public BitstateHashStore(int n, int n2) {
        this(n, n2, new JenkinsHash());
    }

    public BitstateHashStore(int n, int n2, HashAlgorithm hashAlgorithm) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Fold should be at least 1");
        }
        if (n > 37) {
            throw new IllegalArgumentException("The size can not be larger than 2^37 bits");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("The size must be a positive number");
        }
        this.table = new long[1 << Math.max(1, n - 6)];
        System.out.println("Size of bitstate table: " + this.table.length);
        this.mask = this.table.length - 1;
        this.stored = 0;
        this.fold = n2;
        this.indices = new int[n2];
        this.keys = new long[n2];
        this.hash = hashAlgorithm;
    }

    @Override
    public int addState(byte[] byArray) {
        int n;
        Object object;
        int n2 = 0;
        if (this.table.length > 0x4000000) {
            object = this.hash.bitstateHash(byArray);
            for (n = 0; n < this.fold; ++n) {
                long l = object.nextHash();
                if (n2 == 0) {
                    n2 = (int)l & Integer.MAX_VALUE;
                }
                this.indices[n] = (int)(l >>> 6) & this.mask;
                this.keys[n] = 1L << (int)l;
            }
        } else {
            object = this.hash.hash(byArray);
            for (n = 0; n < this.fold; ++n) {
                int n3 = object.nextHash();
                if (n2 == 0) {
                    n2 = n3 & Integer.MAX_VALUE;
                }
                this.indices[n] = n3 >>> 6 & this.mask;
                this.keys[n] = 1L << n3;
            }
        }
        boolean bl = true;
        for (n = 0; n < this.fold; ++n) {
            if ((this.table[this.indices[n]] & this.keys[n]) != 0L) continue;
            bl = false;
            break;
        }
        if (bl) {
            return -n2 - 1;
        }
        for (n = 0; n < this.fold; ++n) {
            int n4 = this.indices[n];
            this.table[n4] = this.table[n4] | this.keys[n];
        }
        ++this.stored;
        return n2;
    }

    @Override
    public long getBytes() {
        return 24 + this.table.length * 8;
    }

    @Override
    public int getStored() {
        return this.stored;
    }

    @Override
    public void printSummary() {
        System.out.printf("hash factor: %.4f%n", (double)this.table.length * 64.0 / (double)this.stored);
        System.out.printf("bits set per state: %d (-k%<d)%n", this.fold);
    }
}

