/*
 * Decompiled with CFR 0.152.
 */
package spinja.search;

import java.io.PrintStream;
import spinja.exceptions.ValidationException;
import spinja.model.Model;
import spinja.model.ObservableModel;
import spinja.model.Transition;
import spinja.model.listener.PrintEvent;
import spinja.model.listener.PrintListener;
import spinja.search.Algoritm;
import spinja.search.TransitionCalculator;

public abstract class Simulation<M extends Model<T>, T extends Transition>
extends Algoritm {
    protected final M model;
    protected final TransitionCalculator<M, T> nextTransition;
    private PrintStream out;
    private long states;

    public Simulation(M m, TransitionCalculator<M, T> transitionCalculator) {
        this.model = m;
        this.nextTransition = transitionCalculator;
        ((ObservableModel)m).addPrintListener(new PrintListener(){

            @Override
            public void print(PrintEvent printEvent) {
                Simulation.this.out.println(printEvent.getMsg());
            }
        });
        this.out = System.out;
        this.states = 0L;
    }

    @Override
    public final void execute() {
        while (true) {
            System.out.println(((Model)this.model).toString());
            try {
                T t = this.nextTransition();
                if (t == null) break;
                this.out.println("Taking transition: " + t.toString());
                ((Transition)t).take();
                ++this.states;
            }
            catch (ValidationException validationException) {
                this.out.println(validationException.getMessage());
            }
        }
    }

    @Override
    public void freeMemory() {
    }

    @Override
    public long getBytes() {
        return 0L;
    }

    @Override
    public long getNrStates() {
        return this.states;
    }

    public abstract T nextTransition();

    @Override
    public void printSummary() {
        this.out.println("Simulation finished");
    }

    protected void setOutputStream(PrintStream printStream) {
        this.out = printStream;
    }
}

