/*
 * Decompiled with CFR 0.152.
 */
package spinja.options;

import java.util.Map;
import java.util.TreeMap;
import spinja.options.Option;
import spinja.util.StringWriter;

public class MultiStringOption
extends Option {
    private final Map<String, String> strings = new TreeMap<String, String>();
    private final Map<String, Boolean> set = new TreeMap<String, Boolean>();

    public MultiStringOption(char c, String string, String[] stringArray, String[] stringArray2) {
        super(c, string);
        for (int i = 0; i < stringArray.length; ++i) {
            this.strings.put(stringArray[i], stringArray2[i]);
            this.set.put(stringArray[i], false);
        }
    }

    @Override
    public boolean isSet() {
        return false;
    }

    public boolean isSet(String string) {
        return this.set.get(string);
    }

    @Override
    public void parseOption(String string) {
        if (!this.set.containsKey(string)) {
            System.out.println("Warning: -" + this.getChar() + string + " not found as an option");
            return;
        }
        this.set.put(string, true);
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        for (String string : this.strings.keySet()) {
            StringWriter stringWriter2 = new StringWriter();
            if (stringWriter.length() > 0) {
                stringWriter.append("\n");
            }
            stringWriter2.append("   -");
            stringWriter2.append(Character.valueOf(this.getChar()));
            stringWriter2.append(string);
            while (stringWriter2.length() < 24) {
                stringWriter2.append(Character.valueOf(' '));
            }
            stringWriter2.append(this.indentedDescription(0, this.strings.get(string)));
            stringWriter.append(stringWriter2);
        }
        return stringWriter.toString();
    }
}

