/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.explorer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import obp.explorer.ConfsFileHandler;
import obp.explorer.runtime.Configuration;
import obp.ui.explorer.SearchConfigurationsAction;
import obp.ui.explorer.ShowGraphAction;
import obp.ui.explorer.ShowTraceAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.controller.Controller;
import org.xid.basics.ui.field.BorderField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.ListField;
import org.xid.basics.ui.field.TextField;

public class ConfsFileHandlerController
extends Controller<ConfsFileHandler> {
    private final ErrorHandler errorHandler;
    private TextField selectedConfField;
    private TextField confField;
    private ListField<obp.explorer.runtime.obs.Action> actionsField;
    private CompositeField compositeField;

    public ConfsFileHandlerController(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public CompositeField createFields() {
        this.selectedConfField = new TextField("Configuration", 8192);
        this.selectedConfField.setIntValue(0);
        this.selectedConfField.addAction((Action)new SearchConfigurationsAction(this));
        this.selectedConfField.addAction((Action)new ShowTraceAction(this));
        this.selectedConfField.addAction((Action)new ShowGraphAction(this));
        final ConfsFileHandlerController parent = this;
        Action.Stub matrixMarketExport = new Action.Stub("Matrix Market"){

            public int getVisibility() {
                if (parent.getSubject() == null) {
                    return 2;
                }
                return 1;
            }

            public int run(ActionMonitor monitor) {
                final ConfsFileHandler confs = (ConfsFileHandler)parent.getSubject();
                if (confs == null) {
                    return 3;
                }
                Thread loader = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        FileDialog dialog = new FileDialog(new Shell(Display.getDefault()), 8192);
                        dialog.setFilterNames(new String[]{"MatrixMarket Files", "All Files (*)"});
                        dialog.setFilterExtensions(new String[]{"*.mtx", "*.*"});
                        String fileName = dialog.open();
                        if (fileName == null) {
                            return;
                        }
                        confs.readAll();
                        try {
                            BufferedWriter br = new BufferedWriter(new FileWriter(new File(fileName)));
                            br.write("%%MatrixMarket matrix coordinate pattern general\n");
                            br.write(confs.getConfigurationCount() + " " + confs.getConfigurationCount() + " " + confs.getActionCount() + "\n");
                            for (int i = 0; i < confs.getConfigurationCount(); ++i) {
                                List<obp.explorer.runtime.obs.Action> actions2 = confs.getActionsFrom(i);
                                for (obp.explorer.runtime.obs.Action act : actions2) {
                                    br.write(i + 1 + " " + (act.targetId + 1) + "\n");
                                }
                            }
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                loader.run();
                return 1;
            }
        };
        this.selectedConfField.addAction((Action)matrixMarketExport);
        this.confField = new TextField(null, 3);
        this.confField.setNbLines(5);
        this.actionsField = new ListField<obp.explorer.runtime.obs.Action>(null, 2){

            public String getText(obp.explorer.runtime.obs.Action element) {
                if (ConfsFileHandlerController.this.getSubject() != null) {
                    return "To " + element.targetId + ": " + ((ConfsFileHandler)ConfsFileHandlerController.this.getSubject()).actionToString(element);
                }
                return "To " + element.targetId + ": " + element;
            }
        };
        int style = 90;
        this.actionsField.addAction((Action)new Action.Stub("<<"){

            public int getVisibility() {
                return ConfsFileHandlerController.this.selectedConfField.getIntValue() > 0 ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                int id = ConfsFileHandlerController.this.selectedConfField.getIntValue();
                int predecessor = ((ConfsFileHandler)ConfsFileHandlerController.this.getSubject()).getFarthestPredecessor(id);
                ConfsFileHandlerController.this.selectedConfField.setIntValue(predecessor);
                ConfsFileHandlerController.this.refreshFields();
                return 1;
            }
        });
        this.actionsField.addAction((Action)new Action.Stub("<"){

            public int getVisibility() {
                return ConfsFileHandlerController.this.selectedConfField.getIntValue() > 0 ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                int id = ConfsFileHandlerController.this.selectedConfField.getIntValue();
                int predecessor = ((ConfsFileHandler)ConfsFileHandlerController.this.getSubject()).getClosestPredecessor(id);
                ConfsFileHandlerController.this.selectedConfField.setIntValue(predecessor);
                ConfsFileHandlerController.this.refreshFields();
                return 1;
            }
        });
        this.actionsField.addAction((Action)new Action.Stub(">", style){

            public int getVisibility() {
                return ConfsFileHandlerController.this.actionsField.getSingleSelection() == null ? 2 : 1;
            }

            public int run(ActionMonitor monitor) {
                ConfsFileHandlerController.this.selectedConfField.setIntValue(((obp.explorer.runtime.obs.Action)((ConfsFileHandlerController)ConfsFileHandlerController.this).actionsField.getSingleSelection()).targetId);
                ConfsFileHandlerController.this.refreshFields();
                return 1;
            }
        });
        CompositeField configurationCompositeField = new CompositeField("Configuration", 16, new Field[]{this.selectedConfField, this.confField});
        BorderField configurationAndActionsField = new BorderField(0, (Field)configurationCompositeField);
        configurationAndActionsField.setSouth(this.actionsField, 30);
        this.compositeField = new CompositeField("Configurations", 0, new Field[]{configurationAndActionsField});
        return this.compositeField;
    }

    public void refreshFields() {
        if (this.getSubject() == null) {
            this.confField.setValue(null);
            this.compositeField.setEnable(false);
        } else {
            int selectedId = this.selectedConfField.getIntValue();
            Configuration selectedConfiguration = ((ConfsFileHandler)this.getSubject()).getConfiguration(selectedId);
            this.confField.setValue(selectedConfiguration == null ? "No configuration with id " + selectedId : ((ConfsFileHandler)this.getSubject()).configurationToString(selectedConfiguration));
            this.confField.refreshButtonBar();
            this.actionsField.setValue(((ConfsFileHandler)this.getSubject()).getActionsFrom(selectedId));
            this.compositeField.setEnable(true);
        }
    }

    public void setSubject(ConfsFileHandler subject) {
        super.setSubject((Object)subject);
    }

    public boolean updateSubject(Field field) {
        if (field == this.selectedConfField) {
            this.refreshFields();
        }
        return false;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setConfiguration(int confId) {
        this.selectedConfField.setIntValue(confId);
        this.refreshFields();
    }
}

