/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.ffi.try2;

import c.builder.CBuilder;
import c.model.ArrayType;
import c.model.Expression;
import c.model.ForStmt;
import c.model.FunctionCall;
import c.model.Statement;
import c.model.StatementGroup;
import c.model.StructureDereference;
import c.model.StructureReference;
import c.model.Type;
import c.model.UnaryExpression;
import c.model.VariableDeclaration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import obp.fiacre.ffi.try2.FFIBindingGenerator;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayedType;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.Field;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.Union;
import obp.fiacre.transfo.FiacreStaticEvaluator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

class TC2FiacreMarshaller
extends ModelVisitor.Stub {
    FFIBindingGenerator client;
    StatementGroup marshallStmts;
    CBuilder cB;
    Stack<Object> fcrContext = new Stack();
    Map<Object, VariableDeclaration> valueMap = new HashMap<Object, VariableDeclaration>();
    Stack<VariableDeclaration> jniObjectContext = new Stack();
    Stack<VariableDeclaration> jniClassContext = new Stack();
    Stack<VariableDeclaration> jniFieldIdContext = new Stack();
    Stack<Integer> jniIndexContext = new Stack();
    Stack<Integer> arraySizeContext = new Stack();
    Stack<Expression> valueContext = new Stack();
    Map<Object, String> jniTypeSignature = new HashMap<Object, String>();
    Stack<StatementGroup> marshallStack = new Stack();

    public TC2FiacreMarshaller(FFIBindingGenerator ffiBindingGenerator, StatementGroup unmarshallStmts) {
        this.client = ffiBindingGenerator;
        this.marshallStmts = unmarshallStmts;
        this.cB = ffiBindingGenerator.cBuilder;
    }

    private String newName() {
        return "tmp" + this.client.currentIdx++;
    }

    FunctionCall createJniCall(String memberName) {
        UnaryExpression envP = this.cB.dereference(this.client.referenceTo("env", this.marshallStmts));
        StructureDereference fctMember = this.cB.dereference(envP, memberName);
        FunctionCall fCall = this.cB.functionCall(fctMember);
        fCall.getArguments().add(this.client.referenceTo("env", this.marshallStmts));
        return fCall;
    }

    public void unmarshallPrimitiveType(obp.fiacre.model.Type toVisit, String type) {
        if (this.inArrayContext() == null) {
            FunctionCall sbfCall = this.createJniCall("Set" + type + "Field");
            sbfCall.getArguments().add(this.cB.reference(this.jniObjectContext.peek()));
            sbfCall.getArguments().add(this.cB.reference(this.jniFieldIdContext.peek()));
            sbfCall.getArguments().add(this.valueContext.peek());
            this.marshallAdd(sbfCall);
        } else {
            FunctionCall sarCall = this.createJniCall("Set" + type + "ArrayRegion");
            sarCall.getArguments().add(this.cB.reference(this.jniObjectContext.peek()));
            sarCall.getArguments().add(this.cB.literal(0));
            sarCall.getArguments().add(this.cB.literal(this.arraySizeContext.peek()));
            sarCall.getArguments().add(this.valueContext.peek());
            this.marshallAdd(sarCall);
        }
    }

    @Override
    public void visitBoolType(BoolType toVisit) {
        this.unmarshallPrimitiveType(toVisit, "Boolean");
    }

    private void marshalInt(obp.fiacre.model.Type toVisit) {
        this.unmarshallPrimitiveType(toVisit, "Int");
    }

    @Override
    public void visitIntType(IntType toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitNatType(NatType toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitInterval(Interval toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitField(Field toVisit) {
        StructureReference strA = this.cB.reference((Expression)EcoreUtil.copy((EObject)this.valueContext.peek()), toVisit.getName());
        FunctionCall gfiCall = this.createJniCall("GetFieldID");
        VariableDeclaration fidxVar = this.cB.variable(this.newName() + "_f" + this.jniIndexContext.peek(), this.cB.externalType("jfieldID"), gfiCall);
        FunctionCall classType = this.createJniCall("FindClass");
        classType.getArguments().add(this.cB.literal(this.jniTypeSignature.get(this.fcrContext.peek())));
        gfiCall.getArguments().add(classType);
        gfiCall.getArguments().add(this.cB.literal(toVisit.getName()));
        gfiCall.getArguments().add(this.cB.literal(this.jniTypeSignature.get(toVisit.getType())));
        this.marshallStmts.getStatements().add(fidxVar);
        if (this.isPrimitiveType(toVisit.getType()) || this.isArray(toVisit.getType())) {
            this.valueContext.push(strA);
            this.jniFieldIdContext.push(fidxVar);
            toVisit.getType().accept(this);
            this.jniFieldIdContext.pop();
            this.valueContext.pop();
            return;
        }
        FunctionCall gofCall = this.createJniCall("GetObjectField");
        gofCall.getArguments().add(this.cB.reference(this.jniObjectContext.peek()));
        gofCall.getArguments().add(this.cB.reference(fidxVar));
        VariableDeclaration objVar = this.cB.variable(this.newName() + "_o", this.cB.externalType("jobject"), gofCall);
        this.marshallAdd(objVar);
        this.jniObjectContext.push(objVar);
        this.valueContext.push(strA);
        toVisit.getType().accept(this);
        this.valueContext.pop();
        this.jniObjectContext.pop();
    }

    @Override
    public void visitRecord(Record toVisit) {
        this.fcrContext.push(toVisit);
        Expression exp = (Expression)EcoreUtil.copy((EObject)this.valueContext.peek());
        int fieldIdx = 0;
        for (Field field : toVisit.getFieldList()) {
            this.valueContext.push(exp);
            this.jniIndexContext.push(fieldIdx);
            field.accept(this);
            this.jniIndexContext.pop();
            this.valueContext.pop();
            ++fieldIdx;
        }
        this.fcrContext.pop();
    }

    void addTo(Statement stmt, StatementGroup group) {
        group.getStatements().add(stmt);
    }

    void marshallAdd(Statement stmt) {
        this.addTo(stmt, this.marshallStmts);
    }

    private void marshalArrayedType(ArrayedType toVisit) {
        Expression result;
        VariableDeclaration jArray;
        this.client.hasArray = true;
        String myName = this.newName();
        int sizeArray = ((NatLiteral)FiacreStaticEvaluator.evaluate(toVisit.getSize())).getValue();
        this.arraySizeContext.push(sizeArray);
        if (!this.isPrimitiveType(toVisit.getType())) {
            FunctionCall classType = this.createJniCall("FindClass");
            classType.getArguments().add(this.cB.literal(this.jniTypeSignature.get(toVisit.getType())));
            FunctionCall objectArrayCall = this.createJniCall("NewObjectArray");
            objectArrayCall.getArguments().add(this.cB.literal(sizeArray));
            objectArrayCall.getArguments().add(classType);
            objectArrayCall.getArguments().add(this.cB.nullLiteral());
            jArray = this.cB.variable(myName + "_jvalue", this.cB.externalType("jobjectArray"), objectArrayCall);
        } else {
            FunctionCall objectArrayCall = this.createJniCall("New" + (this.isBooleanType(toVisit.getType()) ? "Boolean" : "Int") + "Array");
            objectArrayCall.getArguments().add(this.cB.literal(sizeArray));
            jArray = this.cB.variable(myName + "_jvalue", this.cB.externalType("j" + (this.isBooleanType(toVisit.getType()) ? "boolean" : "int") + "Array"), objectArrayCall);
        }
        this.marshallAdd(jArray);
        FunctionCall sofCall = null;
        if (this.inArrayContext() == null) {
            sofCall = this.createJniCall("SetObjectField");
            result = (Expression)EcoreUtil.copy((EObject)this.valueContext.peek());
        } else {
            sofCall = this.createJniCall("SetObjectArrayElement");
            result = this.cB.indexed((Expression)EcoreUtil.copy((EObject)this.valueContext.peek()), this.cB.reference(this.jniFieldIdContext.peek()));
        }
        sofCall.getComment().add("in array");
        sofCall.getArguments().add(this.cB.reference(this.jniObjectContext.peek()));
        sofCall.getArguments().add(this.cB.reference(this.jniFieldIdContext.peek()));
        sofCall.getArguments().add(this.cB.reference(jArray));
        this.marshallAdd(sofCall);
        if (!this.isPrimitiveType(toVisit.getType())) {
            VariableDeclaration vRes = this.cB.variable(myName + "_r", this.getCType(toVisit, this.client.typeMap), result);
            this.marshallAdd(vRes);
            VariableDeclaration sizeA = this.cB.variable(myName + "_size", this.cB.integerType(), this.cB.literal(sizeArray));
            this.marshallAdd(sizeA);
            VariableDeclaration fID = this.cB.variable(myName + "_idx", this.cB.integerType(), this.cB.literal(0));
            ForStmt forS = this.cB.forStmt(fID, this.cB.lt(this.cB.reference(fID), this.cB.reference(sizeA)), this.cB.assign(this.cB.reference(fID), this.cB.inc(this.cB.reference(fID))));
            this.marshallStack.push(this.marshallStmts);
            this.marshallStmts = this.cB.statementGroup(this.marshallStack.peek().getOwner());
            forS.getBody().add(this.marshallStmts);
            this.jniFieldIdContext.push(fID);
            this.fcrContext.push(toVisit);
            this.jniObjectContext.push(jArray);
            this.valueContext.push(result);
            toVisit.getType().accept(this);
            this.valueContext.pop();
            this.jniFieldIdContext.pop();
            this.marshallStmts = this.marshallStack.pop();
            this.marshallAdd(forS);
        } else {
            this.fcrContext.push(toVisit);
            this.jniObjectContext.push(jArray);
            this.valueContext.push(result);
            toVisit.getType().accept(this);
            this.valueContext.pop();
            this.valueMap.put(toVisit, this.valueMap.get(toVisit.getType()));
        }
        FunctionCall delRef = this.createJniCall("DeleteLocalRef");
        delRef.getArguments().add(this.cB.reference(jArray));
        this.marshallAdd(delRef);
        this.arraySizeContext.pop();
        this.fcrContext.pop();
        this.jniObjectContext.pop();
    }

    @Override
    public void visitArray(Array toVisit) {
        this.marshalArrayedType(toVisit);
    }

    @Override
    public void visitUnion(Union toVisit) {
    }

    @Override
    public void visitQueue(Queue toVisit) {
        this.marshalArrayedType(toVisit);
    }

    @Override
    public void visitTypeId(TypeId toVisit) {
        this.fcrContext.push(toVisit);
        toVisit.getDecl().accept(this);
        this.fcrContext.pop();
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        this.fcrContext.push(toVisit);
        toVisit.getIs().accept(this);
        this.fcrContext.pop();
    }

    public ArrayedType inArrayContext() {
        if (this.fcrContext.size() < 1) {
            return null;
        }
        if (this.fcrContext.peek() instanceof ArrayedType) {
            return (ArrayedType)this.fcrContext.peek();
        }
        if (this.fcrContext.size() < 3) {
            return null;
        }
        if (this.fcrContext.peek() instanceof TypeDecl && this.fcrContext.get(this.fcrContext.size() - 3) instanceof ArrayedType) {
            return (ArrayedType)this.fcrContext.get(this.fcrContext.size() - 3);
        }
        return null;
    }

    public boolean isPrimitiveType(obp.fiacre.model.Type type) {
        if (type instanceof BoolType || type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return true;
        }
        if (type instanceof TypeId) {
            return this.isPrimitiveType(((TypeId)type).getDecl().getIs());
        }
        return false;
    }

    public boolean isBooleanType(obp.fiacre.model.Type type) {
        if (type instanceof BoolType) {
            return true;
        }
        if (type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return false;
        }
        if (type instanceof TypeId) {
            return this.isBooleanType(((TypeId)type).getDecl().getIs());
        }
        return false;
    }

    public boolean isArray(obp.fiacre.model.Type type) {
        if (type instanceof BoolType || type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return false;
        }
        if (type instanceof TypeId) {
            return this.isArray(((TypeId)type).getDecl().getIs());
        }
        return type instanceof Array;
    }

    public Type getCType(obp.fiacre.model.Type type, Map<Object, Type> typeMap) {
        if (type instanceof BoolType) {
            return this.cB.booleanType();
        }
        if (type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return this.cB.integerType();
        }
        if (type instanceof ArrayedType) {
            ArrayType arr = this.cB.arrayType(this.getCType(((ArrayedType)type).getType(), typeMap));
            return arr;
        }
        if (type instanceof TypeId) {
            return this.getCType(((TypeId)type).getDecl().getIs(), typeMap);
        }
        if (type instanceof Union) {
            return null;
        }
        return this.client.typeMap.get(type);
    }
}

