/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.matcher;

import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.matcher.Matcher;
import obp.explorer.runtime.obs.ASynchronousCommunicationAction;

public class AsynchronousEventMatcher
extends Matcher {
    private final short commType;
    private final short sourceId;
    private final Matcher messageMatcher;

    public AsynchronousEventMatcher(ExplorationContext context, short commType, short sourceId, Matcher messageMatcher) {
        super(context);
        this.commType = commType;
        this.sourceId = sourceId;
        this.messageMatcher = messageMatcher;
    }

    @Override
    public boolean match(Object argument) {
        if (argument.getClass() == ASynchronousCommunicationAction.class) {
            ASynchronousCommunicationAction action = (ASynchronousCommunicationAction)argument;
            if (this.commType != action.commType) {
                return false;
            }
            if (this.sourceId >= 0 && this.sourceId != action.behaviorId) {
                return false;
            }
            return this.messageMatcher.match(action.message);
        }
        return false;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        if (this.sourceId >= 0) {
            text.append(this.sourceId);
        } else {
            text.append("any");
        }
        text.append(":");
        if (this.commType == 1) {
            text.append("?");
        }
        if (this.commType == 2) {
            text.append("!");
        }
        text.append(" ");
        text.append(this.messageMatcher);
        return text.toString();
    }
}

