/*
 * Decompiled with CFR 0.152.
 */
package obp.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import obp.tool.OutputAnalyzer;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.progress.ActionMonitor;

public abstract class ToolController
implements Runnable {
    private final PrintWriter out;
    private final PrintWriter err;
    private File workingDirectory;
    private ErrorHandler errorHandler;
    private OutputAnalyzer<?> analyzer;
    private InputStream inContentsStream;
    private boolean verbose = true;
    private boolean running = true;
    private final Thread internalThread = new Thread((Runnable)this, this.getClass().getSimpleName());
    private ActionMonitor globalMonitor = null;
    private final List<Object> commandsPipe = Collections.synchronizedList(new LinkedList());
    private final List<Object> resultsStack = Collections.synchronizedList(new LinkedList());
    private String[] env = null;
    private final Runnable clearResultsRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ToolController toolController = ToolController.this;
            synchronized (toolController) {
                ToolController.this.resultsStack.clear();
            }
        }
    };
    private final Runnable popResultRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ToolController toolController = ToolController.this;
            synchronized (toolController) {
                ToolController.this.resultsStack.remove(0);
            }
        }
    };

    public ToolController(PrintWriter out, PrintWriter err) {
        this.out = out;
        this.err = err;
        this.workingDirectory = new File(System.getProperty("user.dir"));
        this.internalThread.start();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler == null ? ErrorHandler.simple : this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String[] getEnv() {
        return this.env;
    }

    public void setEnv(String[] env) {
        this.env = env;
    }

    public void println(String message) {
        this.out.println(message);
    }

    protected synchronized void schedule(Object command) {
        this.commandsPipe.add(command);
    }

    protected synchronized void globalMonitor(ActionMonitor monitor) {
        this.globalMonitor = monitor;
    }

    private synchronized Object command() {
        return this.commandsPipe.remove(0);
    }

    public synchronized boolean hasResult() {
        return this.resultsStack.size() > 0;
    }

    public synchronized <T> boolean isResult(Class<T> type) {
        return type.isInstance(this.resultsStack.get(0));
    }

    public synchronized <T> T popResult(Class<T> type) {
        return type.cast(this.resultsStack.remove(0));
    }

    protected void scheduleClearResult() {
        this.schedule(this.clearResultsRunnable);
    }

    protected void schedulePopResult() {
        this.schedule(this.popResultRunnable);
    }

    protected synchronized void pushResult(Object result) {
        this.resultsStack.add(0, result);
    }

    protected synchronized <T> T peekResult(Class<T> type) {
        return type.cast(this.resultsStack.get(0));
    }

    public synchronized void join() throws InterruptedException {
        this.wait();
    }

    public void interrupt() {
        this.internalThread.interrupt();
    }

    public void stop() {
        this.running = false;
        this.out.flush();
        this.err.flush();
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            try {
                while (this.commandsPipe.isEmpty()) {
                    ToolController toolController = this;
                    synchronized (toolController) {
                        if (this.globalMonitor != null) {
                            ActionMonitor monitor = this.globalMonitor;
                            this.globalMonitor = null;
                            monitor.done();
                        }
                        this.notifyAll();
                    }
                    Thread.sleep(40L);
                }
                Object commandObject = this.command();
                if (commandObject instanceof String[]) {
                    String[] command = (String[])commandObject;
                    if (this.execProcess(command)) continue;
                    throw new InterruptedException("Command failed.");
                }
                if (commandObject.getClass() == File.class) {
                    this.setWorkingDirectory((File)commandObject);
                    continue;
                }
                if (commandObject instanceof Runnable) {
                    ((Runnable)commandObject).run();
                    continue;
                }
                if (commandObject instanceof InputStream) {
                    this.inContentsStream = (InputStream)commandObject;
                    continue;
                }
                if (commandObject instanceof OutputAnalyzer) {
                    this.analyzer = (OutputAnalyzer)commandObject;
                    continue;
                }
                if (!(commandObject instanceof ActionMonitor)) continue;
                ((ActionMonitor)commandObject).done();
            }
            catch (Throwable e) {
                this.err.println("Interruped cause by: " + DiagnosticUtil.createMessage((Throwable)e));
                this.err.flush();
                this.clearCommandsPipe();
                this.cancelMonitor();
            }
        }
    }

    private boolean execProcess(String[] command) throws InterruptedException {
        StringBuilder commandToPrint = new StringBuilder();
        commandToPrint.append("[");
        for (String arg : command) {
            if (commandToPrint.length() > 1) {
                commandToPrint.append(" ");
            }
            commandToPrint.append(arg);
        }
        commandToPrint.append("]");
        this.out.println("Exec: " + commandToPrint);
        boolean booleanStatus = false;
        Process currentProcess = null;
        final StringBuilder outBuffer = new StringBuilder();
        try {
            long processStartDate = System.currentTimeMillis();
            currentProcess = Runtime.getRuntime().exec(command, this.env, this.getWorkingDirectory());
            final BufferedReader outReader = new BufferedReader(new InputStreamReader(currentProcess.getInputStream()));
            final BufferedReader errReader = new BufferedReader(new InputStreamReader(currentProcess.getErrorStream()));
            Thread pumperOut = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line = outReader.readLine();
                        while (line != null) {
                            if (ToolController.this.analyzer != null) {
                                ToolController.this.analyzer.analyze(line);
                            }
                            outBuffer.append(line);
                            outBuffer.append("\n");
                            if (ToolController.this.verbose && (ToolController.this.analyzer == null || !ToolController.this.analyzer.hideOutput())) {
                                ToolController.this.out.println(line);
                            }
                            line = outReader.readLine();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ToolController.this.out.flush();
                }
            });
            pumperOut.start();
            Thread pumperErr = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line = errReader.readLine();
                        while (line != null) {
                            ToolController.this.err.println(line);
                            line = errReader.readLine();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ToolController.this.err.flush();
                }
            });
            pumperErr.start();
            Thread pumperIn = null;
            if (this.inContentsStream != null) {
                final BufferedInputStream bufferedInContentsStream = new BufferedInputStream(this.inContentsStream);
                final BufferedOutputStream bufferedInStream = new BufferedOutputStream(currentProcess.getOutputStream());
                pumperIn = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            byte[] buffer = new byte[1024];
                            int read = 0;
                            while (read >= 0) {
                                bufferedInStream.write(buffer, 0, read);
                                read = bufferedInContentsStream.read(buffer);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            try {
                                bufferedInContentsStream.close();
                                bufferedInStream.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
                pumperIn.start();
                this.inContentsStream = null;
            }
            if (pumperIn != null) {
                pumperIn.join();
            }
            pumperOut.join();
            currentProcess.waitFor();
            pumperErr.join();
            long processEndDate = System.currentTimeMillis();
            double duration = (double)(processEndDate - processStartDate) / 1000.0;
            int status = currentProcess.exitValue();
            if (this.analyzer != null) {
                booleanStatus = this.analyzer.ended(status, duration);
                this.pushResult(this.analyzer.getResult());
            } else {
                booleanStatus = status == 0;
                this.pushResult(outBuffer.toString());
            }
            this.analyzer = null;
            this.out.print("Process last " + duration + "s and exit with " + status + ".\n");
            this.out.flush();
        }
        catch (InterruptedException e) {
            if (currentProcess != null) {
                currentProcess.destroy();
            }
            throw e;
        }
        catch (Exception e) {
            this.out.println(outBuffer.toString());
            this.getErrorHandler().handleError(1, e.getMessage() + ".\n");
            currentProcess = null;
            return false;
        }
        currentProcess = null;
        return booleanStatus;
    }

    private void clearCommandsPipe() {
        while (!this.commandsPipe.isEmpty()) {
            Object command = this.command();
            if (!(command instanceof ActionMonitor)) continue;
            System.err.println("ActionMonitor in the pipe (canceled).");
            ((ActionMonitor)command).canceled();
        }
    }

    private synchronized void cancelMonitor() {
        if (this.globalMonitor != null) {
            this.globalMonitor.canceled();
            this.globalMonitor = null;
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public static String dynamicLibraryExtension() {
        String os = System.getProperty("os.name");
        if (os.contains("Windows")) {
            return "dll";
        }
        if (os.contains("Mac OS X")) {
            return "dylib";
        }
        return "so";
    }

    public static String getBaseName(File fiacreFile) {
        String name = fiacreFile.getName();
        int index = name.lastIndexOf(46);
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }
}

