/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.structure.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.data.Resource;
import obp.if2.structure.Entity;
import obp.if2.structure.Signal;
import obp.if2.structure.Signalroute;
import obp.if2.structure.entities.Process;

public class System
extends Entity {
    private final List<Signal> signalsList = new ArrayList<Signal>();
    private final List<Signalroute> signalroutesList = new ArrayList<Signalroute>();
    private final List<Process> processesList = new ArrayList<Process>();
    private final List<Resource> resourcesList = new ArrayList<Resource>();

    public List<Signal> getSignalsList() {
        return Collections.unmodifiableList(this.signalsList);
    }

    public int getSignalsCount() {
        return this.signalsList.size();
    }

    public Signal getSignals(int index) {
        if (index < 0 || index >= this.getSignalsCount()) {
            return null;
        }
        return this.signalsList.get(index);
    }

    public void addSignals(Signal newValue) {
        this.addSignals(this.getSignalsCount(), newValue);
    }

    public void addSignals(int index, Signal newValue) {
        this.signalsList.add(index, newValue);
    }

    public Signal setSignals(int index, Signal newValue) {
        return this.signalsList.set(index, newValue);
    }

    public void addAllSignals(Collection<Signal> toAddList) {
        for (Signal newValue : toAddList) {
            this.addSignals(this.getSignalsCount(), newValue);
        }
    }

    public void removeSignals(Signal value) {
        int index = this.signalsList.indexOf(value);
        if (index >= 0) {
            this.removeSignals(index);
        }
    }

    public void removeSignals(int index) {
        this.signalsList.remove(index);
    }

    public List<Signalroute> getSignalroutesList() {
        return Collections.unmodifiableList(this.signalroutesList);
    }

    public int getSignalroutesCount() {
        return this.signalroutesList.size();
    }

    public Signalroute getSignalroutes(int index) {
        if (index < 0 || index >= this.getSignalroutesCount()) {
            return null;
        }
        return this.signalroutesList.get(index);
    }

    public void addSignalroutes(Signalroute newValue) {
        this.addSignalroutes(this.getSignalroutesCount(), newValue);
    }

    public void addSignalroutes(int index, Signalroute newValue) {
        this.signalroutesList.add(index, newValue);
    }

    public Signalroute setSignalroutes(int index, Signalroute newValue) {
        return this.signalroutesList.set(index, newValue);
    }

    public void addAllSignalroutes(Collection<Signalroute> toAddList) {
        for (Signalroute newValue : toAddList) {
            this.addSignalroutes(this.getSignalroutesCount(), newValue);
        }
    }

    public void removeSignalroutes(Signalroute value) {
        int index = this.signalroutesList.indexOf(value);
        if (index >= 0) {
            this.removeSignalroutes(index);
        }
    }

    public void removeSignalroutes(int index) {
        this.signalroutesList.remove(index);
    }

    public List<Process> getProcessesList() {
        return Collections.unmodifiableList(this.processesList);
    }

    public int getProcessesCount() {
        return this.processesList.size();
    }

    public Process getProcesses(int index) {
        if (index < 0 || index >= this.getProcessesCount()) {
            return null;
        }
        return this.processesList.get(index);
    }

    public void addProcesses(Process newValue) {
        this.addProcesses(this.getProcessesCount(), newValue);
    }

    public void addProcesses(int index, Process newValue) {
        this.processesList.add(index, newValue);
    }

    public Process setProcesses(int index, Process newValue) {
        return this.processesList.set(index, newValue);
    }

    public void addAllProcesses(Collection<Process> toAddList) {
        for (Process newValue : toAddList) {
            this.addProcesses(this.getProcessesCount(), newValue);
        }
    }

    public void removeProcesses(Process value) {
        int index = this.processesList.indexOf(value);
        if (index >= 0) {
            this.removeProcesses(index);
        }
    }

    public void removeProcesses(int index) {
        this.processesList.remove(index);
    }

    public void addProcessesAndOpposite(Process newValue) {
        this.addProcesses(newValue);
        if (newValue != null) {
            newValue.setSystem(this);
        }
    }

    public void addAllProcessesAndOpposite(Collection<Process> toAddList) {
        for (Process newValue : toAddList) {
            this.addProcessesAndOpposite(this.getProcessesCount(), newValue);
        }
    }

    public void addProcessesAndOpposite(int index, Process newValue) {
        this.addProcesses(index, newValue);
        if (newValue != null) {
            newValue.setSystem(this);
        }
    }

    public Process setProcessesAndOpposite(int index, Process newValue) {
        Process oldValue = this.processesList.set(index, newValue);
        if (newValue != null) {
            newValue.setSystem(this);
        }
        return oldValue;
    }

    public void removeProcessesAndOpposite(Process removed) {
        this.removeProcesses(removed);
        if (removed != null) {
            removed.setSystem(null);
        }
    }

    public void removeProcessesAndOpposite(int index) {
        Process removed = this.processesList.get(index);
        this.removeProcesses(index);
        if (removed != null) {
            removed.setSystem(null);
        }
    }

    public List<Resource> getResourcesList() {
        return Collections.unmodifiableList(this.resourcesList);
    }

    public int getResourcesCount() {
        return this.resourcesList.size();
    }

    public Resource getResources(int index) {
        if (index < 0 || index >= this.getResourcesCount()) {
            return null;
        }
        return this.resourcesList.get(index);
    }

    public void addResources(Resource newValue) {
        this.addResources(this.getResourcesCount(), newValue);
    }

    public void addResources(int index, Resource newValue) {
        this.resourcesList.add(index, newValue);
    }

    public Resource setResources(int index, Resource newValue) {
        return this.resourcesList.set(index, newValue);
    }

    public void addAllResources(Collection<Resource> toAddList) {
        for (Resource newValue : toAddList) {
            this.addResources(this.getResourcesCount(), newValue);
        }
    }

    public void removeResources(Resource value) {
        int index = this.resourcesList.indexOf(value);
        if (index >= 0) {
            this.removeResources(index);
        }
    }

    public void removeResources(int index) {
        this.resourcesList.remove(index);
    }

    @Override
    public void accept(If2Visitor visitor) {
        visitor.visitSystem(this);
    }
}

