/*
 * Decompiled with CFR 0.152.
 */
package spinja.search;

import java.util.Arrays;
import spinja.exceptions.SpinJaException;
import spinja.exceptions.ValidationException;
import spinja.model.Model;
import spinja.model.Transition;
import spinja.search.DepthFirstSearch;
import spinja.search.TransitionCalculator;
import spinja.store.StateStore;

public abstract class NestedDepthFirstSearch<M extends Model<T>, T extends Transition>
extends DepthFirstSearch<M, T> {
    private final Transition enterNestedSearch = new Transition(){

        @Override
        public int getId() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void take() throws ValidationException {
            NestedDepthFirstSearch.this.toggle = true;
            NestedDepthFirstSearch.access$102(NestedDepthFirstSearch.this, NestedDepthFirstSearch.this.storeModel());
        }

        public String toString() {
            return "Enter nested search";
        }

        @Override
        public void undo() {
            NestedDepthFirstSearch.this.toggle = false;
            NestedDepthFirstSearch.access$102(NestedDepthFirstSearch.this, null);
        }
    };
    private static final long serialVersionUID = -6333219782324980671L;
    private boolean toggle = false;
    private byte[] seed = null;

    public NestedDepthFirstSearch(M m, StateStore stateStore, int n, boolean bl, boolean bl2, int n2, TransitionCalculator<M, T> transitionCalculator) {
        super(m, stateStore, n, bl, bl2, n2, transitionCalculator);
    }

    protected abstract boolean conditionHolds();

    protected abstract String getDescription();

    @Override
    protected Transition nextTransition() {
        Transition transition = this.stack.getLastTransition();
        if (transition == this.enterNestedSearch) {
            return null;
        }
        Transition transition2 = this.nextTransition.next(this.model, transition);
        if (transition2 == null && transition != null && !this.toggle && this.conditionHolds()) {
            return this.enterNestedSearch;
        }
        return transition2;
    }

    @Override
    protected byte[] storeModel() {
        this.storage.init(this.model.getSize() + 1);
        this.storage.writeBoolean(this.toggle);
        this.model.encode(this.storage);
        return this.storage.getBuffer();
    }

    @Override
    protected void takeTransition(Transition transition) throws SpinJaException {
        boolean bl = this.toggle;
        super.takeTransition(transition);
        if (bl && this.conditionHolds()) {
            byte[] byArray = this.storeModel();
            if (Arrays.equals(byArray, this.seed)) {
                throw new ValidationException(this.getDescription() + " detected");
            }
            byArray[0] = 0;
            if (this.stack.containsState(byArray)) {
                throw new ValidationException(this.getDescription() + " detected");
            }
        }
    }

    static /* synthetic */ byte[] access$102(NestedDepthFirstSearch nestedDepthFirstSearch, byte[] byArray) {
        nestedDepthFirstSearch.seed = byArray;
        return byArray;
    }
}

