/*
 * Decompiled with CFR 0.152.
 */
package plug.obp_bridge.postmortem;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import obp.explorer.ConfsFileHandler;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.obs.Action;
import obp.explorer.runtime.obs.AtomicAction;
import plug.core.IRuntimeView;
import plug.core.view.ConfigurationItem;
import plug.obp_bridge.postmortem.PostmortemConfiguration;
import plug.obp_bridge.postmortem.PostmortemTransitionRelation;

public class PostmortemRuntimeView
implements IRuntimeView<PostmortemConfiguration, Action> {
    private final PostmortemTransitionRelation runtime;

    public PostmortemRuntimeView(PostmortemTransitionRelation runtime) {
        this.runtime = runtime;
    }

    public PostmortemTransitionRelation getRuntime() {
        return this.runtime;
    }

    public List<ConfigurationItem> getConfigurationItems(PostmortemConfiguration value) {
        Configuration configuration = value.data;
        ConfsFileHandler context = this.runtime.handler;
        ArrayList<ConfigurationItem> processes = new ArrayList<ConfigurationItem>();
        processes.add(new ConfigurationItem("clock", DBM.toConstrainString((short[])configuration.dbm), null, null));
        for (short index = 0; index < context.getBehaviorCount(); index = (short)(index + 1)) {
            Behavior behavior = context.getBehavior(index);
            BehaviorConfiguration processConfiguration = configuration.behaviorConfigurations[index];
            ArrayList<ConfigurationItem> variables = new ArrayList<ConfigurationItem>();
            for (Field field : processConfiguration.getClass().getDeclaredFields()) {
                try {
                    Object fieldValue = field.get(processConfiguration);
                    String name = field.getName();
                    if (name.equals("state")) {
                        variables.add(new ConfigurationItem("state", "@" + behavior.getStateName(((Short)fieldValue).shortValue()), null, null));
                        continue;
                    }
                    variables.add(new ConfigurationItem("variable", name + " = " + this.fieldToString(field, fieldValue), null, null));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            processes.add(new ConfigurationItem("process", behavior.name, null, variables));
        }
        return processes;
    }

    protected String fieldToString(Field field, Object value) {
        if (field.getType().isArray()) {
            int iMax = Array.getLength(value) - 1;
            if (iMax == -1) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            int i = 0;
            while (true) {
                builder.append(Array.get(value, i));
                if (i == Array.getLength(value) - 1) break;
                builder.append(", ");
                ++i;
            }
            builder.append(']');
            return builder.toString();
        }
        if (field.getType().isArray()) {
            return Arrays.deepToString((Object[])value);
        }
        return value.toString();
    }

    public String getFireableTransitionDescription(Action transition) {
        StringBuilder label = new StringBuilder();
        int numberOfDisplayedActions = 0;
        for (AtomicAction action : transition.atomicActions) {
            label.append(action.toFancyString(this.runtime.handler.getSymbols()));
            if (numberOfDisplayedActions > 0) {
                label.append(";");
            }
            ++numberOfDisplayedActions;
        }
        if (numberOfDisplayedActions < 1) {
            return "internal";
        }
        return label.toString();
    }

    public String getActionDescription(Object action) {
        return this.getFireableTransitionDescription((Action)action);
    }
}

