/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.NamedElement;
import obp.if2.data.types.PredefinedType;

public class Signal
implements NamedElement {
    private final List<PredefinedType> parameterTypesList = new ArrayList<PredefinedType>();
    private String name;

    public List<PredefinedType> getParameterTypesList() {
        return Collections.unmodifiableList(this.parameterTypesList);
    }

    public int getParameterTypesCount() {
        return this.parameterTypesList.size();
    }

    public PredefinedType getParameterTypes(int index) {
        if (index < 0 || index >= this.getParameterTypesCount()) {
            return null;
        }
        return this.parameterTypesList.get(index);
    }

    public void addParameterTypes(PredefinedType newValue) {
        this.addParameterTypes(this.getParameterTypesCount(), newValue);
    }

    public void addParameterTypes(int index, PredefinedType newValue) {
        this.parameterTypesList.add(index, newValue);
    }

    public PredefinedType setParameterTypes(int index, PredefinedType newValue) {
        return this.parameterTypesList.set(index, newValue);
    }

    public void addAllParameterTypes(Collection<PredefinedType> toAddList) {
        for (PredefinedType newValue : toAddList) {
            this.addParameterTypes(this.getParameterTypesCount(), newValue);
        }
    }

    public void removeParameterTypes(PredefinedType value) {
        int index = this.parameterTypesList.indexOf(value);
        if (index >= 0) {
            this.removeParameterTypes(index);
        }
    }

    public void removeParameterTypes(int index) {
        this.parameterTypesList.remove(index);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    @Override
    public void accept(If2Visitor visitor) {
        visitor.visitSignal(this);
    }
}

