/*
 * Decompiled with CFR 0.152.
 */
package spinja.util;

import spinja.util.DataReader;
import spinja.util.DataWriter;

public class ByteArrayStorage
implements DataWriter,
DataReader {
    private byte[] buffer;
    private int mark;
    private int storedMark = 0;

    public void init(int n) {
        if (this.buffer == null || this.buffer.length != n) {
            this.buffer = new byte[n];
        }
        this.mark = 0;
        this.storedMark = 0;
    }

    @Override
    public int getMark() {
        return this.mark;
    }

    @Override
    public void storeMark() {
        this.storedMark = this.mark;
    }

    @Override
    public void resetMark() {
        this.mark = this.storedMark;
    }

    @Override
    public void writeBoolean(boolean bl) {
        this.buffer[this.mark++] = (byte)(bl ? 1 : 0);
    }

    @Override
    public void writeByte(int n) {
        this.buffer[this.mark++] = (byte)n;
    }

    @Override
    public void writeShort(int n) {
        this.buffer[this.mark++] = (byte)n;
        this.buffer[this.mark++] = (byte)(n >>> 8);
    }

    @Override
    public void writeInt(int n) {
        this.buffer[this.mark++] = (byte)n;
        this.buffer[this.mark++] = (byte)(n >>> 8);
        this.buffer[this.mark++] = (byte)(n >>> 16);
        this.buffer[this.mark++] = (byte)(n >>> 24);
    }

    @Override
    public boolean readBoolean() {
        return this.buffer[this.mark++] != 0;
    }

    @Override
    public boolean peekBoolean() {
        return this.buffer[this.mark] != 0;
    }

    @Override
    public int readByte() {
        return this.buffer[this.mark++] & 0xFF;
    }

    @Override
    public int peekByte() {
        return this.buffer[this.mark] & 0xFF;
    }

    public int peekByte(int n) {
        return this.buffer[this.mark + n] & 0xFF;
    }

    @Override
    public int readShort() {
        return this.readByte() | this.readByte() << 8;
    }

    @Override
    public int peekShort() {
        return this.peekByte() | this.peekByte(1) << 8;
    }

    @Override
    public int readInt() {
        return this.readByte() | this.readByte() << 8 | this.readByte() << 16 | this.readByte() << 24;
    }

    @Override
    public int peekInt() {
        return this.peekByte() | this.peekByte(1) << 8 | this.peekByte(2) << 16 | this.peekByte(3) << 24;
    }

    public void setBuffer(byte[] byArray) {
        this.buffer = byArray;
        this.mark = 0;
        this.storedMark = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBuffer() {
        try {
            byte[] byArray = this.buffer;
            return byArray;
        }
        finally {
            this.buffer = null;
        }
    }
}

