/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.semantic.Context;
import tla2sany.semantic.InstanceNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tla2sany.xml.SymbolContext;

public class NonLeafProofNode
extends ProofNode {
    private LevelNode[] steps = null;
    private InstanceNode[] insts;
    private Context context;

    public NonLeafProofNode(TreeNode stn, LevelNode[] stps, InstanceNode[] inst, Context ctxt) {
        super(34, stn);
        this.steps = stps;
        this.insts = inst;
        this.context = ctxt;
    }

    public LevelNode[] getSteps() {
        return this.steps;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public boolean levelCheck(int iter) {
        if (this.levelChecked >= iter) {
            return this.levelCorrect;
        }
        LevelNode[] ln = new LevelNode[this.steps.length + this.insts.length];
        System.arraycopy(this.steps, 0, ln, 0, this.steps.length);
        System.arraycopy(this.insts, 0, ln, this.steps.length, this.insts.length);
        return this.levelCheckSubnodes(iter, ln);
    }

    @Override
    public SemanticNode[] getChildren() {
        if (this.steps == null || this.steps.length == 0) {
            return null;
        }
        SemanticNode[] res = new SemanticNode[this.steps.length];
        for (int i = 0; i < this.steps.length; ++i) {
            res[i] = this.steps[i];
        }
        return res;
    }

    @Override
    public void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable) {
        Integer uid = new Integer(this.myUID);
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        for (int i = 0; i < this.steps.length; ++i) {
            this.steps[i].walkGraph(semNodesTable);
        }
        this.context.walkGraph(semNodesTable);
    }

    @Override
    public String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*ProofNode:\n" + super.toString(depth) + Strings.indent(2, "\nsteps:");
        for (int i = 0; i < this.steps.length; ++i) {
            ret = ret + Strings.indent(4, this.steps[i].toString(depth - 1));
        }
        Vector contextEntries = this.context.getContextEntryStringVector(depth - 1, false);
        if (contextEntries != null) {
            for (int i = 0; i < contextEntries.size(); ++i) {
                ret = contextEntries.elementAt(i) != null ? ret + Strings.indent(2, (String)contextEntries.elementAt(i)) : ret + "*** null ***";
            }
        }
        return ret;
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context) {
        Element e = doc.createElement("steps");
        for (int i = 0; i < this.steps.length; ++i) {
            e.appendChild(this.steps[i].export(doc, context));
        }
        return e;
    }
}

