/*
 * Decompiled with CFR 0.152.
 */
package beaver;

import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import java.io.IOException;

public abstract class Parser {
    protected final ParsingTables tables;
    protected final short accept_action_id;
    protected short[] states;
    protected int top;
    protected Symbol[] _symbols;
    protected Events report;

    protected Parser(ParsingTables tables) {
        this.tables = tables;
        this.accept_action_id = (short)(~tables.rule_infos.length);
        this.states = new short[256];
    }

    public Object parse(Scanner source) throws IOException, Exception {
        this.init();
        return this.parse(new TokenStream(source));
    }

    public Object parse(Scanner source, short alt_goal_marker_id) throws IOException, Exception {
        this.init();
        TokenStream in = new TokenStream(source, new Symbol(alt_goal_marker_id));
        return this.parse(in);
    }

    private Object parse(TokenStream in) throws IOException, Exception {
        block0: while (true) {
            Symbol token;
            block5: {
                Symbol nt;
                short act;
                token = in.nextToken();
                while (true) {
                    if ((act = this.tables.findParserAction(this.states[this.top], token.id)) > 0) {
                        this.shift(token, act);
                        continue block0;
                    }
                    if (act == this.accept_action_id) {
                        Symbol goal = this._symbols[this.top];
                        this._symbols = null;
                        return goal.value;
                    }
                    if (act >= 0) break block5;
                    nt = this.reduce(~act);
                    act = this.tables.findNextState(this.states[this.top], nt.id);
                    if (act <= 0) break;
                    this.shift(nt, act);
                }
                if (act == this.accept_action_id) {
                    this._symbols = null;
                    return nt.value;
                }
                throw new IllegalStateException("Cannot shift a nonterminal");
            }
            this.report.syntaxError(token);
            this.recoverFromError(token, in);
        }
    }

    protected abstract Symbol invokeReduceAction(int var1, int var2);

    private void init() {
        if (this.report == null) {
            this.report = new Events();
        }
        this._symbols = new Symbol[this.states.length];
        this.top = 0;
        this._symbols[this.top] = new Symbol("none");
        this.states[this.top] = 1;
    }

    private void increaseStackCapacity() {
        short[] new_states = new short[this.states.length * 2];
        System.arraycopy(this.states, 0, new_states, 0, this.states.length);
        this.states = new_states;
        Symbol[] new_stack = new Symbol[this.states.length];
        System.arraycopy(this._symbols, 0, new_stack, 0, this._symbols.length);
        this._symbols = new_stack;
    }

    private void shift(Symbol sym, short goto_state) {
        if (++this.top == this.states.length) {
            this.increaseStackCapacity();
        }
        this._symbols[this.top] = sym;
        this.states[this.top] = goto_state;
    }

    private Symbol reduce(int rule_id) {
        int rule_info = this.tables.rule_infos[rule_id];
        int rhs_size = rule_info & 0xFFFF;
        this.top -= rhs_size;
        Symbol lhs_sym = this.invokeReduceAction(rule_id, this.top);
        lhs_sym.id = (short)(rule_info >>> 16);
        if (rhs_size == 0) {
            lhs_sym.start = lhs_sym.end = this._symbols[this.top].end;
        } else {
            lhs_sym.start = this._symbols[this.top + 1].start;
            lhs_sym.end = this._symbols[this.top + rhs_size].end;
        }
        return lhs_sym;
    }

    protected void recoverFromError(Symbol token, TokenStream in) throws IOException, Exception {
        short goto_state;
        short first_term_id;
        if (token.id == 0) {
            throw new Exception("Cannot recover from the syntax error");
        }
        in.setMode(true);
        Simulator sim = new Simulator();
        short current_state = this.states[this.top];
        if (!this.tables.compressed && (first_term_id = this.tables.findFirstTerminal(current_state)) >= 0) {
            int index;
            short term_id;
            Symbol term = new Symbol(first_term_id, this._symbols[this.top].end, token.start);
            in.enque(term);
            in.enque(token);
            if (sim.parse(in)) {
                in.rewind();
                in.setMode(false);
                this.report.missingTokenInserted(term);
                return;
            }
            in.rewind();
            int offset = this.tables.actn_offsets[current_state];
            for (term_id = (short)(first_term_id + 1); term_id < this.tables.n_term && (index = offset + term_id) < this.tables.lookaheads.length; term_id = (short)(term_id + 1)) {
                if (this.tables.lookaheads[index] != term_id) continue;
                term.id = term_id;
                if (sim.parse(in)) {
                    in.rewind();
                    in.setMode(false);
                    this.report.missingTokenInserted(term);
                    return;
                }
                in.rewind();
            }
            in.remove(1);
            term.start = token.start;
            term.end = token.end;
            for (term_id = first_term_id; term_id < this.tables.n_term && (index = offset + term_id) < this.tables.lookaheads.length; term_id = (short)(term_id + 1)) {
                if (this.tables.lookaheads[index] != term_id) continue;
                term.id = term_id;
                if (sim.parse(in)) {
                    in.rewind();
                    in.setMode(false);
                    this.report.misspelledTokenReplaced(term);
                    return;
                }
                in.rewind();
            }
            in.remove(0);
        }
        if (sim.parse(in)) {
            in.rewind();
            in.setMode(false);
            this.report.unexpectedTokenRemoved(token);
            return;
        }
        in.rewind();
        Symbol first_sym = token;
        Symbol last_sym = token;
        while ((goto_state = this.tables.findNextState(this.states[this.top], this.tables.error_symbol_id)) <= 0) {
            first_sym = this._symbols[this.top];
            if (--this.top >= 0) continue;
            throw new Exception("Cannot recover from the syntax error");
        }
        Symbol error = new Symbol(this.tables.error_symbol_id, first_sym.start, last_sym.end);
        this.shift(error, goto_state);
        while (!sim.parse(in)) {
            in.rewind();
            if (in.peek().id == 0) {
                throw new Exception("Cannot recover from the syntax error");
            }
            in.remove(0);
        }
        in.rewind();
        error.end = in.peek().end;
        in.setMode(false);
        this.report.errorPhraseRemoved(error);
    }

    public class Simulator {
        private short[] states;
        private int top;
        private int min_top;

        public boolean parse(TokenStream in) throws IOException {
            this.initStack();
            do {
                short act;
                block3: {
                    block4: {
                        Symbol token = in.nextToken();
                        while (true) {
                            if ((act = Parser.this.tables.findParserAction(this.states[this.top], token.id)) > 0) break block3;
                            if (act == Parser.this.accept_action_id) {
                                return true;
                            }
                            if (act >= 0) break block4;
                            short nt_id = this.reduce(~act);
                            if ((act = Parser.this.tables.findNextState(this.states[this.top], nt_id)) <= 0) break;
                            this.shift(act);
                        }
                        return act == Parser.this.accept_action_id;
                    }
                    return false;
                }
                this.shift(act);
            } while (!in.isFull());
            return true;
        }

        private void initStack() throws IOException {
            if (this.states == null || this.states.length < Parser.this.states.length) {
                this.states = new short[Parser.this.states.length];
                this.min_top = 0;
            }
            this.top = Parser.this.top;
            System.arraycopy(Parser.this.states, this.min_top, this.states, this.min_top, this.top + 1);
        }

        private void increaseStackCapacity() {
            short[] new_states = new short[this.states.length * 2];
            System.arraycopy(this.states, 0, new_states, 0, this.states.length);
            this.states = new_states;
        }

        private void shift(short state) {
            if (++this.top == this.states.length) {
                this.increaseStackCapacity();
            }
            this.states[this.top] = state;
        }

        private short reduce(int rule_id) {
            int rule_info = Parser.this.tables.rule_infos[rule_id];
            int rhs_size = rule_info & 0xFFFF;
            this.top -= rhs_size;
            this.min_top = Math.min(this.min_top, this.top);
            return (short)(rule_info >>> 16);
        }
    }

    public class TokenStream {
        public static final boolean BUFFER = true;
        public static final boolean FLUSH = false;
        private static final int BUF_SIZE = 4;
        private static final int IDX_MASK = 3;
        private Scanner scanner;
        private Symbol[] buffer;
        private int idx_add;
        private int idx_get;
        private int ix_mark;

        public TokenStream(Scanner scanner) {
            this.scanner = scanner;
            this.buffer = new Symbol[4];
            this.ix_mark = -1;
        }

        public void setMode(boolean buffering) {
            this.ix_mark = buffering ? this.idx_get : -1;
        }

        public boolean isBuffering() {
            return this.ix_mark >= 0;
        }

        public boolean isEmpty() {
            return this.idx_get == this.idx_add;
        }

        public boolean isFull() {
            return (this.idx_add + 1 & 3) == (this.isBuffering() ? this.ix_mark : this.idx_get);
        }

        public int size() {
            return this.idx_add - this.idx_get + 4 & 3;
        }

        public void enque(Symbol symbol) {
            if (this.isFull()) {
                throw new IllegalStateException("buffer is full");
            }
            this.buffer[this.idx_add++] = symbol;
            this.idx_add &= 3;
        }

        public Symbol peek() {
            if (this.isEmpty()) {
                throw new IllegalStateException("buffer is empty");
            }
            return this.buffer[this.idx_get];
        }

        public Symbol deque() {
            if (this.isEmpty()) {
                throw new IllegalStateException("buffer is empty");
            }
            Symbol symbol = this.buffer[this.idx_get++];
            this.idx_get &= 3;
            return symbol;
        }

        public TokenStream(Scanner scanner, Symbol first_symbol) {
            this(scanner);
            this.enque(first_symbol);
        }

        public Symbol nextToken() throws IOException {
            if (this.isBuffering()) {
                if (this.isEmpty()) {
                    this.enque(this.readToken());
                }
                return this.deque();
            }
            return this.isEmpty() ? this.readToken() : this.deque();
        }

        public void rewind() {
            if (!this.isBuffering()) {
                throw new IllegalStateException("stream is not buffering");
            }
            this.idx_get = this.ix_mark;
        }

        public void remove(int offset) {
            if (!this.isBuffering()) {
                throw new IllegalStateException("stream is not buffering");
            }
            switch (offset) {
                case 0: {
                    this.deque();
                    this.ix_mark = this.idx_get;
                    break;
                }
                case 1: {
                    Symbol s0;
                    this.buffer[this.idx_get] = s0 = this.deque();
                    this.ix_mark = this.idx_get;
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported offset");
                }
            }
        }

        private Symbol readToken() throws IOException {
            while (true) {
                try {
                    return this.scanner.nextToken();
                }
                catch (Scanner.Exception e) {
                    Parser.this.report.scannerError(e);
                    continue;
                }
                break;
            }
        }
    }

    public static class Events {
        public void scannerError(Scanner.Exception e) {
            System.err.print("Scanner Error:");
            if (e.line > 0) {
                System.err.print(e.line);
                System.err.print(',');
                System.err.print(e.column);
                System.err.print(':');
            }
            System.err.print(' ');
            System.err.println(e.getMessage());
        }

        public void syntaxError(Symbol token) {
            System.err.print(Symbol.getLine(token.start));
            System.err.print(',');
            System.err.print(Symbol.getColumn(token.start));
            System.err.print('-');
            System.err.print(Symbol.getLine(token.end));
            System.err.print(',');
            System.err.print(Symbol.getColumn(token.end));
            System.err.print(": Syntax Error: unexpected token ");
            if (token.value != null) {
                System.err.print('\"');
                System.err.print(token.value);
                System.err.println('\"');
            } else {
                System.err.print('#');
                System.err.println(token.id);
            }
        }

        public void unexpectedTokenRemoved(Symbol token) {
            System.err.print(Symbol.getLine(token.start));
            System.err.print(',');
            System.err.print(Symbol.getColumn(token.start));
            System.err.print('-');
            System.err.print(Symbol.getLine(token.end));
            System.err.print(',');
            System.err.print(Symbol.getColumn(token.end));
            System.err.print(": Recovered: removed unexpected token ");
            if (token.value != null) {
                System.err.print('\"');
                System.err.print(token.value);
                System.err.println('\"');
            } else {
                System.err.print('#');
                System.err.println(token.id);
            }
        }

        public void missingTokenInserted(Symbol token) {
            System.err.print(Symbol.getLine(token.start));
            System.err.print(',');
            System.err.print(Symbol.getColumn(token.start));
            System.err.print('-');
            System.err.print(Symbol.getLine(token.end));
            System.err.print(',');
            System.err.print(Symbol.getColumn(token.end));
            System.err.print(": Recovered: inserted missing token ");
            if (token.value != null) {
                System.err.print('\"');
                System.err.print(token.value);
                System.err.println('\"');
            } else {
                System.err.print('#');
                System.err.println(token.id);
            }
        }

        public void misspelledTokenReplaced(Symbol token) {
            System.err.print(Symbol.getLine(token.start));
            System.err.print(',');
            System.err.print(Symbol.getColumn(token.start));
            System.err.print('-');
            System.err.print(Symbol.getLine(token.end));
            System.err.print(',');
            System.err.print(Symbol.getColumn(token.end));
            System.err.print(": Recovered: replaced unexpected token with ");
            if (token.value != null) {
                System.err.print('\"');
                System.err.print(token.value);
                System.err.println('\"');
            } else {
                System.err.print('#');
                System.err.println(token.id);
            }
        }

        public void errorPhraseRemoved(Symbol error) {
            System.err.print(Symbol.getLine(error.start));
            System.err.print(',');
            System.err.print(Symbol.getColumn(error.start));
            System.err.print('-');
            System.err.print(Symbol.getLine(error.end));
            System.err.print(',');
            System.err.print(Symbol.getColumn(error.end));
            System.err.println(": Recovered: removed error phrase");
        }
    }

    public static class Exception
    extends java.lang.Exception {
        Exception(String msg) {
            super(msg);
        }
    }
}

