/*
 * Decompiled with CFR 0.152.
 */
package plug.language.remote;

import java.util.LinkedList;
import java.util.Random;
import plug.core.ILanguagePlugin;
import plug.core.IRuntimeView;
import plug.language.remote.RemoteLoader;
import plug.language.remote.RemoteRuntimeView;
import plug.language.remote.runtime.RemoteRuntime;

public class RemotePlugin
implements ILanguagePlugin<RemoteRuntime> {
    RemoteLoader loader = new RemoteLoader();
    private static final Random random = new Random();
    private static final int startPort = 3456;
    private static final LinkedList<Integer> lastSelectedPorts = new LinkedList();

    public RemotePlugin() {
    }

    public RemotePlugin(RemoteLoader loader) {
        this.loader = loader;
    }

    public String[] getExtensions() {
        return new String[]{".remote"};
    }

    public String getName() {
        return "Remote";
    }

    public RemoteLoader getLoader() {
        return this.loader;
    }

    public IRuntimeView getRuntimeView(RemoteRuntime runtime) {
        return new RemoteRuntimeView(runtime);
    }

    public static int newPort() {
        int port = 3456 + random.nextInt(62079);
        while (lastSelectedPorts.indexOf(port) >= 0) {
            port = 3456 + random.nextInt(62079);
        }
        if (lastSelectedPorts.size() > 10) {
            lastSelectedPorts.removeFirst();
        }
        lastSelectedPorts.addLast(port);
        return port;
    }
}

