/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.transformations;

import java.util.HashSet;
import org.cte.ABCD.ABCDReplacer;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.ABCDWalker;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ArgumentMap;
import org.cte.ABCD.model.declarations.ChannelDecl;
import org.cte.ABCD.model.declarations.ConstantDecl;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.PortMap;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.expressions.Reference;
import org.cte.ABCD.model.kernel.Declaration;
import org.cte.ABCD.model.statements.InputStmt;
import org.cte.ABCD.model.statements.OutputStmt;
import org.cte.ABCD.model.statements.ReceiveStmt;
import org.cte.ABCD.model.statements.SendStmt;
import org.cte.ABCD.model.statements.SpecialTypeStmt;

public class TRemoveUnusedDeclarations {
    public void process(ABCDSystem sys) {
        boolean isStable = false;
        do {
            final HashSet unusedSet = new HashSet();
            sys.accept(new ABCDWalker(new ABCDVisitor.Stub(){

                @Override
                public void visitConstantDecl(ConstantDecl toVisit) {
                    unusedSet.add(toVisit);
                }

                @Override
                public void visitVariableDecl(VariableDecl toVisit) {
                    if (toVisit.getName().equals("toContext")) {
                        return;
                    }
                    unusedSet.add(toVisit);
                }

                @Override
                public void visitChannelDecl(ChannelDecl toVisit) {
                    if (toVisit.getName().equals("toContext")) {
                        return;
                    }
                    unusedSet.add(toVisit);
                }

                @Override
                public void visitProcessDecl(ProcessDecl toVisit) {
                    unusedSet.add(toVisit);
                }

                @Override
                public void visitParameterDecl(ParameterDecl toVisit) {
                    unusedSet.add(toVisit);
                }

                @Override
                public void visitPort(Port toVisit) {
                    unusedSet.add(toVisit);
                }

                @Override
                public void visitPortMap(PortMap toVisit) {
                    unusedSet.add(toVisit);
                }

                @Override
                public void visitArgumentMap(ArgumentMap toVisit) {
                    unusedSet.add(toVisit);
                }
            }));
            sys.accept(new ABCDWalker(new ABCDVisitor.Stub(){

                @Override
                public void visitReference(Reference r) {
                    unusedSet.remove(r.getRef());
                }

                @Override
                public void visitSpecialTypeStmt(SpecialTypeStmt stm) {
                    unusedSet.remove(stm.getReceiver());
                }

                @Override
                public void visitProcessInstance(ProcessInstance pI) {
                    for (PortMap each : pI.getInputsList()) {
                        unusedSet.remove(each.getActual());
                    }
                    for (PortMap each : pI.getOutputsList()) {
                        unusedSet.remove(each.getActual());
                    }
                    unusedSet.remove(pI.getProcess());
                }

                @Override
                public void visitInputStmt(InputStmt stm) {
                    unusedSet.remove(stm.getPort());
                }

                @Override
                public void visitOutputStmt(OutputStmt stm) {
                    unusedSet.remove(stm.getPort());
                }

                @Override
                public void visitPortMap(PortMap pM) {
                    if (pM.getFormal() != null) {
                        unusedSet.remove(pM);
                    }
                }

                @Override
                public void visitSendStmt(SendStmt stm) {
                    unusedSet.remove(stm.getPort());
                }

                @Override
                public void visitReceiveStmt(ReceiveStmt stm) {
                    unusedSet.remove(stm.getPort());
                }

                @Override
                public void visitArgumentMap(ArgumentMap pM) {
                    if (pM.getFormal() != null) {
                        unusedSet.remove(pM);
                    }
                }
            }));
            if (unusedSet.isEmpty()) {
                isStable = true;
                continue;
            }
            ABCDReplacer replacer = new ABCDReplacer();
            for (Declaration vD : unusedSet) {
                replacer.addRemove(vD);
            }
            sys.accept(replacer);
        } while (!isStable);
    }

    public static void runOn(ABCDSystem system) {
        TRemoveUnusedDeclarations me = new TRemoveUnusedDeclarations();
        me.process(system);
    }
}

