/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.sequence;

import obp.ui.sequence.LifeLineElement;
import obp.ui.sequence.Message;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.xid.basics.geometry.Geometry;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.Displayable;
import org.xid.basics.ui.diagram.Element;
import org.xid.basics.ui.diagram.gc.GC;
import org.xid.basics.ui.diagram.gc.GcUtils;

public class MessageElement
extends Element.Stub {
    private final RGB grayRGB = new RGB(240, 240, 240);
    private final float[] sourcePoint;
    private final float[] targetPoint;
    private final Message message;
    private float[] rectangle;
    private float[] textExtent;

    public MessageElement(Message message, float[] sourcePoint, float[] targetPoint) {
        this.message = message;
        this.sourcePoint = sourcePoint != null ? sourcePoint : targetPoint;
        this.targetPoint = targetPoint != null ? targetPoint : sourcePoint;
    }

    public Message getModel() {
        return this.message;
    }

    public float[] getPoint() {
        return this.sourcePoint;
    }

    public void computeBounds(float[] result, DiagramContext context) {
        this.updateRectangle(context);
        Geometry.copyPoints((float[])this.rectangle, (float[])result);
    }

    private void resetRectangle() {
        this.rectangle = null;
    }

    private void updateRectangle(DiagramContext context) {
        if (this.textExtent == null) {
            Point extent = context.getServiceGc().textExtent(this.message.getLabel());
            this.textExtent = new float[]{extent.x, extent.y};
        }
        if (this.rectangle == null) {
            this.rectangle = new float[4];
            if (this.sourcePoint[0] < this.targetPoint[0]) {
                this.rectangle[0] = this.sourcePoint[0];
                this.rectangle[1] = this.sourcePoint[1];
                this.rectangle[2] = this.targetPoint[0];
                this.rectangle[3] = this.targetPoint[1];
            } else {
                this.rectangle[0] = this.targetPoint[0];
                this.rectangle[1] = this.targetPoint[1];
                this.rectangle[2] = this.sourcePoint[0];
                this.rectangle[3] = this.sourcePoint[1];
            }
            float dX = this.textExtent[0] - this.rectangle[2] + this.rectangle[0];
            float dY = this.textExtent[1] - this.rectangle[3] + this.rectangle[1];
            Geometry.expandRectangle((float[])this.rectangle, (float)Math.max(dX, 5.0f), (float)Math.max(dY, 5.0f));
        }
    }

    public void display(GC gc, DiagramContext context) {
        this.updateRectangle(context);
        if (this.sourcePoint != null && this.targetPoint != null) {
            GcUtils.drawLine((GC)gc, (float[])this.sourcePoint, (float[])this.targetPoint);
            gc.setBackground(context.getResources().getSystemColor(2));
            int direction = this.sourcePoint[0] < this.targetPoint[0] ? 0 : 4;
            GcUtils.drawTriangle2((GC)gc, (float)this.targetPoint[0], (float)this.targetPoint[1], (float)5.0f, (float)5.0f, (int)direction, (boolean)true);
        }
        float labelX = (this.sourcePoint[0] + this.targetPoint[0]) / 2.0f;
        float labelY = (this.sourcePoint[1] + this.targetPoint[1]) / 2.0f;
        float halfWidth = this.textExtent[0] / 2.0f;
        Color gray = context.getResources().getColor(this.grayRGB);
        gc.setBackground(gray);
        gc.setForeground(gray);
        GcUtils.drawRoundRectangle((GC)gc, (float)(labelX - halfWidth), (float)(labelY - this.textExtent[1]), (float)(labelX + halfWidth), (float)labelY, (float)5.0f, (float)5.0f, (boolean)true);
        gc.setForeground(context.getResources().getSystemColor(2));
        GcUtils.drawStringAligned((GC)gc, (String)this.message.getLabel(), (float)labelX, (float)labelY, (int)2);
    }

    public void update(DiagramContext context) {
        LifeLineElement source = (LifeLineElement)((Object)context.getDiagram().findElement(LifeLineElement.class, (Object)this.message.getSource()));
        LifeLineElement target = (LifeLineElement)((Object)context.getDiagram().findElement(LifeLineElement.class, (Object)this.message.getTarget()));
        context.invalidate((Displayable)this);
        this.sourcePoint[0] = source != null ? source.getX() : target.getX();
        this.targetPoint[0] = target != null ? target.getX() : source.getX();
        this.resetRectangle();
        context.invalidate((Displayable)this);
    }
}

