/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.cdl.diagram;

import java.util.List;
import obp.cdl.Activity;
import obp.cdl.ActivityReference;
import obp.ui.cdl.diagram.ActivityElement;
import obp.ui.cdl.diagram.CDLDiagram;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.xid.basics.geometry.Geometry;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.Element;
import org.xid.basics.ui.diagram.gc.GC;
import org.xid.basics.ui.diagram.gc.GcUtils;
import org.xid.basics.ui.diagram.interaction.InteractionObject;
import org.xid.basics.ui.diagram.interaction.InteractiveIcon;

public class FoldedActivityElement
extends ActivityElement {
    public static final RGB backgroundRgb = new RGB(140, 250, 210);
    private final ActivityReference model;
    private final int occurences;

    public FoldedActivityElement(ActivityReference model, int occurences, boolean rejoin, float[] northPoint) {
        super(rejoin, northPoint);
        this.model = model;
        this.occurences = occurences;
        this.size[0] = 10.0f + 10.0f * (float)model.getName().length();
        this.size[1] = 80.0f;
    }

    @Override
    public void buildChildren(CDLDiagram diagram) {
    }

    @Override
    public void display(GC gc, DiagramContext context) {
        float[] rectangle = this.getRectangle();
        float[] shadowRetangle = Geometry.copyPoints((float[])rectangle);
        gc.setForeground(context.getResources().getSystemColor(15));
        gc.setBackground(context.getResources().getSystemColor(15));
        Geometry.translatePointsBy((float[])shadowRetangle, (float)3.0f, (float)3.0f);
        GcUtils.drawRoundRectangle((GC)gc, (float[])shadowRetangle, (float)20.0f, (float)20.0f, (boolean)true);
        gc.setForeground(context.getResources().getSystemColor(2));
        gc.setBackground(context.getResources().getColor(backgroundRgb));
        GcUtils.drawRoundRectangle((GC)gc, (float[])rectangle, (float)20.0f, (float)20.0f, (boolean)true);
        float[] center = Geometry.getRectanglePoint((float[])rectangle, (int)-1);
        FontData data = context.getResources().getSystemFont().getFontData()[0];
        data.height = 18.0f;
        gc.setFont(context.getResources().getFont(data));
        GcUtils.drawStringAligned((GC)gc, (String)this.model.getName(), (float)center[0], (float)center[1], (int)-1);
        if (this.occurences > 1) {
            this.displayFrame(gc, context, null, this.occurences);
        }
        super.display(gc, context);
    }

    public void computeInteractionObjects(List<InteractionObject> result, int type, DiagramContext context) {
        if (type == 1) {
            result.add((InteractionObject)new InteractiveIcon((Element)this, 101, this.northPoint, context.getResources().getImage("unfold.gif")));
        }
    }

    @Override
    public Activity getModel() {
        return this.model;
    }
}

