/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.fiacre.model.Exp;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.Statement;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class IfStmt
implements BoostObject,
Statement {
    private Exp condition;
    private Statement then;
    private Statement else_;
    private final List<String> commentList = new ArrayList<String>();

    public IfStmt() {
    }

    protected IfStmt(Boost boost) {
        boost.register((BoostObject)this);
        this.condition = (Exp)boost.readObject(Exp.class);
        this.then = (Statement)boost.readObject(Statement.class);
        this.else_ = (Statement)boost.readObject(Statement.class);
        for (String oneChild : BoostUtil.readStringArray((Boost)boost)) {
            this.commentList.add(oneChild);
        }
    }

    public Exp getCondition() {
        return this.condition;
    }

    public void setCondition(Exp newValue) {
        if (this.condition == null ? newValue != null : !this.condition.equals(newValue)) {
            this.condition = newValue;
        }
    }

    public Statement getThen() {
        return this.then;
    }

    public void setThen(Statement newValue) {
        if (this.then == null ? newValue != null : !this.then.equals(newValue)) {
            this.then = newValue;
        }
    }

    public Statement getElse() {
        return this.else_;
    }

    public void setElse(Statement newValue) {
        if (this.else_ == null ? newValue != null : !this.else_.equals(newValue)) {
            this.else_ = newValue;
        }
    }

    @Override
    public List<String> getCommentList() {
        return Collections.unmodifiableList(this.commentList);
    }

    @Override
    public int getCommentCount() {
        return this.commentList.size();
    }

    @Override
    public String getComment(int index) {
        if (index < 0 || index >= this.getCommentCount()) {
            return null;
        }
        return this.commentList.get(index);
    }

    @Override
    public void addComment(String newValue) {
        this.addComment(this.getCommentCount(), newValue);
    }

    @Override
    public void addComment(int index, String newValue) {
        this.commentList.add(index, newValue);
    }

    @Override
    public String setComment(int index, String newValue) {
        return this.commentList.set(index, newValue);
    }

    @Override
    public void addAllComment(Collection<String> toAddList) {
        for (String newValue : toAddList) {
            this.addComment(this.getCommentCount(), newValue);
        }
    }

    @Override
    public void removeComment(String value) {
        int index = this.commentList.indexOf(value);
        if (index >= 0) {
            this.removeComment(index);
        }
    }

    @Override
    public void removeComment(int index) {
        this.commentList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        boost.writeObject((BoostObject)this.condition);
        boost.writeObject((BoostObject)this.then);
        boost.writeObject((BoostObject)this.else_);
        BoostUtil.writeStringCollection((Boost)boost, this.commentList);
    }

    @Override
    public void accept(ModelVisitor visitor) {
        visitor.visitIfStmt(this);
    }
}

