/*
 * Decompiled with CFR 0.152.
 */
package obp.cdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.cdl.CdlVisitor;
import obp.cdl.Declaration;
import obp.cdl.Element;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class CDLUnit
implements BoostObject,
Element {
    private final List<Declaration> declarationList = new ArrayList<Declaration>();

    public CDLUnit() {
    }

    protected CDLUnit(Boost boost) {
        boost.register((BoostObject)this);
        for (Declaration oneChild : BoostUtil.readObjectList((Boost)boost, Declaration.class)) {
            this.declarationList.add(oneChild);
        }
    }

    public List<Declaration> getDeclarationList() {
        return Collections.unmodifiableList(this.declarationList);
    }

    public int getDeclarationCount() {
        return this.declarationList.size();
    }

    public Declaration getDeclaration(int index) {
        if (index < 0 || index >= this.getDeclarationCount()) {
            return null;
        }
        return this.declarationList.get(index);
    }

    public void addDeclaration(Declaration newValue) {
        this.addDeclaration(this.getDeclarationCount(), newValue);
    }

    public void addDeclaration(int index, Declaration newValue) {
        this.declarationList.add(index, newValue);
    }

    public Declaration setDeclaration(int index, Declaration newValue) {
        return this.declarationList.set(index, newValue);
    }

    public void addAllDeclaration(Collection<Declaration> toAddList) {
        for (Declaration newValue : toAddList) {
            this.addDeclaration(this.getDeclarationCount(), newValue);
        }
    }

    public void removeDeclaration(Declaration value) {
        int index = this.declarationList.indexOf(value);
        if (index >= 0) {
            this.removeDeclaration(index);
        }
    }

    public void removeDeclaration(int index) {
        this.declarationList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        BoostUtil.writeObjectCollection((Boost)boost, this.declarationList);
    }

    @Override
    public void accept(CdlVisitor visitor) {
        visitor.visitCDLUnit(this);
    }
}

